/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.kernelstats;

import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.util.ImageUtil;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.ROI;
import javax.media.jai.RasterFactory;
import org.jaitools.media.jai.kernelstats.KernelStatsOpImage;
import org.jaitools.numeric.Statistic;

public class KernelStatsRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        RenderedImage source = paramBlock.getRenderedSource(0);
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)renderHints);
        if (layout == null) {
            layout = new ImageLayout();
        }
        BorderExtender extender = RIFUtil.getBorderExtenderHint((RenderingHints)renderHints);
        Statistic[] stats = (Statistic[])paramBlock.getObjectParameter(0);
        KernelJAI unRotatedKernel = (KernelJAI)paramBlock.getObjectParameter(1);
        KernelJAI kernel = unRotatedKernel.getRotatedKernel();
        int band = paramBlock.getIntParameter(2);
        SampleModel sm = layout.getSampleModel(null);
        if (sm == null || sm.getNumBands() != stats.length) {
            int dataType = source.getSampleModel().getDataType();
            if (dataType != 4 && dataType != 5) {
                for (Statistic stat : stats) {
                    if (stat.supportsIntegralResult()) continue;
                    dataType = 5;
                    break;
                }
            }
            sm = RasterFactory.createComponentSampleModel((SampleModel)source.getSampleModel(), (int)dataType, (int)source.getWidth(), (int)source.getHeight(), (int)stats.length);
            layout.setSampleModel(sm);
            if (layout.getColorModel(null) != null) {
                ColorModel cm = ImageUtil.getCompatibleColorModel((SampleModel)sm, (Map)renderHints);
                layout.setColorModel(cm);
            }
        }
        ROI roi = (ROI)paramBlock.getObjectParameter(3);
        Boolean maskSrc = (Boolean)paramBlock.getObjectParameter(4);
        Boolean maskDest = (Boolean)paramBlock.getObjectParameter(5);
        Boolean ignoreNaN = (Boolean)paramBlock.getObjectParameter(6);
        Number nilValue = (Number)paramBlock.getObjectParameter(7);
        return new KernelStatsOpImage(paramBlock.getRenderedSource(0), extender, renderHints, layout, stats, kernel, band, roi, maskSrc, maskDest, ignoreNaN, nilValue);
    }
}

