/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.classifiedstats;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Collection;
import java.util.List;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ROI;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.RangeExtendedComparator;
import org.jaitools.numeric.RangeUtils;
import org.jaitools.numeric.Statistic;

public class ClassifiedStatsDescriptor
extends OperationDescriptorImpl {
    private static final long serialVersionUID = -526208282980300507L;
    public static final String CLASSIFIED_STATS_PROPERTY = "ClassifiedStatsProperty";
    static final int DATA_IMAGE = 0;
    static final int CLASSIFIER_IMAGE = 1;
    private static final String[] srcImageNames = new String[]{"dataImage"};
    private static final Class<?>[][] srcImageClasses = new Class[][]{{RenderedImage.class}};
    static final int CLASSIFIER_ARG = 0;
    static final int PIVOT_CLASSIFIER_ARG = 1;
    static final int STATS_ARG = 2;
    static final int BAND_ARG = 3;
    static final int ROI_ARG = 4;
    static final int RANGES_ARG = 5;
    static final int RANGES_TYPE_ARG = 6;
    static final int RANGE_LOCAL_STATS_ARG = 7;
    static final int NODATA_RANGES_ARG = 8;
    static final int NODATA_CLASSIFIER_ARG = 9;
    static final int NODATA_PIVOT_CLASSIFIER_ARG = 10;
    private static final String[] paramNames = new String[]{"classifiers", "pivotClassifiers", "stats", "bands", "roi", "ranges", "rangesType", "rangeLocalStats", "noDataRanges", "noDataClassifiers", "noDataPivotClassifiers"};
    private static final Class<?>[] paramClasses = new Class[]{RenderedImage[].class, RenderedImage[].class, Statistic[].class, Integer[].class, ROI.class, Collection.class, Range.Type.class, Boolean.class, Collection.class, Double[].class, Double[].class};
    private static final Object[] paramDefaults = new Object[]{null, null, NO_PARAMETER_DEFAULT, new Integer[]{0}, null, null, Range.Type.UNDEFINED, Boolean.FALSE, null, null, null};

    public ClassifiedStatsDescriptor() {
        super((String[][])new String[][]{{"GlobalName", "ClassifiedStats"}, {"LocalName", "ClassifiedStats"}, {"Vendor", "org.jaitools.media.jai"}, {"Description", "Calculate neighbourhood statistics"}, {"DocURL", "http://code.google.com/p/jaitools/"}, {"Version", "1.2.0"}, {"arg0Desc", String.format("%s - an array of RenderedImage representing the classifier input images", paramNames[0])}, {"arg1Desc", String.format("%s - an array of RenderedImage representing the pivot classifier input images", paramNames[1])}, {"arg2Desc", String.format("%s - an array of Statistic constants specifying the statistics required", paramNames[2])}, {"arg3Desc", String.format("%s (default %s) - the bands of the data image to process", paramNames[3], paramDefaults[3])}, {"arg4Desc", String.format("%s (default ) - an optional ROI for masking the data image", paramNames[4], paramDefaults[4])}, {"arg5Desc", String.format("%s (default %s) - an optional Collection of Ranges that define dataImage values to include or exclude", paramNames[5], paramDefaults[5])}, {"arg6Desc", String.format("%s (default %s) - whether to include or exclude provided ranges", paramNames[6], paramDefaults[6])}, {"arg7Desc", String.format("%s (default %s) - whether to calculate statistics separately for ranges (when provided)", paramNames[7], paramDefaults[7])}, {"arg8Desc", String.format("%s (default %s) - an optional Collection of Ranges defining values to treat as NODATA", paramNames[8], paramDefaults[8])}, {"arg9Desc", String.format("%s (default %s) - an optional Array of values defining values to treat as NODATA from the classifier raster inputs\nthe i-th element of the array refers to the i-th classifier raster source", paramNames[9], paramDefaults[9])}, {"arg10Desc", String.format("%s (default %s) - an optional Array of values defining values to treat as NODATA from the pivot classifier raster inputs\nthe i-th element of the array refers to the i-th pivot classifier raster source", paramNames[10], paramDefaults[10])}}, new String[]{"rendered"}, srcImageNames, (Class[][])srcImageClasses, paramNames, (Class[])paramClasses, paramDefaults, null);
    }

    public boolean validateArguments(String modeName, ParameterBlock pb, StringBuffer msg) {
        int numPivotClassifier;
        int numClassifiers;
        Object rangesType;
        Object noDataRangeObject;
        Object range;
        int imageSources = pb.getNumSources();
        if (imageSources == 0) {
            msg.append("ClassifiedStats operator takes 1 source image");
            return false;
        }
        Object renderedObjects = pb.getObjectParameter(0);
        RenderedImage[] classifierImages = null;
        if (!(renderedObjects instanceof RenderedImage[])) {
            msg.append(paramNames[0]).append(" arg has to be of type RenderedImage[]");
            return false;
        }
        classifierImages = (RenderedImage[])renderedObjects;
        Object pivotObjects = pb.getObjectParameter(1);
        RenderedImage[] pivotClassifierImages = null;
        if (pivotObjects != null && !(pivotObjects instanceof RenderedImage[])) {
            msg.append(paramNames[1]).append(" arg has to be of type RenderedImage[]");
            return false;
        }
        pivotClassifierImages = (RenderedImage[])pivotObjects;
        Object rangeObject = pb.getObjectParameter(5);
        if (rangeObject != null) {
            boolean ok = true;
            if (rangeObject instanceof Collection) {
                Collection coll = (Collection)rangeObject;
                if (!coll.isEmpty()) {
                    range = coll.iterator().next();
                    if (!(range instanceof Range)) {
                        msg.append(paramNames[5]).append(" arg has to be of type List<Range<Double>>");
                        ok = false;
                    } else {
                        List sortedRanges = RangeUtils.sort(coll);
                        int elements = sortedRanges.size();
                        if (elements > 1) {
                            RangeExtendedComparator rc = new RangeExtendedComparator();
                            List rr = sortedRanges;
                            for (int i = 0; i < elements - 1; ++i) {
                                Range r2;
                                Range r1 = rr.get(i);
                                RangeExtendedComparator.Result result = rc.compare(r1, r2 = rr.get(i + 1));
                                if (!RangeExtendedComparator.isIntersection(result)) continue;
                                ok = false;
                                msg.append(paramNames[5]).append(" arg can't contain intersecting ranges");
                                break;
                            }
                        }
                    }
                }
            } else if (rangeObject != null) {
                ok = false;
                msg.append(paramNames[5]).append(" arg has to be of type List<Range<Double>>");
            }
            if (!ok) {
                return false;
            }
        }
        if ((noDataRangeObject = pb.getObjectParameter(8)) != null) {
            boolean ok = true;
            if (noDataRangeObject instanceof List) {
                range = ((List)noDataRangeObject).get(0);
                if (!(range instanceof Range)) {
                    msg.append(paramNames[8]).append(" arg has to be of type List<Range<Double>>");
                    ok = false;
                }
            } else if (noDataRangeObject != null) {
                ok = false;
                msg.append(paramNames[8]).append(" arg has to be of type List<Range<Double>>");
            }
            if (!ok) {
                return false;
            }
        }
        if ((rangesType = pb.getObjectParameter(6)) != null && rangesType instanceof Range.Type) {
            Range.Type rt = (Range.Type)((Object)rangesType);
            if (rangeObject != null && rt == Range.Type.UNDEFINED) {
                msg.append(paramNames[6]).append(" arg has to be of Type.EXCLUDED or Type.INCLUDED when specifying a Ranges List");
                return false;
            }
        }
        Object bandsObject = pb.getObjectParameter(3);
        Integer[] bands = null;
        if (!(bandsObject instanceof Integer[])) {
            msg.append(paramNames[3]).append(" arg has to be of type Integer[]");
            return false;
        }
        bands = (Integer[])bandsObject;
        RenderedImage dataImg = pb.getRenderedSource(0);
        int imageBands = dataImg.getSampleModel().getNumBands();
        for (Integer band : bands) {
            if (band >= 0 && band < imageBands) continue;
            msg.append("band index out of bounds for source image: ").append(band);
            return false;
        }
        Rectangle dataBounds = new Rectangle(dataImg.getMinX(), dataImg.getMinY(), dataImg.getWidth(), dataImg.getHeight());
        Object roiObject = pb.getObjectParameter(4);
        if (roiObject != null) {
            if (!(roiObject instanceof ROI)) {
                msg.append("The supplied ROI is not a supported class");
                return false;
            }
            if (!((ROI)roiObject).intersects(dataBounds)) {
                msg.append("The supplied ROI does not intersect the source image");
                return false;
            }
        }
        int n = numClassifiers = classifierImages != null ? classifierImages.length : 0;
        if (numClassifiers != 0) {
            for (int i = 0; i < numClassifiers; ++i) {
                RenderedImage classifierImage = classifierImages[i];
                Rectangle classifierBounds = new Rectangle(classifierImage.getMinX(), classifierImage.getMinY(), classifierImage.getWidth(), classifierImage.getHeight());
                int dataType = classifierImage.getSampleModel().getDataType();
                boolean integralType = false;
                if (dataType == 0 || dataType == 3 || dataType == 2 || dataType == 1) {
                    integralType = true;
                }
                if (!integralType) {
                    msg.append("The classifier image must be an integral data type");
                    return false;
                }
                if (classifierBounds.width == dataBounds.width && classifierBounds.height == dataBounds.height && classifierBounds.x == dataBounds.x && classifierBounds.y == dataBounds.y) continue;
                msg.append("Data image bounds and classifier raster bounds should match:\n Data Image: " + dataBounds.toString() + "\n Classifier Image[" + i + "]: " + classifierBounds.toString());
                return false;
            }
        } else {
            msg.append("At least one Classifier input image should be specified");
            return false;
        }
        int n2 = numPivotClassifier = pivotClassifierImages != null ? pivotClassifierImages.length : 0;
        if (numPivotClassifier != 0) {
            for (int i = 0; i < numPivotClassifier; ++i) {
                RenderedImage classifierImage = pivotClassifierImages[i];
                Rectangle classifierBounds = new Rectangle(classifierImage.getMinX(), classifierImage.getMinY(), classifierImage.getWidth(), classifierImage.getHeight());
                int dataType = classifierImage.getSampleModel().getDataType();
                boolean integralType = false;
                if (dataType == 0 || dataType == 3 || dataType == 2 || dataType == 1) {
                    integralType = true;
                }
                if (!integralType) {
                    msg.append("The pivot classifier image must be an integral data type");
                    return false;
                }
                if (classifierBounds.width == dataBounds.width && classifierBounds.height == dataBounds.height && classifierBounds.x == dataBounds.x && classifierBounds.y == dataBounds.y) continue;
                msg.append("Data image bounds and pivot classifier raster bounds should match:\n Data Image: " + dataBounds.toString() + "\n Pivot Classifier Image[" + i + "]: " + classifierBounds.toString());
                return false;
            }
        }
        Object noDataClassifierArg = pb.getObjectParameter(9);
        Double[] noDataClassifier = null;
        if (noDataClassifierArg != null) {
            if (!(noDataClassifierArg instanceof Double[])) {
                msg.append(paramNames[9]).append(" arg has to be of type Double[]");
                return false;
            }
            noDataClassifier = (Double[])noDataClassifierArg;
            if (noDataClassifier.length != numClassifiers) {
                msg.append(paramNames[9]).append(" arg has to have the same number of elements of " + paramNames[0] + " = " + numClassifiers + "whilst its actual size is " + noDataClassifier.length);
            }
        }
        Object noDataPivotClassifierArg = pb.getObjectParameter(10);
        Double[] noDataPivotClassifier = null;
        if (noDataPivotClassifierArg != null) {
            if (!(noDataPivotClassifierArg instanceof Double[])) {
                msg.append(paramNames[10]).append(" arg has to be of type Double[]");
                return false;
            }
            noDataPivotClassifier = (Double[])noDataPivotClassifierArg;
            if (noDataPivotClassifier.length != numPivotClassifier) {
                msg.append(paramNames[10]).append(" arg has to have the same number of elements of " + paramNames[1] + " = " + numPivotClassifier + "whilst its actual size is " + noDataPivotClassifier.length);
            }
        }
        return true;
    }
}

