/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class IDLLogger {
    public static final Level DEBUG = Level.ALL;
    public static final Level INFO = Level.FINEST;
    public static final Level WARN = Level.WARNING;
    public static final Level ERROR = Level.SEVERE;
    public static final Level FATAL_ERROR = Level.SEVERE;
    public static final Level NONE = Level.OFF;
    private static IDLLogger theLogger;
    private Logger logger;

    private IDLLogger(String name, Level level, Writer writer) {
        this.logger = Logger.getLogger(name);
        this.logger.setLevel(level);
        this.logger.addHandler(new StreamHandler(new WriterOutputStream(writer), new SimpleFormatter()));
    }

    public static IDLLogger getLogger(String name, Level level, Writer writer) {
        if (theLogger == null) {
            theLogger = new IDLLogger(name, level, writer);
        }
        return theLogger;
    }

    public void setLevel(Level level) {
        this.logger.setLevel(level);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(INFO);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(WARN);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(ERROR);
    }

    public boolean isFatalErrorEnabled() {
        return this.logger.isLoggable(FATAL_ERROR);
    }

    public boolean isLevelEnabled(Level level) {
        return this.logger.isLoggable(level);
    }

    public void debug(String message) {
        this.logger.log(DEBUG, message);
    }

    public void debug(String message, Throwable th) {
        this.logger.log(DEBUG, message, th);
    }

    public void warn(String message) {
        this.logger.log(WARN, message);
    }

    public void warn(String message, Throwable th) {
        this.logger.log(WARN, message, th);
    }

    public void error(String message) {
        this.logger.log(ERROR, message);
    }

    public void error(String message, Throwable th) {
        this.logger.log(ERROR, message, th);
    }

    public void fatalError(String message) {
        this.logger.log(FATAL_ERROR, message);
    }

    public void fatalError(String message, Throwable th) {
        this.logger.log(FATAL_ERROR, message, th);
    }

    public void info(String message) {
        this.logger.log(INFO, message);
    }

    public void info(String message, Throwable th) {
        this.logger.log(INFO, message, th);
    }

    private class WriterOutputStream
    extends OutputStream {
        protected Writer writer;
        protected String encoding;
        private byte[] buf = new byte[1];

        public WriterOutputStream(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
            this.writer = null;
            this.encoding = null;
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (this.encoding == null) {
                this.writer.write(new String(b));
            } else {
                this.writer.write(new String(b, this.encoding));
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.encoding == null) {
                this.writer.write(new String(b, off, len));
            } else {
                this.writer.write(new String(b, off, len, this.encoding));
            }
        }

        @Override
        public synchronized void write(int b) throws IOException {
            this.buf[0] = (byte)b;
            this.write(this.buf);
        }
    }
}

