/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.maven.plugin.MojoExecutionException;
import org.jacoco.core.tools.ExecDumpClient;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.maven.AbstractJacocoMojo;

public class DumpMojo
extends AbstractJacocoMojo {
    private File destFile;
    private boolean append;
    private boolean dump;
    private boolean reset;
    private String address;
    private int port;
    private int retryCount;

    public void executeMojo() throws MojoExecutionException {
        ExecDumpClient client = new ExecDumpClient(){

            protected void onConnecting(InetAddress address, int port) {
                DumpMojo.this.getLog().info((CharSequence)String.format("Connecting to %s:%s", address, port));
            }

            protected void onConnectionFailure(IOException exception) {
                DumpMojo.this.getLog().info((CharSequence)exception.getMessage());
            }
        };
        client.setDump(this.dump);
        client.setReset(this.reset);
        client.setRetryCount(this.retryCount);
        try {
            ExecFileLoader loader = client.dump(this.address, this.port);
            if (this.dump) {
                this.getLog().info((CharSequence)String.format("Dumping execution data to %s", this.destFile.getAbsolutePath()));
                loader.save(this.destFile, this.append);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to dump coverage data", (Exception)e);
        }
    }
}

