/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.jacoco:jacoco-maven-plugin:0.5.7.201204190339", 0);
        this.append(sb, "", 0);
        this.append(sb, "JaCoCo :: Maven Plugin", 0);
        this.append(sb, "The JaCoCo Maven Plugin provides the JaCoCo runtime agent to your tests and allows basic report creation.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "jacoco:help", 0);
            this.append(sb, "Display help information on jacoco-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jacoco:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "prepare-agent".equals(this.goal)) {
            this.append(sb, "jacoco:prepare-agent", 0);
            this.append(sb, "Prepares a property pointing to the JaCoCo runtime agent that can be passed as a VM argument to the application under test. Depending on the project packaging type by default a property with the following name is set:\n-\ttycho.testArgLine for packaging type eclipse-test-plugin and\n-\targLine otherwise.\nResulting coverage information is collected during execution and by default written to a file when the process terminates.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "address", 2);
                this.append(sb, "IP address or hostname to bind to when the output method is tcpserver or connect to when the output method is tcpclient. In tcpserver mode the value '*' causes the agent to accept connections on any local address.", 3);
                this.append(sb, "Expression: ${jacoco.address}", 3);
                this.append(sb, "", 0);
                this.append(sb, "append", 2);
                this.append(sb, "If set to true and the execution data file already exists, coverage data is appended to the existing file. If set to false, an existing execution data file will be replaced.", 3);
                this.append(sb, "Expression: ${jacoco.append}", 3);
                this.append(sb, "", 0);
                this.append(sb, "destFile (Default: ${project.build.directory}/jacoco.exec)", 2);
                this.append(sb, "Path to the output file for execution data.", 3);
                this.append(sb, "Expression: ${jacoco.destFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "dumpOnExit", 2);
                this.append(sb, "If set to true coverage data will be written on VM shutdown.", 3);
                this.append(sb, "Expression: ${jacoco.dumpOnExit}", 3);
                this.append(sb, "", 0);
                this.append(sb, "exclClassLoaders", 2);
                this.append(sb, "A list of class loader names, that should be excluded from execution analysis. The list entries are separated by a colon (:) and may use wildcard characters (* and ?). This option might be required in case of special frameworks that conflict with JaCoCo code instrumentation, in particular class loaders that do not have access to the Java runtime classes.", 3);
                this.append(sb, "Expression: ${jacoco.exclClassLoaders}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of class files to exclude from instrumentation/analysis/reports. May use wildcard characters (* and ?).", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A list of class files to include in instrumentation/analysis/reports. May use wildcard characters (* and ?). When not specified - everything will be included.", 3);
                this.append(sb, "", 0);
                this.append(sb, "output", 2);
                this.append(sb, "Output method to use for writing coverage data. Valid options are:\n-\tfile: At VM termination execution data is written to the file specified in the destfile.\n-\ttcpserver: The agent listens for incoming connections on the TCP port specified by the address and port. Execution data is written to this TCP connection.\n-\ttcpclient: At startup the agent connects to the TCP port specified by the address and port. Execution data is written to this TCP connection.\n-\tmbean: The agent registers an JMX MBean under the name org.jacoco:type=Runtime.\n", 3);
                this.append(sb, "Expression: ${jacoco.output}", 3);
                this.append(sb, "", 0);
                this.append(sb, "port", 2);
                this.append(sb, "Port to bind to when the output method is tcpserver or connect to when the output method is tcpclient. In tcpserver mode the port must be available, which means that if multiple JaCoCo agents should run on the same machine, different ports have to be specified.", 3);
                this.append(sb, "Expression: ${jacoco.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertyName", 2);
                this.append(sb, "Allows to specify property which will contains settings for JaCoCo Agent. If not specified, then 'argLine' would be used for 'jar' packaging and 'tycho.testArgLine' for 'eclipse-test-plugin'.", 3);
                this.append(sb, "Expression: ${jacoco.propertyName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sessionId", 2);
                this.append(sb, "A session identifier that is written with the execution data. Without this parameter a random identifier is created by the agent.", 3);
                this.append(sb, "Expression: ${jacoco.sessionId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Flag used to suppress execution.", 3);
                this.append(sb, "Expression: ${jacoco.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "report".equals(this.goal)) {
            this.append(sb, "jacoco:report", 0);
            this.append(sb, "Creates a code coverage report for a single project in multiple formats (HTML, XML, and CSV).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "dataFile (Default: ${project.build.directory}/jacoco.exec)", 2);
                this.append(sb, "File with execution data.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of class files to exclude from instrumentation/analysis/reports. May use wildcard characters (* and ?).", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A list of class files to include in instrumentation/analysis/reports. May use wildcard characters (* and ?). When not specified - everything will be included.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory}/jacoco)", 2);
                this.append(sb, "Output directory for the reports. Note that this parameter is only relevant if the goal is run from the command line or from the default build lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: UTF-8)", 2);
                this.append(sb, "Encoding of the generated reports.", 3);
                this.append(sb, "Expression: ${project.reporting.outputEncoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Flag used to suppress execution.", 3);
                this.append(sb, "Expression: ${jacoco.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceEncoding (Default: UTF-8)", 2);
                this.append(sb, "Encoding of the source files.", 3);
                this.append(sb, "Expression: ${project.build.sourceEncoding}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

