/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.lightweightmarkup.linereader;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.logging.Logger;
import org.itsallcode.openfasttrace.api.importer.ImporterException;
import org.itsallcode.openfasttrace.api.importer.input.InputFile;
import org.itsallcode.openfasttrace.importer.lightweightmarkup.linereader.LineContext;
import org.itsallcode.openfasttrace.importer.lightweightmarkup.linereader.LineReaderCallback;

public class LineReader {
    private static final Logger LOG = Logger.getLogger(LineReader.class.getName());
    private final InputFile file;
    private final LineReaderCallback callback;

    public LineReader(InputFile file, LineReaderCallback callback) {
        this.file = file;
        this.callback = callback;
    }

    public void readFile() {
        LOG.finest(() -> "Starting import of file '" + this.file + "'");
        String previousLine = null;
        String currentLine = null;
        String nextLine = null;
        int lineNumber = 0;
        try (BufferedReader reader = this.file.createReader();){
            while ((nextLine = reader.readLine()) != null) {
                if (currentLine != null) {
                    this.callback.nextLine(new LineContext(lineNumber, previousLine, currentLine, nextLine));
                }
                ++lineNumber;
                previousLine = currentLine;
                currentLine = nextLine;
            }
            if (currentLine != null) {
                this.callback.nextLine(new LineContext(lineNumber, previousLine, currentLine, nextLine));
            }
        }
        catch (IOException exception) {
            throw new ImporterException("Error reading '" + this.file.getPath() + "' at line " + lineNumber + ": " + exception.getMessage(), (Throwable)exception);
        }
        this.callback.finishReading();
    }
}

