/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.lightweightmarkup;

import java.util.Arrays;
import java.util.List;
import org.itsallcode.openfasttrace.api.core.SpecificationItemId;

public class ForwardingSpecificationItem {
    public static final String ORIGINAL_MARKER = ":";
    public static final String FORWARD_MARKER = "-->";
    private final String skippedArtifactType;
    private final SpecificationItemId originalId;
    private final SpecificationItemId skippedId;
    private final List<String> targetArtifactTypes;

    public ForwardingSpecificationItem(String forward) {
        int posForwardMarker = forward.indexOf(FORWARD_MARKER);
        int posOriginalMarker = forward.indexOf(ORIGINAL_MARKER);
        this.skippedArtifactType = forward.substring(0, posForwardMarker).trim();
        this.targetArtifactTypes = Arrays.asList(forward.substring(posForwardMarker + FORWARD_MARKER.length(), posOriginalMarker).trim().split(",\\s*"));
        this.originalId = SpecificationItemId.parseId((String)forward.substring(posOriginalMarker + ORIGINAL_MARKER.length()).trim());
        this.skippedId = SpecificationItemId.createId((String)this.skippedArtifactType, (String)this.originalId.getName(), (int)this.originalId.getRevision());
    }

    public String getSkippedArtifactType() {
        return this.skippedArtifactType;
    }

    public SpecificationItemId getOriginalId() {
        return this.originalId;
    }

    public SpecificationItemId getSkippedId() {
        return this.skippedId;
    }

    public List<String> getTargetArtifactTypes() {
        return this.targetArtifactTypes;
    }
}

