/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.api.importer.input;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.itsallcode.openfasttrace.api.importer.input.InputFile;

public class RealFileInput
implements InputFile {
    private final Path path;
    private final Charset charset;

    private RealFileInput(Path path, Charset charset) {
        this.path = path;
        this.charset = charset;
    }

    public static InputFile forPath(Path file) {
        return RealFileInput.forPath(file, StandardCharsets.UTF_8);
    }

    public static InputFile forPath(Path path, Charset charset) {
        return new RealFileInput(path, charset);
    }

    @Override
    public BufferedReader createReader() throws IOException {
        InputStream stream = Files.newInputStream(this.path, new OpenOption[0]);
        InputStreamReader reader = new InputStreamReader(stream, this.charset);
        return new BufferedReader(reader);
    }

    @Override
    public String getPath() {
        return this.path.toString();
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public boolean isRealFile() {
        return true;
    }

    @Override
    public Path toPath() {
        return this.path;
    }
}

