/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.api.exporter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.itsallcode.openfasttrace.api.core.Newline;
import org.itsallcode.openfasttrace.api.core.SpecificationItem;
import org.itsallcode.openfasttrace.api.core.serviceloader.Initializable;
import org.itsallcode.openfasttrace.api.exporter.Exporter;
import org.itsallcode.openfasttrace.api.exporter.ExporterContext;
import org.itsallcode.openfasttrace.api.exporter.ExporterException;

public abstract class ExporterFactory
implements Initializable<ExporterContext> {
    private static final Logger LOG = Logger.getLogger(ExporterFactory.class.getName());
    private final String supportedOutputFormat;
    private ExporterContext context;

    protected ExporterFactory(String supportedOutputFormat) {
        this.supportedOutputFormat = supportedOutputFormat;
    }

    @Override
    public void init(ExporterContext context) {
        this.context = context;
    }

    public ExporterContext getContext() {
        return this.context;
    }

    public boolean supportsFormat(String format) {
        return this.supportedOutputFormat.equals(format);
    }

    public Exporter createExporter(Path file, String format, Charset charset, Newline newline, Stream<SpecificationItem> itemStream) {
        if (!this.supportsFormat(format)) {
            throw new ExporterException("Output format '" + format + "' not supported for export");
        }
        Writer writer = this.createWriter(file, charset);
        return this.createExporter(writer, itemStream, newline);
    }

    private Writer createWriter(Path file, Charset charset) {
        if (file == null) {
            LOG.finest(() -> "Creating exporter for STDOUT using charset " + charset);
            return new OutputStreamWriter((OutputStream)this.getStdOutStream(), charset);
        }
        LOG.finest(() -> "Creating exporter for file " + file + " using charset " + charset);
        return this.createFileWriter(file, charset);
    }

    private PrintStream getStdOutStream() {
        return System.out;
    }

    private Writer createFileWriter(Path file, Charset charset) {
        try {
            return Files.newBufferedWriter(file, charset, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ExporterException("Error creating writer for file " + file, e);
        }
    }

    protected abstract Exporter createExporter(Writer var1, Stream<SpecificationItem> var2, Newline var3);
}

