/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.api.core;

import java.util.List;
import java.util.stream.Collectors;
import org.itsallcode.openfasttrace.api.core.LinkedSpecificationItem;
import org.itsallcode.openfasttrace.api.core.SpecificationItemId;

public class Trace {
    private final List<LinkedSpecificationItem> items;
    private final List<LinkedSpecificationItem> defectItems;

    private Trace(List<LinkedSpecificationItem> items, List<LinkedSpecificationItem> uncleanItems) {
        this.items = items;
        this.defectItems = uncleanItems;
    }

    public boolean hasNoDefects() {
        return this.defectItems.isEmpty();
    }

    public List<LinkedSpecificationItem> getDefectItems() {
        return this.defectItems;
    }

    public List<LinkedSpecificationItem> getItems() {
        return this.items;
    }

    public List<SpecificationItemId> getDefectIds() {
        return this.defectItems.stream().map(LinkedSpecificationItem::getId).collect(Collectors.toList());
    }

    public int countDefects() {
        return this.defectItems.size();
    }

    public int count() {
        return this.items.size();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<LinkedSpecificationItem> items;
        private List<LinkedSpecificationItem> defectItems;

        private Builder() {
        }

        public Builder items(List<LinkedSpecificationItem> items) {
            this.items = items;
            return this;
        }

        public Builder defectItems(List<LinkedSpecificationItem> defectItems) {
            this.defectItems = defectItems;
            return this;
        }

        public Trace build() {
            return new Trace(this.items, this.defectItems);
        }
    }
}

