/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.api;

import java.util.Objects;
import org.itsallcode.openfasttrace.api.ColorScheme;
import org.itsallcode.openfasttrace.api.DetailsSectionDisplay;
import org.itsallcode.openfasttrace.api.core.Newline;
import org.itsallcode.openfasttrace.api.report.ReportVerbosity;

public class ReportSettings {
    private final ReportVerbosity verbosity;
    private final boolean showOrigin;
    private final String outputFormat;
    private final Newline newline;
    private final ColorScheme colorScheme;
    private final DetailsSectionDisplay detailsSectionDisplay;

    private ReportSettings(Builder builder) {
        this.verbosity = builder.verbosity;
        this.showOrigin = builder.showOrigin;
        this.outputFormat = builder.outputFormat;
        this.newline = builder.newline;
        this.colorScheme = Objects.requireNonNull(builder.colorScheme, "colorScheme");
        this.detailsSectionDisplay = Objects.requireNonNull(builder.detailsSectionDisplay, "detailsSectionDisplay");
    }

    public ReportVerbosity getReportVerbosity() {
        return this.verbosity;
    }

    public boolean showOrigin() {
        return this.showOrigin;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public Newline getNewline() {
        return this.newline;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public DetailsSectionDisplay getDetailsSectionDisplay() {
        return this.detailsSectionDisplay;
    }

    public static ReportSettings createDefault() {
        return ReportSettings.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private DetailsSectionDisplay detailsSectionDisplay = DetailsSectionDisplay.COLLAPSE;
        private Newline newline = Newline.UNIX;
        private String outputFormat = "plain";
        private boolean showOrigin = false;
        private ReportVerbosity verbosity = ReportVerbosity.FAILURE_DETAILS;
        private ColorScheme colorScheme = ColorScheme.BLACK_AND_WHITE;

        private Builder() {
        }

        public ReportSettings build() {
            return new ReportSettings(this);
        }

        public Builder verbosity(ReportVerbosity verbosity) {
            this.verbosity = verbosity;
            return this;
        }

        public Builder showOrigin(boolean showOrigin) {
            this.showOrigin = showOrigin;
            return this;
        }

        public Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        public Builder newline(Newline newline) {
            this.newline = newline;
            return this;
        }

        public Builder colorScheme(ColorScheme colorScheme) {
            this.colorScheme = Objects.requireNonNull(colorScheme, "colorScheme");
            return this;
        }

        public Builder detailsSectionDisplay(DetailsSectionDisplay detailsSectionDisplay) {
            this.detailsSectionDisplay = Objects.requireNonNull(detailsSectionDisplay, "detailsSectionDisplay");
            return this;
        }
    }
}

