/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.api;

import java.util.Collections;
import java.util.Set;

public final class FilterSettings {
    private final Set<String> artifactTypes;
    private final Set<String> tags;
    private final boolean withoutTags;

    private FilterSettings(Builder builder) {
        this.artifactTypes = builder.artifactTypes;
        this.tags = builder.tags;
        this.withoutTags = builder.withoutTags;
    }

    public Set<String> getArtifactTypes() {
        return this.artifactTypes;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean withoutTags() {
        return this.withoutTags;
    }

    public boolean isArtifactTypeCriteriaSet() {
        return this.artifactTypes != null && !this.artifactTypes.isEmpty();
    }

    public boolean isTagCriteriaSet() {
        return !this.withoutTags() || this.tags != null && !this.tags.isEmpty();
    }

    public boolean isAnyCriteriaSet() {
        return this.isArtifactTypeCriteriaSet() || this.isTagCriteriaSet();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactTypes == null ? 0 : this.artifactTypes.hashCode());
        result = 31 * result + (this.withoutTags ? 1231 : 1237);
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterSettings)) {
            return false;
        }
        FilterSettings other = (FilterSettings)obj;
        if (this.artifactTypes == null ? other.artifactTypes != null : !this.artifactTypes.equals(other.artifactTypes)) {
            return false;
        }
        if (this.withoutTags != other.withoutTags) {
            return false;
        }
        return !(this.tags == null ? other.tags != null : !this.tags.equals(other.tags));
    }

    public static FilterSettings createAllowingEverything() {
        return FilterSettings.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<String> artifactTypes = Collections.emptySet();
        private Set<String> tags = Collections.emptySet();
        private boolean withoutTags = true;

        private Builder() {
        }

        public Builder artifactTypes(Set<String> artifactTypes) {
            this.artifactTypes = artifactTypes;
            return this;
        }

        public Builder tags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder withoutTags(boolean noTags) {
            this.withoutTags = noTags;
            return this;
        }

        public FilterSettings build() {
            return new FilterSettings(this);
        }
    }
}

