/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.api.importer.tag.config;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.itsallcode.openfasttrace.api.importer.input.InputFile;

public class DescribedPathMatcher {
    private static final String REGEX_PREFIX = "regex:";
    private static final String GLOB_PREFIX = "glob:";
    private final String description;
    private final PathMatcher matcher;

    private DescribedPathMatcher(String description, PathMatcher matcher) {
        this.description = description;
        this.matcher = matcher;
    }

    public static DescribedPathMatcher createPatternMatcher(String pattern) {
        String fullPattern = DescribedPathMatcher.addMissingPatternPrefix(pattern);
        PathMatcher patternMatcher = FileSystems.getDefault().getPathMatcher(fullPattern);
        return new DescribedPathMatcher(fullPattern, patternMatcher);
    }

    public static DescribedPathMatcher createPathListMatcher(List<Path> paths) {
        ListBasedPathMatcher listMatcher = new ListBasedPathMatcher(new HashSet<Path>(paths));
        return new DescribedPathMatcher(paths.toString(), listMatcher);
    }

    private static String addMissingPatternPrefix(String pattern) {
        if (pattern.startsWith(GLOB_PREFIX) || pattern.startsWith(REGEX_PREFIX)) {
            return pattern;
        }
        return GLOB_PREFIX + pattern;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean matches(InputFile path) {
        return this.matcher.matches(Paths.get(path.getPath(), new String[0]));
    }

    public String toString() {
        return this.getDescription();
    }

    private static class ListBasedPathMatcher
    implements PathMatcher {
        private final Set<Path> paths;

        public ListBasedPathMatcher(Set<Path> paths) {
            this.paths = paths;
        }

        @Override
        public boolean matches(Path path) {
            return this.paths.contains(path);
        }
    }
}

