/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.api.core;

public final class Location {
    public static final int NO_LINE = -1;
    public static final int NO_COLUMN = -1;
    private final String path;
    private final int line;
    private final int column;

    private Location(String path, int line, int column) {
        this.path = path;
        this.line = line;
        this.column = column;
    }

    private Location(Builder builder) {
        this.path = builder.path;
        this.line = builder.line;
        this.column = builder.column;
    }

    public static Location create(String path, int line) {
        Location.validateLine(line);
        return new Location(path, line, -1);
    }

    private static void validateLine(int line) {
        if (line <= 0) {
            throw new IllegalArgumentException("Illegal value for line: " + line);
        }
    }

    public static Location create(String path, int line, int column) {
        Location.validateLine(line);
        Location.validateColumn(column);
        return new Location(path, line, column);
    }

    private static void validateColumn(int column) {
        if (column <= 0) {
            throw new IllegalArgumentException("Illegal value for column: " + column);
        }
    }

    public String getPath() {
        return this.path;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + this.line;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (this.column != other.column) {
            return false;
        }
        if (this.line != other.line) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public String toString() {
        return this.path + (String)(this.line != -1 ? ":" + this.line : "") + (String)(this.column != -1 ? ":" + this.column : "");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String path;
        private int line = -1;
        private int column = -1;

        private Builder() {
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder line(int line) {
            this.line = line;
            return this;
        }

        public Builder column(int column) {
            this.column = column;
            return this;
        }

        public Location build() {
            return new Location(this);
        }

        public boolean isCompleteEnough() {
            return this.path != null && !this.path.isEmpty();
        }
    }
}

