/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.junit.sysextensions.security;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;
import org.itsallcode.junit.sysextensions.security.ExitTrapException;

public class ExitGuardSecurityManager
extends SecurityManager {
    private boolean trapExit;
    private final SecurityManager delegate;

    public ExitGuardSecurityManager(SecurityManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public synchronized void checkExit(int status) {
        if (this.trapExit) {
            this.trapExit = false;
            throw new ExitTrapException(this.getClass().getSimpleName() + " intercepted a System.exit(" + status + ").", status);
        }
    }

    @Override
    public void checkPermission(Permission perm) {
    }

    public void trapExit(boolean trapExit) {
        this.trapExit = trapExit;
    }

    private boolean hasDelegate() {
        return this.delegate != null;
    }

    @Override
    public void checkAccept(String host, int port) {
        if (this.hasDelegate()) {
            this.delegate.checkAccept(host, port);
        }
    }

    @Override
    public void checkAccess(Thread thread) {
        if (this.hasDelegate()) {
            this.delegate.checkAccess(thread);
        }
    }

    @Override
    public void checkAccess(ThreadGroup group) {
        if (this.hasDelegate()) {
            this.delegate.checkAccess(group);
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        if (this.hasDelegate()) {
            this.delegate.checkConnect(host, port, context);
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        if (this.hasDelegate()) {
            this.delegate.checkConnect(host, port);
        }
    }

    @Override
    public void checkCreateClassLoader() {
        if (this.hasDelegate()) {
            this.delegate.checkCreateClassLoader();
        }
    }

    @Override
    public void checkDelete(String file) {
        if (this.hasDelegate()) {
            this.delegate.checkDelete(file);
        }
    }

    @Override
    public void checkExec(String cmd) {
        if (this.hasDelegate()) {
            this.delegate.checkExec(cmd);
        }
    }

    @Override
    public void checkLink(String lib) {
        if (this.hasDelegate()) {
            this.delegate.checkLink(lib);
        }
    }

    @Override
    public void checkListen(int port) {
        if (this.hasDelegate()) {
            this.delegate.checkListen(port);
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
        if (this.hasDelegate()) {
            this.delegate.checkMulticast(maddr);
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (this.hasDelegate()) {
            this.delegate.checkPackageAccess(pkg);
        }
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        if (this.hasDelegate()) {
            this.delegate.checkPackageDefinition(pkg);
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (this.hasDelegate()) {
            this.delegate.checkPermission(perm, context);
        }
    }

    @Override
    public void checkPrintJobAccess() {
        if (this.hasDelegate()) {
            this.delegate.checkPrintJobAccess();
        }
    }

    @Override
    public void checkPropertiesAccess() {
        if (this.hasDelegate()) {
            this.delegate.checkPropertiesAccess();
        }
    }

    @Override
    public void checkPropertyAccess(String key) {
        if (this.hasDelegate()) {
            this.delegate.checkPropertyAccess(key);
        }
    }

    @Override
    public void checkRead(FileDescriptor fd) {
        if (this.hasDelegate()) {
            this.delegate.checkRead(fd);
        }
    }

    @Override
    public void checkRead(String file, Object context) {
        if (this.hasDelegate()) {
            this.delegate.checkRead(file, context);
        }
    }

    @Override
    public void checkRead(String file) {
        if (this.hasDelegate()) {
            this.delegate.checkRead(file);
        }
    }

    @Override
    public void checkSecurityAccess(String target) {
        if (this.hasDelegate()) {
            this.delegate.checkSecurityAccess(target);
        }
    }

    @Override
    public void checkSetFactory() {
        if (this.hasDelegate()) {
            this.delegate.checkSetFactory();
        }
    }

    @Override
    public void checkWrite(FileDescriptor fileDescriptor) {
        if (this.hasDelegate()) {
            this.delegate.checkWrite(fileDescriptor);
        }
    }

    @Override
    public void checkWrite(String file) {
        if (this.hasDelegate()) {
            this.delegate.checkWrite(file);
        }
    }
}

