/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.junit.sysextensions;

import org.itsallcode.junit.sysextensions.security.ExitGuardSecurityManager;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

@Deprecated(since="1.2.1", forRemoval=true)
public final class ExitGuard
implements TestInstancePostProcessor,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
AfterAllCallback {
    private static final String PREVIOUS_SECURITY_MANAGER_KEY = "PREV_SECMAN";
    private static final String EXIT_GUARD_SECURITY_MANAGER_KEY = "EXIT_SECMAN";

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        ExitGuard.saveCurrentSecurityManager(context);
        ExitGuard.installExitGuardSecurityManager(context);
    }

    private static void saveCurrentSecurityManager(ExtensionContext context) {
        context.getStore(ExitGuard.getNamespace()).put((Object)PREVIOUS_SECURITY_MANAGER_KEY, (Object)System.getSecurityManager());
    }

    private static void installExitGuardSecurityManager(ExtensionContext context) {
        SecurityManager previousSecurityManager = ExitGuard.getPreviousSecurityManager(context);
        ExitGuardSecurityManager exitGuardSecurityManager = new ExitGuardSecurityManager(previousSecurityManager);
        System.setSecurityManager(exitGuardSecurityManager);
        context.getStore(ExitGuard.getNamespace()).put((Object)EXIT_GUARD_SECURITY_MANAGER_KEY, (Object)exitGuardSecurityManager);
    }

    private static ExtensionContext.Namespace getNamespace() {
        return ExtensionContext.Namespace.create((Object[])new Object[]{ExitGuard.class});
    }

    private static ExitGuardSecurityManager getExitGuardSecurityManager(ExtensionContext context) {
        return (ExitGuardSecurityManager)context.getStore(ExitGuard.getNamespace()).get((Object)EXIT_GUARD_SECURITY_MANAGER_KEY);
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        ExitGuard.getExitGuardSecurityManager(context).trapExit(true);
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        ExitGuard.getExitGuardSecurityManager(context).trapExit(false);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        SecurityManager previousManager = ExitGuard.getPreviousSecurityManager(context);
        System.setSecurityManager(previousManager);
    }

    private static SecurityManager getPreviousSecurityManager(ExtensionContext context) {
        return (SecurityManager)context.getStore(ExitGuard.getNamespace()).get((Object)PREVIOUS_SECURITY_MANAGER_KEY);
    }
}

