/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.junit.sysextensions;

import java.util.logging.Logger;
import org.itsallcode.junit.sysextensions.security.ExitTrapException;
import org.junit.jupiter.api.Assertions;

public final class AssertExit {
    private static final Logger LOGGER = Logger.getLogger(AssertExit.class.getName());

    private AssertExit() {
    }

    public static void assertExit(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (ExitTrapException exception) {
            LOGGER.fine(() -> "Caught ExitTrapException " + exception + " with exit status " + exception.getExitStatus());
            return;
        }
        AssertExit.failMissingExit();
    }

    private static void failMissingExit() {
        Assertions.fail((String)"Lambda did not cause a system exit as expected.");
    }

    public static void assertExitWithStatus(int expectedExitCode, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (ExitTrapException exception) {
            LOGGER.fine(() -> "Caught ExitTrapException " + exception + " with exit status " + exception.getExitStatus());
            Assertions.assertEquals((int)expectedExitCode, (int)exception.getExitStatus(), (String)"Expected exit status code");
            return;
        }
        AssertExit.failMissingExit();
    }
}

