/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.junit.sysextensions;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.nio.charset.StandardCharsets;
import org.itsallcode.io.Capturable;
import org.itsallcode.io.CapturingOutputStream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public abstract class AbstractSystemOutputGuard
implements BeforeEachCallback,
ParameterResolver,
AfterEachCallback {
    protected static final String PREVIOUS_OUTPUT_STREAM_KEY = "PREV_OSTREAM";
    protected static final String CAPTURING_OUTPUT_STREAM_KEY = "CAPT_OSTREAM";

    protected AbstractSystemOutputGuard() {
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.saveCurrentSystemStream(context);
        this.flushSystemStream();
        this.replaceSystemStreamWithCapturingStream(context);
    }

    private void saveCurrentSystemStream(ExtensionContext context) {
        context.getStore(this.getNamespace()).put((Object)PREVIOUS_OUTPUT_STREAM_KEY, (Object)this.getSystemStream());
    }

    protected abstract ExtensionContext.Namespace getNamespace();

    protected abstract PrintStream getSystemStream();

    private void flushSystemStream() {
        this.getSystemStream().flush();
    }

    private void replaceSystemStreamWithCapturingStream(ExtensionContext context) {
        CapturingOutputStream capturingStream = new CapturingOutputStream(this.getSystemStream());
        context.getStore(this.getNamespace()).put((Object)CAPTURING_OUTPUT_STREAM_KEY, (Object)capturingStream);
        PrintStream printStream = new PrintStream((OutputStream)this.getCapturingOutputStream(context), false, StandardCharsets.UTF_8);
        this.setSystemStream(printStream);
    }

    protected abstract void setSystemStream(PrintStream var1);

    protected CapturingOutputStream getCapturingOutputStream(ExtensionContext context) {
        return (CapturingOutputStream)context.getStore(this.getNamespace()).get((Object)CAPTURING_OUTPUT_STREAM_KEY);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.isViableMethod(parameterContext) && this.isParameterCapturingStream(parameterContext) && this.isCompatibleAnnotation(parameterContext);
    }

    protected boolean isViableMethod(ParameterContext parameterContext) {
        Executable method = parameterContext.getDeclaringExecutable();
        return method.isAnnotationPresent(Test.class) || method.isAnnotationPresent(BeforeEach.class);
    }

    protected boolean isParameterCapturingStream(ParameterContext parameterContext) {
        return parameterContext.getParameter().getType().equals(Capturable.class);
    }

    private boolean isCompatibleAnnotation(ParameterContext parameterContext) {
        Parameter parameter = parameterContext.getParameter();
        return parameter.getAnnotations().length == 0 || parameter.isAnnotationPresent(this.getParameterAnnotation());
    }

    protected abstract Class<? extends Annotation> getParameterAnnotation();

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.getCapturingOutputStream(extensionContext);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.restorePreviousSystemStream(context);
        this.closeCapturingOutputStream(context);
    }

    private void restorePreviousSystemStream(ExtensionContext context) {
        this.setSystemStream(this.getPreviousStream(context));
    }

    protected PrintStream getPreviousStream(ExtensionContext context) {
        return (PrintStream)context.getStore(this.getNamespace()).get((Object)PREVIOUS_OUTPUT_STREAM_KEY);
    }

    protected void closeCapturingOutputStream(ExtensionContext context) {
        try {
            this.getCapturingOutputStream(context).close();
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Failed to close capturing output stream", exception);
        }
    }
}

