/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.itsallcode.io.Capturable;

public class CapturingOutputStream
extends OutputStream
implements Capturable {
    private OutputStream targetStream;
    private ByteArrayOutputStream internalStream;
    private String captureBuffer;
    private boolean forwardOutputToTarget = true;

    public CapturingOutputStream(OutputStream targetStream) {
        this.targetStream = Objects.requireNonNull(targetStream, "targetStream");
    }

    @Override
    public void write(int b) throws IOException {
        if (this.internalStream != null) {
            this.internalStream.write(b);
        }
        if (this.forwardOutputToTarget && this.targetStream != null) {
            this.targetStream.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.internalStream != null) {
            this.internalStream.write(b, off, len);
        }
        if (this.forwardOutputToTarget && this.targetStream != null) {
            this.targetStream.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.internalStream != null) {
            this.internalStream.flush();
        }
        if (this.targetStream != null) {
            this.targetStream.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.internalStream != null) {
            this.captureBuffer = this.internalStream.toString(StandardCharsets.UTF_8);
            this.internalStream.close();
        }
        this.internalStream = null;
        this.targetStream = null;
        super.close();
    }

    @Override
    public void capture() {
        this.internalStream = new ByteArrayOutputStream();
    }

    @Override
    public void captureMuted() {
        this.forwardOutputToTarget = false;
        this.capture();
    }

    @Override
    public String getCapturedData() {
        if (this.internalStream == null) {
            return this.getDataFromCaptureBuffer();
        }
        return this.internalStream.toString(StandardCharsets.UTF_8);
    }

    private String getDataFromCaptureBuffer() {
        return this.captureBuffer == null ? "" : this.captureBuffer;
    }
}

