/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.test;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.test.CMSTestUtil;
import org.bouncycastle.mail.smime.SMIMECompressed;
import org.bouncycastle.mail.smime.SMIMECompressedGenerator;
import org.bouncycastle.mail.smime.SMIMECompressedParser;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.test.SMIMETestSetup;
import org.bouncycastle.mail.smime.test.SMIMETestUtil;
import org.bouncycastle.util.Arrays;

public class SMIMECompressedTest
extends TestCase {
    private static final String COMPRESSED_CONTENT_TYPE = "application/pkcs7-mime; name=\"smime.p7z\"; smime-type=compressed-data";
    boolean DEBUG = true;
    MimeBodyPart msg = SMIMETestUtil.makeMimeBodyPart("Hello world!");
    String signDN = "O=Bouncy Castle, C=AU";
    KeyPair signKP = CMSTestUtil.makeKeyPair();
    X509Certificate signCert = CMSTestUtil.makeCertificate(this.signKP, this.signDN, this.signKP, this.signDN);
    String origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
    KeyPair origKP = CMSTestUtil.makeKeyPair();
    X509Certificate origCert = CMSTestUtil.makeCertificate(this.origKP, this.origDN, this.signKP, this.signDN);
    String reciDN;
    KeyPair reciKP;
    X509Certificate reciCert;
    KeyPair dsaSignKP;
    X509Certificate dsaSignCert;
    KeyPair dsaOrigKP;
    X509Certificate dsaOrigCert;

    public SMIMECompressedTest(String name) throws Exception {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(SMIMECompressedTest.class);
    }

    public static Test suite() {
        return new SMIMETestSetup((Test)new TestSuite(SMIMECompressedTest.class));
    }

    public void testHeaders() throws Exception {
        SMIMECompressedGenerator cgen = new SMIMECompressedGenerator();
        MimeBodyPart cbp = cgen.generate(this.msg, "1.2.840.113549.1.9.16.3.8");
        SMIMECompressedTest.assertEquals((String)COMPRESSED_CONTENT_TYPE, (String)cbp.getHeader("Content-Type")[0]);
        SMIMECompressedTest.assertEquals((String)"attachment; filename=\"smime.p7z\"", (String)cbp.getHeader("Content-Disposition")[0]);
        SMIMECompressedTest.assertEquals((String)"S/MIME Compressed Message", (String)cbp.getHeader("Content-Description")[0]);
    }

    public void testBasic() throws Exception {
        SMIMECompressedGenerator cgen = new SMIMECompressedGenerator();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        MimeBodyPart cbp = cgen.generate(this.msg, "1.2.840.113549.1.9.16.3.8");
        SMIMECompressed sc = new SMIMECompressed(cbp);
        this.msg.writeTo((OutputStream)bOut);
        SMIMECompressedTest.assertTrue((boolean)Arrays.areEqual((byte[])bOut.toByteArray(), (byte[])sc.getContent()));
    }

    public void testParser() throws Exception {
        int ch;
        SMIMECompressedGenerator cgen = new SMIMECompressedGenerator();
        ByteArrayOutputStream bOut1 = new ByteArrayOutputStream();
        ByteArrayOutputStream bOut2 = new ByteArrayOutputStream();
        MimeBodyPart cbp = cgen.generate(this.msg, "1.2.840.113549.1.9.16.3.8");
        SMIMECompressedParser sc = new SMIMECompressedParser(cbp);
        this.msg.writeTo((OutputStream)bOut1);
        InputStream in = sc.getContent().getContentStream();
        while ((ch = in.read()) >= 0) {
            bOut2.write(ch);
        }
        SMIMECompressedTest.assertTrue((boolean)Arrays.areEqual((byte[])bOut1.toByteArray(), (byte[])bOut2.toByteArray()));
    }

    public void testCompressedSHA1WithRSA() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(this.origCert);
        certList.add(this.signCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
        ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
        SMIMECapabilityVector caps = new SMIMECapabilityVector();
        caps.addCapability(SMIMECapability.dES_EDE3_CBC);
        caps.addCapability(SMIMECapability.rC2_CBC, 128);
        caps.addCapability(SMIMECapability.dES_CBC);
        signedAttrs.add((DEREncodable)new SMIMECapabilitiesAttribute(caps));
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSigner(this.origKP.getPrivate(), this.origCert, SMIMESignedGenerator.DIGEST_SHA1, new AttributeTable(signedAttrs), null);
        gen.addCertificatesAndCRLs(certs);
        MimeMultipart smp = gen.generate(this.msg, "BC");
        MimeMessage bp2 = new MimeMessage((Session)null);
        bp2.setContent((Multipart)smp);
        bp2.saveChanges();
        SMIMECompressedGenerator cgen = new SMIMECompressedGenerator();
        MimeBodyPart cbp = cgen.generate(bp2, "1.2.840.113549.1.9.16.3.8");
        SMIMECompressed cm = new SMIMECompressed(cbp);
        MimeMultipart mm = (MimeMultipart)SMIMEUtil.toMimeBodyPart(cm.getContent()).getContent();
        SMIMESigned s = new SMIMESigned(mm);
        ByteArrayOutputStream _baos = new ByteArrayOutputStream();
        this.msg.writeTo((OutputStream)_baos);
        _baos.close();
        byte[] _msgBytes = _baos.toByteArray();
        _baos = new ByteArrayOutputStream();
        s.getContent().writeTo((OutputStream)_baos);
        _baos.close();
        byte[] _resBytes = _baos.toByteArray();
        SMIMECompressedTest.assertEquals((boolean)true, (boolean)Arrays.areEqual((byte[])_msgBytes, (byte[])_resBytes));
        certs = s.getCertificatesAndCRLs("Collection", "BC");
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        for (SignerInformation signer : c) {
            Collection<? extends Certificate> certCollection = certs.getCertificates(signer.getSID());
            Iterator<? extends Certificate> certIt = certCollection.iterator();
            X509Certificate cert = (X509Certificate)certIt.next();
            SMIMECompressedTest.assertEquals((boolean)true, (boolean)signer.verify(cert, "BC"));
        }
    }
}

