/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.runtime.configuration;

import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.util.Optional;

@ConfigMapping(prefix="iris")
@ConfigRoot(phase=ConfigPhase.RUN_TIME, prefix="quarkus")
public interface IrisConfig {
    @WithDefault(value="1000")
    public long backoffIntervalMillis();

    @WithDefault(value="1.5")
    public double backoffMultiplier();

    @WithName(value="backoff-max-interval-millis")
    @WithDefault(value="30000")
    public long backoffMaxIntervalMillis();

    @WithDefault(value="10")
    public int maxRetries();

    @WithDefault(value="1")
    public long confirmationBatchSize();

    @WithName(value="retry-max-count")
    @WithDefault(value="3")
    public int retryMaxCount();

    @WithDefault(value="2000")
    public int rpcTimeout();

    @WithName(value="rabbitmq-host")
    @WithDefault(value="${rabbitmq-host:localhost}")
    public String host();

    @WithName(value="rabbitmq-protocol")
    @WithDefault(value="${rabbitmq-protocol}")
    public Optional<String> protocol();

    @WithName(value="rabbitmq-port")
    @WithDefault(value="${rabbitmq-port}")
    public Optional<Integer> port();

    @WithName(value="rabbitmq-ssl")
    @WithDefault(value="${rabbitmq-ssl}")
    public Optional<Boolean> ssl();

    @WithName(value="rabbitmq-username")
    @WithDefault(value="${rabbitmq-username:guest}")
    public String username();

    @WithName(value="rabbitmq-password")
    @WithDefault(value="${rabbitmq-password:guest}")
    public String password();

    @WithName(value="rabbitmq-virtual-host")
    @WithDefault(value="${rabbitmq-virtual-host:/}")
    public String virtualHost();

    default public int getPort() {
        return this.protocol().map(protocol -> switch (protocol) {
            case "amqp" -> this.port().orElse(5672);
            case "amqps" -> this.port().orElse(5671);
            default -> throw new IllegalStateException("Unknown protocol value: " + protocol);
        }).orElseGet(() -> this.port().orElse(5672));
    }

    default public boolean isSsl() {
        return this.protocol().map(protocol -> switch (protocol) {
            case "amqp" -> this.ssl().orElse(false);
            case "amqps" -> this.ssl().orElse(true);
            default -> throw new IllegalStateException("Unknown protocol value: " + protocol);
        }).orElseGet(() -> this.ssl().orElse(false));
    }
}

