/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.runtime.channel;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.iris_events.runtime.channel.ChannelService;
import org.iris_events.runtime.configuration.IrisConfig;
import org.iris_events.runtime.connection.AbstractConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelService
implements ChannelService {
    private static final Logger log = LoggerFactory.getLogger(AbstractChannelService.class);
    private final ConcurrentHashMap<String, Channel> channelMap = new ConcurrentHashMap();
    private AbstractConnectionProvider connectionProvider;
    private IrisConfig config;

    protected AbstractChannelService() {
    }

    protected AbstractChannelService(AbstractConnectionProvider connectionProvider, IrisConfig config) {
        this.connectionProvider = connectionProvider;
        this.config = config;
    }

    @Override
    public Channel getOrCreateChannelById(String channelId) {
        Channel channel = this.channelMap.get(channelId);
        if (channel != null && channel.isOpen()) {
            return channel;
        }
        return this.channelMap.compute(channelId, (key, value) -> this.createChannel());
    }

    @Override
    public void removeChannel(String channelId) {
        Optional.ofNullable(this.channelMap.remove(channelId)).ifPresent(channel -> {
            if (channel.isOpen()) {
                try {
                    channel.close();
                }
                catch (IOException | TimeoutException e) {
                    log.warn(String.format("Exception while closing channel %s", channelId), (Throwable)e);
                }
            }
        });
    }

    @Override
    public Channel createChannel() throws RuntimeException {
        try {
            Channel channel = this.connectionProvider.getConnection().createChannel();
            if (channel != null && this.config.confirmationBatchSize() > 0L) {
                channel.confirmSelect();
            }
            return channel;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void closeAndRemoveAllChannels() {
        this.channelMap.forEach((key, channel) -> this.removeChannel((String)key));
    }

    @Override
    public ConcurrentHashMap<String, Channel> getChannelMap() {
        return this.channelMap;
    }
}

