/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.context;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.iris_events.context.EventContextHolder;

@ApplicationScoped
public class EventContext {
    private final ThreadLocal<EventContextHolder> eventContextThreadLocal = new ThreadLocal();

    public EventContext() {
        this.eventContextThreadLocal.set(new EventContextHolder());
    }

    private EventContextHolder getOrCreateEventContextHolder() {
        EventContextHolder eventContextHolder = this.eventContextThreadLocal.get();
        if (eventContextHolder != null) {
            return eventContextHolder;
        }
        return new EventContextHolder();
    }

    public void setBasicProperties(AMQP.BasicProperties properties) {
        EventContextHolder eventContextHolder = this.getOrCreateEventContextHolder();
        eventContextHolder.setAmqpBasicProperties(properties);
        this.eventContextThreadLocal.set(eventContextHolder);
    }

    public void setEnvelope(Envelope envelope) {
        EventContextHolder eventContextHolder = this.getOrCreateEventContextHolder();
        eventContextHolder.setEnvelope(envelope);
        this.eventContextThreadLocal.set(eventContextHolder);
    }

    public AMQP.BasicProperties getAmqpBasicProperties() {
        EventContextHolder eventContextHolder = this.eventContextThreadLocal.get();
        if (eventContextHolder == null) {
            return null;
        }
        return eventContextHolder.getAmqpBasicProperties();
    }

    public Envelope getEnvelope() {
        EventContextHolder eventContextHolder = this.eventContextThreadLocal.get();
        if (eventContextHolder != null) {
            return eventContextHolder.getEnvelope();
        }
        return null;
    }

    public String getExchange() {
        return Optional.ofNullable(this.getEnvelope()).map(Envelope::getExchange).orElse(null);
    }

    public String getRoutingKey() {
        return Optional.ofNullable(this.getEnvelope()).map(Envelope::getRoutingKey).orElse(null);
    }

    public Map<String, Object> getHeaders() {
        AMQP.BasicProperties amqpBasicProperties = this.getAmqpBasicProperties();
        if (amqpBasicProperties == null || amqpBasicProperties.getHeaders() == null) {
            return Map.of();
        }
        return amqpBasicProperties.getHeaders();
    }

    public String getCorrelationId() {
        AMQP.BasicProperties amqpBasicProperties = this.getProperties();
        if (amqpBasicProperties == null) {
            return null;
        }
        return amqpBasicProperties.getCorrelationId();
    }

    private AMQP.BasicProperties getProperties() {
        EventContextHolder eventContextHolder = this.eventContextThreadLocal.get();
        if (eventContextHolder == null) {
            return null;
        }
        return eventContextHolder.getAmqpBasicProperties();
    }

    public Optional<String> getUserId() {
        return this.getHeaderValue("x-user-id");
    }

    public Optional<String> getMessageId() {
        return Optional.ofNullable(this.getAmqpBasicProperties().getMessageId());
    }

    public Optional<String> getSessionId() {
        return this.getHeaderValue("x-session-id");
    }

    public Integer getRetryCount() {
        return this.getHeaderValue("x-retry-count").map(Integer::valueOf).orElse(0);
    }

    public Optional<String> getHeaderValue(String header) {
        AMQP.BasicProperties amqpBasicProperties = this.getAmqpBasicProperties();
        if (amqpBasicProperties == null) {
            return Optional.empty();
        }
        Object headerValue = amqpBasicProperties.getHeaders().get(header);
        if (headerValue == null) {
            return Optional.empty();
        }
        return Optional.of(headerValue.toString());
    }

    public void setSubscriptionId(String subscriptionId) {
        this.setHeader("x-subscription-id", subscriptionId);
    }

    public void setHeader(String key, Object value) {
        AMQP.BasicProperties basicProperties = this.getAmqpBasicProperties();
        if (basicProperties == null) {
            throw new IllegalStateException("AMQP.BasicProperties not set for the message context.");
        }
        AMQP.BasicProperties.Builder builder = basicProperties.builder();
        HashMap<String, Object> headers = new HashMap<String, Object>(basicProperties.getHeaders());
        headers.put(key, value);
        AMQP.BasicProperties modifiedBasicProperties = builder.headers(headers).build();
        this.eventContextThreadLocal.get().setAmqpBasicProperties(modifiedBasicProperties);
    }
}

