/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.runtime.configuration;

import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Optional;

@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public class IrisConfig {
    @ConfigItem(name="backoff-interval-millis", defaultValue="1000")
    long backoffIntervalMillis;
    @ConfigItem(name="backoff-multiplier", defaultValue="1.5")
    double backoffMultiplier;
    @ConfigItem(name="max-retries", defaultValue="10")
    int maxRetries;
    @ConfigItem(name="confirmation-batch-size", defaultValue="1")
    long confirmationBatchSize;
    @ConfigItem(name="retry-max-count", defaultValue="3")
    int retryMaxCount;
    @ConfigItem(name="rpc.timeout", defaultValue="2000")
    int rpcTimeout;
    @ConfigItem(name="rabbitmq-host", defaultValue="${rabbitmq-host:localhost}")
    String host;
    @ConfigItem(name="rabbitmq-protocol", defaultValue="${rabbitmq-protocol}")
    Optional<String> protocol;
    @ConfigItem(name="rabbitmq-port", defaultValue="${rabbitmq-port}")
    Optional<Integer> port;
    @ConfigItem(name="rabbitmq-ssl", defaultValue="${rabbitmq-ssl}")
    Optional<Boolean> ssl;
    @ConfigItem(name="rabbitmq-username", defaultValue="${rabbitmq-username:guest}")
    String username;
    @ConfigItem(name="rabbitmq-password", defaultValue="${rabbitmq-password:guest}")
    String password;
    @ConfigItem(name="rabbitmq-virtual-host", defaultValue="${rabbitmq-virtual-host:/}")
    String virtualHost;

    public long getBackoffIntervalMillis() {
        return this.backoffIntervalMillis;
    }

    public IrisConfig setBackoffIntervalMillis(long backoffIntervalMillis) {
        this.backoffIntervalMillis = backoffIntervalMillis;
        return this;
    }

    public double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    public IrisConfig setBackoffMultiplier(double backoffMultiplier) {
        this.backoffMultiplier = backoffMultiplier;
        return this;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public IrisConfig setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public long getConfirmationBatchSize() {
        return this.confirmationBatchSize;
    }

    public IrisConfig setConfirmationBatchSize(long confirmationBatchSize) {
        this.confirmationBatchSize = confirmationBatchSize;
        return this;
    }

    public int getRetryMaxCount() {
        return this.retryMaxCount;
    }

    public IrisConfig setRetryMaxCount(int retryMaxCount) {
        this.retryMaxCount = retryMaxCount;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public IrisConfig setHost(String host) {
        this.host = host;
        return this;
    }

    public Optional<String> getProtocol() {
        return this.protocol;
    }

    public IrisConfig setProtocol(String protocol) {
        this.protocol = Optional.ofNullable(protocol);
        return this;
    }

    public int getPort() {
        return this.protocol.map(protocol -> switch (protocol) {
            case "amqp" -> this.port.orElse(5672);
            case "amqps" -> this.port.orElse(5671);
            default -> throw new IllegalStateException("Unknown protocol value: " + protocol);
        }).orElseGet(() -> this.port.orElse(5672));
    }

    public IrisConfig setPort(int port) {
        this.port = Optional.of(port);
        return this;
    }

    public boolean isSsl() {
        return this.protocol.map(protocol -> switch (protocol) {
            case "amqp" -> this.ssl.orElse(false);
            case "amqps" -> this.ssl.orElse(true);
            default -> throw new IllegalStateException("Unknown protocol value: " + protocol);
        }).orElseGet(() -> this.ssl.orElse(false));
    }

    public IrisConfig setSsl(boolean ssl) {
        this.ssl = Optional.of(ssl);
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public IrisConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public IrisConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public IrisConfig setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
        return this;
    }

    public int getRpcTimeout() {
        return this.rpcTimeout;
    }

    public void setRpcTimeout(int rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
    }
}

