/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.producer;

import org.iris_events.annotations.ExchangeType;
import org.iris_events.exception.IrisSendException;
import org.iris_events.producer.RoutingDetails;

class SendMessageValidator {
    SendMessageValidator() {
    }

    static void validate(RoutingDetails routingDetails) throws IrisSendException {
        String exchange = routingDetails.getExchange();
        ExchangeType exchangeType = routingDetails.getExchangeType();
        String routingKey = routingDetails.getRoutingKey();
        SendMessageValidator.validateExchangePresent(exchange);
        SendMessageValidator.validateRoutingKey(routingKey, exchangeType);
    }

    private static void validateExchangePresent(String exchange) throws IrisSendException {
        if (SendMessageValidator.isNullOrEmpty(exchange)) {
            throw new IrisSendException("Can not publish message to empty exchange");
        }
    }

    private static void validateRoutingKey(String routingKey, ExchangeType exchangeType) throws IrisSendException {
        if ((exchangeType.equals((Object)ExchangeType.TOPIC) || exchangeType.equals((Object)ExchangeType.DIRECT)) && SendMessageValidator.isNullOrEmpty(routingKey)) {
            throw new IrisSendException(String.format("Can not publish message to %s exchange with empty routing key.", exchangeType));
        }
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || value.isBlank();
    }
}

