/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.common;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BasicProperties;
import java.util.Map;
import java.util.Optional;
import org.slf4j.MDC;

public class MDCEnricher {
    public static void enrichMDC(AMQP.BasicProperties properties) {
        MDCEnricher.getStringHeader((BasicProperties)properties, "x-session-id").ifPresent(s -> MDC.put((String)"sessionId", (String)s));
        MDCEnricher.getStringHeader((BasicProperties)properties, "x-user-id").ifPresent(s -> MDC.put((String)"userId", (String)s));
        MDCEnricher.getStringHeader((BasicProperties)properties, "x-client-trace-id").ifPresent(s -> MDC.put((String)"clientTraceId", (String)s));
        MDCEnricher.getStringHeader((BasicProperties)properties, "x-correlation-id").ifPresent(s -> MDC.put((String)"correlationId", (String)s));
        MDCEnricher.getStringHeader((BasicProperties)properties, "x-event-type").ifPresent(s -> MDC.put((String)"eventType", (String)s));
        MDCEnricher.getStringHeader((BasicProperties)properties, "x-client-version").ifPresent(s -> MDC.put((String)"clientVersion", (String)s));
    }

    public static void enrichMDC(Map<String, String> propertyValueMap) {
        propertyValueMap.forEach(MDC::put);
    }

    public static void put(String property, String value) {
        MDC.put((String)property, (String)value);
    }

    private static Optional<String> getStringHeader(BasicProperties props, String name) {
        return Optional.ofNullable(props.getHeaders()).map(headers -> headers.get(name)).map(Object::toString);
    }
}

