/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.asyncapi.runtime.io.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26SchemaImpl;
import io.apicurio.datamodels.models.union.SchemaSchemaListUnion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.iris_events.asyncapi.runtime.io.JsonUtil;
import org.iris_events.asyncapi.runtime.json.IrisObjectMapper;
import org.iris_events.asyncapi.runtime.scanner.model.GidAsyncApi26Schema;
import org.iris_events.asyncapi.runtime.util.JandexUtil;
import org.iris_events.asyncapi.spec.annotations.enums.SchemaType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class SchemaReader {
    public static final String PROP_$REF = "$ref";

    private SchemaReader() {
    }

    public static GidAsyncApi26Schema readSchema(JsonNode node) {
        return SchemaReader.readSchema(node, false);
    }

    public static GidAsyncApi26Schema readSchema(JsonNode node, boolean fixRef) {
        SchemaType schemaType;
        if (node == null || !node.isObject()) {
            return null;
        }
        GidAsyncApi26Schema schema = new GidAsyncApi26Schema();
        if (fixRef) {
            schema.set$ref(SchemaReader.fixRef(JsonUtil.stringProperty(node, PROP_$REF)));
        } else {
            schema.set$ref(JsonUtil.stringProperty(node, PROP_$REF));
        }
        schema.setFormat(JsonUtil.stringProperty(node, "format"));
        schema.setTitle(JsonUtil.stringProperty(node, "title"));
        schema.setDescription(JsonUtil.stringProperty(node, "description"));
        schema.setDefault(node.get("default"));
        schema.setMultipleOf(JsonUtil.bigDecimalProperty(node, "multipleOf"));
        schema.setMaximum(JsonUtil.bigDecimalProperty(node, "maximum"));
        schema.setExclusiveMaximum(JsonUtil.bigDecimalProperty(node, "exclusiveMaximum"));
        schema.setMinimum(JsonUtil.bigDecimalProperty(node, "minimum"));
        schema.setExclusiveMinimum(JsonUtil.bigDecimalProperty(node, "exclusiveMinimum"));
        schema.setMaxLength(JsonUtil.intProperty(node, "maxLength"));
        schema.setMinLength(JsonUtil.intProperty(node, "minLength"));
        schema.setPattern(JsonUtil.stringProperty(node, "pattern"));
        schema.setMaxItems(JsonUtil.intProperty(node, "maxItems"));
        schema.setMinItems(JsonUtil.intProperty(node, "minItems"));
        schema.setUniqueItems(JsonUtil.booleanProperty(node, "uniqueItems").orElse(null));
        schema.setMaxProperties(JsonUtil.intProperty(node, "maxProperties"));
        schema.setMinProperties(JsonUtil.intProperty(node, "minProperties"));
        schema.setRequired(JsonUtil.readStringArray(node.get("required")).orElse(null));
        List<JsonNode> enums = JsonUtil.readNodeArray(node.get("enum"));
        if (!enums.isEmpty()) {
            schema.setEnum(enums);
        }
        schema.setType((schemaType = SchemaReader.readSchemaType(node.get("type"))) != null ? schemaType.toString() : null);
        schema.setItems((SchemaSchemaListUnion)SchemaReader.readSchema(node.get("items"), true));
        schema.setNot((AsyncApiSchema)SchemaReader.readSchema(node.get("not"), true));
        Map<String, GidAsyncApi26Schema> schemaProperties = SchemaReader.readSchemas(node.get("properties"), fixRef).orElse(Map.of());
        schemaProperties.forEach((arg_0, arg_1) -> ((GidAsyncApi26Schema)schema).addProperty(arg_0, arg_1));
        schema.setReadOnly(JsonUtil.booleanProperty(node, "readOnly").orElse(null));
        schema.setExamples(JsonUtil.readNodeArray(node.get("example")));
        List allOfSchemas = SchemaReader.readSchemaArray(node.get("allOf"), fixRef).orElse(List.of());
        allOfSchemas.forEach(arg_0 -> ((GidAsyncApi26Schema)schema).addAllOf(arg_0));
        List oneOfSchemas = SchemaReader.readSchemaArray(node.get("oneOf"), fixRef).orElse(List.of());
        oneOfSchemas.forEach(arg_0 -> ((GidAsyncApi26Schema)schema).addOneOf(arg_0));
        List anyOfSchemas = SchemaReader.readSchemaArray(node.get("anyOf"), fixRef).orElse(List.of());
        anyOfSchemas.forEach(arg_0 -> ((GidAsyncApi26Schema)schema).addAnyOf(arg_0));
        schema.setNot((AsyncApiSchema)SchemaReader.readSchema(node.get("not")));
        schema.setWriteOnly(JsonUtil.booleanProperty(node, "writeOnly").orElse(null));
        schema.setDeprecated(JsonUtil.booleanProperty(node, "deprecated").orElse(null));
        if (node.get("additionalProperties") != null) {
            ObjectNode additionalPropertiesObjectNode = IrisObjectMapper.getObjectMapper().createObjectNode();
            Map<String, String> propertiesMap = SchemaReader.readPropertiesMap(node.get("additionalProperties"), fixRef);
            propertiesMap.forEach((key, value) -> additionalPropertiesObjectNode.putIfAbsent(key, (JsonNode)TextNode.valueOf((String)value)));
            schema.addExtension("additionalProperties", (JsonNode)additionalPropertiesObjectNode);
        }
        schema.existingJavaType = JsonUtil.stringProperty(node, "existingJavaType");
        schema.addExtension("existingJavaType", (JsonNode)TextNode.valueOf((String)JsonUtil.stringProperty(node, "existingJavaType")));
        return schema;
    }

    private static Map<String, String> readPropertiesMap(JsonNode jsonNode, boolean fixRef) {
        HashMap<String, String> props = new HashMap<String, String>();
        jsonNode.fields().forEachRemaining(stringJsonNodeEntry -> {
            String key = (String)stringJsonNodeEntry.getKey();
            String value = ((JsonNode)stringJsonNodeEntry.getValue()).asText();
            if (key.equals(PROP_$REF)) {
                value = SchemaReader.fixRef(value);
            }
            props.put(key, value);
        });
        return props;
    }

    private static String fixRef(String ref) {
        if (ref != null) {
            return ref.replace("/definitions/", "/components/schemas/");
        }
        return null;
    }

    private static SchemaType readSchemaType(JsonNode node) {
        if (node != null && node.isTextual()) {
            String strval = node.asText();
            return SchemaType.valueOf((String)strval.toUpperCase());
        }
        return null;
    }

    public static Optional<Map<String, GidAsyncApi26Schema>> readSchemas(JsonNode node) {
        return SchemaReader.readSchemas(node, false);
    }

    public static Optional<Map<String, GidAsyncApi26Schema>> readSchemas(JsonNode node, boolean fixRef) {
        if (node != null && node.isObject()) {
            LinkedHashMap<String, GidAsyncApi26Schema> models = new LinkedHashMap<String, GidAsyncApi26Schema>();
            Iterator fieldNames = node.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                JsonNode childNode = node.get(fieldName);
                models.put(fieldName, SchemaReader.readSchema(childNode, fixRef));
            }
            return Optional.of(models);
        }
        return Optional.empty();
    }

    private static Optional<List<AsyncApiSchema>> readSchemaArray(JsonNode node, boolean fixRef) {
        if (node != null && node.isArray()) {
            ArrayList<GidAsyncApi26Schema> rval = new ArrayList<GidAsyncApi26Schema>(node.size());
            ArrayNode arrayNode = (ArrayNode)node;
            for (JsonNode arrayItem : arrayNode) {
                rval.add(SchemaReader.readSchema(arrayItem, fixRef));
            }
            return Optional.of(rval);
        }
        return Optional.empty();
    }

    public static AsyncApiSchema readParameterSchema(AnnotationValue parameterSchema) {
        if (parameterSchema != null) {
            AnnotationInstance annotationInstance = parameterSchema.asNested();
            AsyncApi26SchemaImpl schema = new AsyncApi26SchemaImpl();
            SchemaType schemaType = JandexUtil.enumValue(annotationInstance, "type", SchemaType.class);
            if (schemaType != null) {
                schema.setType(schemaType.toString());
            }
            return schema;
        }
        return null;
    }
}

