/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.asyncapi.runtime.scanner.model;

import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigPart;
import com.github.victools.jsonschema.generator.TypeScope;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.iris_events.asyncapi.runtime.scanner.model.GidOpenApiOption;
import org.iris_events.asyncapi.spec.annotations.media.Schema;
import org.iris_events.asyncapi.spec.annotations.media.SchemaProperty;

public class GidOpenApiModule
implements Module {
    private final List<GidOpenApiOption> options;
    private static final Pattern NUMBER = Pattern.compile("-?[0-9]+\\.?[0-9]*");

    public GidOpenApiModule(GidOpenApiOption ... options) {
        this.options = options == null ? Collections.emptyList() : Arrays.asList(options);
    }

    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        SchemaGeneratorConfigPart fieldConfigPart = builder.forFields();
        this.applyToConfigPart(fieldConfigPart);
        if (this.options.contains((Object)GidOpenApiOption.ENABLE_PROPERTY_NAME_OVERRIDES)) {
            fieldConfigPart.withPropertyNameOverrideResolver(this::resolvePropertyNameOverride);
        }
        this.applyToConfigPart(builder.forMethods());
        if (!this.options.contains((Object)GidOpenApiOption.NO_APIMODEL_TITLE)) {
            builder.forTypesInGeneral().withTitleResolver(this::resolveTitleForType);
        }
        if (!this.options.contains((Object)GidOpenApiOption.NO_APIMODEL_DESCRIPTION)) {
            builder.forTypesInGeneral().withDescriptionResolver(this::resolveDescriptionForType);
        }
    }

    private void applyToConfigPart(SchemaGeneratorConfigPart<?> configPart) {
        if (this.options.contains((Object)GidOpenApiOption.IGNORING_HIDDEN_PROPERTIES)) {
            configPart.withIgnoreCheck(this::shouldIgnore);
        }
        configPart.withDescriptionResolver(this::resolveDescription);
        configPart.withNumberExclusiveMinimumResolver(this::resolveNumberExclusiveMinimum);
        configPart.withNumberInclusiveMinimumResolver(this::resolveNumberInclusiveMinimum);
        configPart.withNumberExclusiveMaximumResolver(this::resolveNumberExclusiveMaximum);
        configPart.withNumberInclusiveMaximumResolver(this::resolveNumberInclusiveMaximum);
        configPart.withEnumResolver(this::resolveEnumerationValues);
    }

    protected boolean shouldIgnore(MemberScope<?, ?> member) {
        SchemaProperty annotation = (SchemaProperty)member.getAnnotationConsideringFieldAndGetter(SchemaProperty.class);
        return annotation != null && annotation.hidden();
    }

    protected String resolvePropertyNameOverride(FieldScope field) {
        return Optional.ofNullable((SchemaProperty)field.getAnnotationConsideringFieldAndGetter(SchemaProperty.class)).map(SchemaProperty::name).filter(name -> !name.isEmpty() && !name.equals(field.getName())).orElse(null);
    }

    protected String resolveDescription(MemberScope<?, ?> member) {
        return Optional.ofNullable((SchemaProperty)member.getAnnotationConsideringFieldAndGetterIfSupported(SchemaProperty.class)).map(SchemaProperty::description).filter(value -> !value.isEmpty()).orElse(null);
    }

    protected String resolveDescriptionForType(TypeScope scope) {
        return Optional.ofNullable(scope.getType()).map(type -> type.getErasedType().getAnnotation(Schema.class)).map(Schema::description).filter(description -> !description.isEmpty()).orElse(null);
    }

    protected String resolveTitleForType(TypeScope scope) {
        return Optional.ofNullable(scope.getType()).map(type -> type.getErasedType().getAnnotation(Schema.class)).map(Schema::title).filter(title -> !title.isEmpty()).orElse(null);
    }

    private Optional<BigDecimal> findModelPropertyMinimum(MemberScope<?, ?> member) {
        return Optional.ofNullable((SchemaProperty)member.getAnnotationConsideringFieldAndGetterIfSupported(SchemaProperty.class)).map(SchemaProperty::minimum).filter(minimum -> !minimum.isEmpty()).filter(minimum -> NUMBER.matcher((CharSequence)minimum).matches()).map(BigDecimal::new);
    }

    private Optional<BigDecimal> findModelPropertyMaximum(MemberScope<?, ?> member) {
        return Optional.ofNullable((SchemaProperty)member.getAnnotationConsideringFieldAndGetterIfSupported(SchemaProperty.class)).map(SchemaProperty::maximum).filter(maximum -> !maximum.isEmpty()).filter(maximum -> NUMBER.matcher((CharSequence)maximum).matches()).map(BigDecimal::new);
    }

    private Optional<Boolean> findModelPropertyExclusiveMinimum(MemberScope<?, ?> member) {
        return Optional.ofNullable((SchemaProperty)member.getAnnotationConsideringFieldAndGetterIfSupported(SchemaProperty.class)).map(SchemaProperty::exclusiveMinimum);
    }

    private Optional<Boolean> findModelPropertyExclusiveMaximum(MemberScope<?, ?> member) {
        return Optional.ofNullable((SchemaProperty)member.getAnnotationConsideringFieldAndGetterIfSupported(SchemaProperty.class)).map(SchemaProperty::exclusiveMaximum);
    }

    private Optional<List<String>> findModelPropertyEnumeration(MemberScope<?, ?> member) {
        return Optional.ofNullable((SchemaProperty)member.getAnnotationConsideringFieldAndGetterIfSupported(SchemaProperty.class)).map(SchemaProperty::enumeration).map(Arrays::asList);
    }

    protected BigDecimal resolveNumberInclusiveMinimum(MemberScope<?, ?> member) {
        Optional<Boolean> modelPropertyExclusiveMinimum = this.findModelPropertyExclusiveMinimum(member);
        Boolean isMinimumExclusive = modelPropertyExclusiveMinimum.orElse(false);
        if (isMinimumExclusive.booleanValue()) {
            return null;
        }
        Optional<BigDecimal> modelPropertyMinimum = this.findModelPropertyMinimum(member);
        return modelPropertyMinimum.orElse(null);
    }

    protected BigDecimal resolveNumberExclusiveMinimum(MemberScope<?, ?> member) {
        Optional<Boolean> modelPropertyExclusiveMinimum = this.findModelPropertyExclusiveMinimum(member);
        Boolean isMinimumExclusive = modelPropertyExclusiveMinimum.orElse(false);
        if (!isMinimumExclusive.booleanValue()) {
            return null;
        }
        Optional<BigDecimal> modelPropertyMinimum = this.findModelPropertyMinimum(member);
        return modelPropertyMinimum.orElse(null);
    }

    protected BigDecimal resolveNumberInclusiveMaximum(MemberScope<?, ?> member) {
        Optional<Boolean> modelPropertyExclusiveMaximum = this.findModelPropertyExclusiveMaximum(member);
        Boolean isMaximumExclusive = modelPropertyExclusiveMaximum.orElse(false);
        if (isMaximumExclusive.booleanValue()) {
            return null;
        }
        Optional<BigDecimal> modelPropertyMaximum = this.findModelPropertyMaximum(member);
        return modelPropertyMaximum.orElse(null);
    }

    protected BigDecimal resolveNumberExclusiveMaximum(MemberScope<?, ?> member) {
        Optional<Boolean> modelPropertyExclusiveMaximum = this.findModelPropertyExclusiveMaximum(member);
        Boolean isMaximumExclusive = modelPropertyExclusiveMaximum.orElse(false);
        if (!isMaximumExclusive.booleanValue()) {
            return null;
        }
        Optional<BigDecimal> modelPropertyMaximum = this.findModelPropertyMaximum(member);
        return modelPropertyMaximum.orElse(null);
    }

    protected List<String> resolveEnumerationValues(MemberScope<?, ?> member) {
        return this.findModelPropertyEnumeration(member).orElse(null);
    }
}

