/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.asyncapi.runtime.scanner;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.asyncapi.AsyncApiBinding;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannelBindings;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannelItem;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannels;
import io.apicurio.datamodels.models.asyncapi.AsyncApiComponents;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessage;
import io.apicurio.datamodels.models.asyncapi.AsyncApiOperation;
import io.apicurio.datamodels.models.asyncapi.AsyncApiOperationBindings;
import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26BindingImpl;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26ChannelBindingsImpl;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26ComponentsImpl;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Document;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26SchemaImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.iris_events.annotations.IrisGenerated;
import org.iris_events.annotations.Scope;
import org.iris_events.asyncapi.api.AsyncApiConfig;
import org.iris_events.asyncapi.runtime.io.schema.SchemaReader;
import org.iris_events.asyncapi.runtime.scanner.AnnotationScannerContext;
import org.iris_events.asyncapi.runtime.scanner.FilteredIndexView;
import org.iris_events.asyncapi.runtime.scanner.model.ChannelBindingsInfo;
import org.iris_events.asyncapi.runtime.scanner.model.ChannelInfo;
import org.iris_events.asyncapi.runtime.scanner.model.GidAaiAMQPOperationBinding;
import org.iris_events.asyncapi.runtime.scanner.model.GidAsyncApi26MessageImpl;
import org.iris_events.asyncapi.runtime.scanner.model.GidAsyncApi26Schema;
import org.iris_events.asyncapi.runtime.scanner.model.JsonSchemaInfo;
import org.iris_events.asyncapi.runtime.util.HeaderSchemaBuilder;
import org.iris_events.common.DeliveryMode;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public abstract class BaseAnnotationScanner {
    public static final String COMPONENTS_SCHEMAS_PREFIX = "#/components/schemas/";
    protected final AnnotationScannerContext annotationScannerContext;
    protected ClassLoader classLoader = null;
    protected ObjectMapper objectMapper;
    protected final HeaderSchemaBuilder headerSchemaBuilder;

    public BaseAnnotationScanner(AsyncApiConfig config, IndexView index, ClassLoader classLoader, ObjectMapper objectMapper) {
        this(config, index, objectMapper);
        this.classLoader = classLoader;
    }

    public BaseAnnotationScanner(AsyncApiConfig config, IndexView index, ObjectMapper objectMapper) {
        FilteredIndexView filteredIndexView = index instanceof FilteredIndexView ? (FilteredIndexView)index : new FilteredIndexView(index, config);
        Collection<AnnotationInstance> generatedClassAnnotations = filteredIndexView.getAnnotations(DotName.createSimple((String)IrisGenerated.class.getName()));
        this.objectMapper = objectMapper;
        this.annotationScannerContext = new AnnotationScannerContext(filteredIndexView, BaseAnnotationScanner.getDocument(), generatedClassAnnotations);
        this.headerSchemaBuilder = new HeaderSchemaBuilder(objectMapper);
    }

    private static AsyncApi26Document getDocument() {
        AsyncApi26Document document = (AsyncApi26Document)Library.createDocument((ModelType)ModelType.ASYNCAPI26);
        document.setAsyncapi("2.6.0");
        document.setDefaultContentType("application/json");
        return document;
    }

    public abstract AsyncApi26Document scan();

    protected boolean annotatedMethods(AnnotationInstance annotation) {
        return Objects.equals(annotation.target().kind(), AnnotationTarget.Kind.METHOD);
    }

    protected boolean annotatedClasses(AnnotationInstance annotation) {
        return Objects.equals(annotation.target().kind(), AnnotationTarget.Kind.CLASS);
    }

    protected void createChannels(List<ChannelInfo> channelInfos, Map<String, Scope> messageScopes, AsyncApi26Document document) {
        AsyncApiChannels channels = document.getChannels() == null ? document.createChannels() : document.getChannels();
        document.setChannels(channels);
        channelInfos.forEach(channelInfo -> {
            String messageKey = channelInfo.getEventKey();
            AsyncApiChannelItem channelItem = channels.createChannelItem();
            AsyncApiOperation operation = channelItem.createOperation();
            boolean persistent = channelInfo.getOperationBindingsInfo().persistent();
            int deliveryMode = this.getDeliveryMode(persistent);
            GidAaiAMQPOperationBinding aaiAMQPOperationBinding = new GidAaiAMQPOperationBinding();
            aaiAMQPOperationBinding.setDeliveryMode(deliveryMode);
            AsyncApiOperationBindings operationBindings = operation.createOperationBindings();
            operationBindings.setAmqp((AsyncApiBinding)aaiAMQPOperationBinding);
            operation.setBindings(operationBindings);
            GidAsyncApi26MessageImpl message = new GidAsyncApi26MessageImpl();
            message.setHeaders((AsyncApiSchema)this.headerSchemaBuilder.buildHeaders((ChannelInfo)channelInfo, messageScopes));
            message.setName(messageKey);
            message.setTitle(messageKey);
            message.setPayload(this.getRefJsonNode(messageKey));
            operation.setMessage((AsyncApiMessage)message);
            this.setResponseType((ChannelInfo)channelInfo, operation);
            if (channelInfo.getOperationType().equals("subscribe")) {
                channelItem.setSubscribe(operation);
            } else if (channelInfo.getOperationType().equals("publish")) {
                channelItem.setPublish(operation);
            } else {
                throw new IllegalArgumentException("opType argument should be one of [publish, subscribe]");
            }
            AsyncApi26BindingImpl amqpChannelBindings = new AsyncApi26BindingImpl();
            String queueName = channelInfo.getBindingsInfo().getQueue();
            String exchangeName = channelInfo.getBindingsInfo().getExchange();
            amqpChannelBindings.addExtension("is", (JsonNode)TextNode.valueOf((String)"routingKey"));
            amqpChannelBindings.addExtension("queue", this.getQueueBindings(queueName, (ChannelInfo)channelInfo));
            amqpChannelBindings.addExtension("exchange", this.getExchangeBindings(exchangeName, (ChannelInfo)channelInfo));
            AsyncApi26ChannelBindingsImpl channelBindings = new AsyncApi26ChannelBindingsImpl();
            channelBindings.setAmqp((AsyncApiBinding)amqpChannelBindings);
            channelItem.setBindings((AsyncApiChannelBindings)channelBindings);
            String channelKey = String.format("%s/%s", exchangeName, queueName);
            channels.addItem(channelKey, (Object)channelItem);
        });
    }

    private <T extends JsonNode> T getExchangeBindings(String exchangeName, ChannelInfo channelInfo) {
        ChannelBindingsInfo bindingsInfo = channelInfo.getBindingsInfo();
        HashMap<String, Object> exchange = new HashMap<String, Object>();
        exchange.put("name", exchangeName);
        exchange.put("type", bindingsInfo.getExchangeType().getType());
        exchange.put("durable", bindingsInfo.isExchangeDurable());
        exchange.put("autoDelete", bindingsInfo.isExchangeAutoDelete());
        exchange.put("vhost", bindingsInfo.getExchangeVhost());
        return (T)this.objectMapper.valueToTree(exchange);
    }

    private <T extends JsonNode> T getQueueBindings(String queueName, ChannelInfo channelInfo) {
        ChannelBindingsInfo bindingsInfo = channelInfo.getBindingsInfo();
        HashMap<String, Object> queue = new HashMap<String, Object>();
        queue.put("name", queueName);
        queue.put("durable", bindingsInfo.isQueueDurable());
        queue.put("exclusive", bindingsInfo.isQueueExclusive());
        queue.put("autoDelete", bindingsInfo.isQueueAutoDelete());
        queue.put("vhost", bindingsInfo.getQueueVhost());
        return (T)this.objectMapper.valueToTree(queue);
    }

    private JsonNode getRefJsonNode(String eventName) {
        try {
            return this.objectMapper.readTree(String.format("{\"$ref\" : \"#/components/schemas/%s\"}", eventName));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not read ref json node", e);
        }
    }

    private int getDeliveryMode(boolean persistent) {
        return persistent ? DeliveryMode.PERSISTENT.getValue() : DeliveryMode.NON_PERSISTENT.getValue();
    }

    private void setResponseType(ChannelInfo channelInfo, AsyncApiOperation operation) {
        Type responseType = channelInfo.getResponseType();
        if (responseType == null) {
            return;
        }
        DotName responseTypeName = responseType.asClassType().name();
        if (responseTypeName.toString().equals(Void.class.getName())) {
            return;
        }
        AsyncApi26SchemaImpl responseSchema = new AsyncApi26SchemaImpl();
        responseSchema.set$ref(COMPONENTS_SCHEMAS_PREFIX + responseTypeName.local());
        ((GidAsyncApi26MessageImpl)operation.getMessage()).response = responseSchema;
    }

    protected void insertComponentSchemas(AnnotationScannerContext context, Map<String, JsonSchemaInfo> collectedNodes, AsyncApi26Document asyncApi) {
        if (asyncApi.getComponents() == null) {
            asyncApi.setComponents((AsyncApiComponents)new AsyncApi26ComponentsImpl());
        }
        collectedNodes.forEach((s, jsonSchemaInfo) -> {
            JsonNode definitions = jsonSchemaInfo.getGeneratedSchema().get("definitions");
            if (definitions != null) {
                Iterator defFieldsIterator = definitions.fields();
                while (defFieldsIterator.hasNext()) {
                    Map.Entry definition = (Map.Entry)defFieldsIterator.next();
                    String key = (String)definition.getKey();
                    GidAsyncApi26Schema definitionAaiSchema = SchemaReader.readSchema((JsonNode)definition.getValue(), true);
                    context.addDefinitionSchema(key, definitionAaiSchema);
                }
            }
            GidAsyncApi26Schema aaiSchema = SchemaReader.readSchema((JsonNode)jsonSchemaInfo.getGeneratedSchema(), true);
            aaiSchema.addExtension("x-iris-generated", (JsonNode)BooleanNode.valueOf((boolean)jsonSchemaInfo.isGeneratedClass()));
            Optional.ofNullable(jsonSchemaInfo.getCacheTtl()).ifPresent(cacheTtl -> aaiSchema.addExtension("x-cached-message-ttl-seconds", (JsonNode)IntNode.valueOf((int)cacheTtl)));
            asyncApi.getComponents().addSchema(s, (Schema)aaiSchema);
        });
    }

    protected boolean isGeneratedClass(ClassInfo eventClass) {
        return this.annotationScannerContext.getGeneratedClassAnnotations().stream().filter(annotationInstance -> annotationInstance.target().kind().equals((Object)AnnotationTarget.Kind.CLASS)).anyMatch(annotationInstance -> annotationInstance.target().asClass().name().equals((Object)eventClass.name()));
    }
}

