/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.asyncapi.runtime.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.iris_events.asyncapi.runtime.json.IrisObjectMapper;
import org.iris_events.asyncapi.runtime.scanner.model.ClientDefinitions;

public class ClientDefinitionMerger {
    public JsonNode merge(List<ClientDefinitions> definitions, String version) {
        JsonNode clientAsyncApi = this.generateBase(version);
        definitions.forEach(def -> {
            this.setChannelNodes(clientAsyncApi, (ClientDefinitions)def);
            this.setSchemaNodes(clientAsyncApi, (ClientDefinitions)def);
        });
        return clientAsyncApi;
    }

    private void nestSchemas(Map<String, JsonNode> schemasNodes, String serviceName) {
        schemasNodes.entrySet().stream().filter(stringJsonNodeEntry -> stringJsonNodeEntry.getValue() != null).forEach(stringJsonNodeEntry -> this.setServiceSpecificRefs(serviceName, (Map.Entry<String, JsonNode>)stringJsonNodeEntry));
    }

    private void setServiceSpecificRefs(String serviceName, Map.Entry<String, JsonNode> stringJsonNodeEntry) {
        stringJsonNodeEntry.getValue().findValues("$ref").forEach(refNode -> {
            if (refNode instanceof TextNode) {
                try {
                    Field f = TextNode.class.getDeclaredField("_value");
                    f.setAccessible(true);
                    f.set(refNode, this.insertServiceName(refNode.asText(), serviceName));
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private String insertServiceName(String existingRefValue, String serviceName) {
        String newRefPrefix = "#/components/schemas/" + serviceName + "/";
        return existingRefValue.replace("#/components/schemas/", newRefPrefix);
    }

    private JsonNode generateBase(String version) {
        ObjectMapper objectMapper = IrisObjectMapper.getObjectMapper();
        ObjectNode root = objectMapper.createObjectNode();
        root.put("asyncapi", "2.0.0");
        root.put("id", "urn:org:iris_events:client-api");
        ObjectNode infoNode = objectMapper.createObjectNode();
        infoNode.put("title", "Iris Client API");
        infoNode.put("version", version);
        root.set("info", (JsonNode)infoNode);
        root.set("channels", (JsonNode)objectMapper.createObjectNode());
        ObjectNode componentsNode = objectMapper.createObjectNode();
        componentsNode.set("schemas", (JsonNode)objectMapper.createObjectNode());
        root.set("components", (JsonNode)componentsNode);
        return root;
    }

    private void setSchemaNodes(JsonNode clientAsyncApi, ClientDefinitions definitions) {
        this.nestSchemas(definitions.getSchemasNodes(), definitions.getServiceName());
        ObjectNode schemasNode = (ObjectNode)((ObjectNode)clientAsyncApi.findPath("components").findPath("schemas")).set(definitions.getServiceName(), (JsonNode)IrisObjectMapper.getObjectMapper().createObjectNode()).findPath(definitions.getServiceName());
        definitions.getSchemasNodes().forEach((arg_0, arg_1) -> ((ObjectNode)schemasNode).set(arg_0, arg_1));
    }

    private void setChannelNodes(JsonNode clientAsyncApi, ClientDefinitions definitions) {
        this.nestSchemas(definitions.getClientChannelNodes(), definitions.getServiceName());
        ObjectNode channelsNode = (ObjectNode)clientAsyncApi.findPath("channels");
        definitions.getClientChannelNodes().forEach((arg_0, arg_1) -> ((ObjectNode)channelsNode).set(arg_0, arg_1));
    }
}

