/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.asyncapi.runtime.client;

import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.exception.ArtifactNotFoundException;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v2.beans.IfExists;
import io.apicurio.registry.rest.v2.beans.SearchedArtifact;
import io.apicurio.registry.rest.v2.beans.SearchedVersion;
import io.apicurio.registry.rest.v2.beans.SortBy;
import io.apicurio.registry.rest.v2.beans.SortOrder;
import io.apicurio.registry.rest.v2.beans.VersionSearchResults;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.iris_events.asyncapi.runtime.util.StreamUtil;

public class ApicurioClient {
    public static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final String GROUP_ID = "org.iris_events.events";
    public static final String GROUP_ID_CLIENT = "org.iris_events.client.events";
    public static final String GROUP_ID_SNAPSHOTS = "org.iris_events.snapshot.events";
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String ALPHA = "-alpha-";
    private static final int LIMIT = 20;
    private final RegistryClient client;

    public ApicurioClient(RegistryClient client) {
        this.client = client;
    }

    public void upload(String artifactId, String version, String schema) {
        if (this.isSnapshotVersion(version) || this.isAlphaVersion(version)) {
            String snapshotVersion = String.format("%s-%s", version, TIMESTAMP_FORMAT.format(new Date()));
            this.upload(artifactId, GROUP_ID_SNAPSHOTS, snapshotVersion, schema);
        } else {
            this.upload(artifactId, GROUP_ID, version, schema);
        }
    }

    public void uploadClientSchema(String artifactId, String version, String schema) {
        this.upload(artifactId, GROUP_ID_CLIENT, version, schema);
    }

    public List<String> getArtifactsInGroup(String groupId) {
        ArtifactSearchResults artifactSearchResults = this.client.listArtifactsInGroup(groupId);
        List searchResults = artifactSearchResults.getArtifacts();
        if (searchResults.isEmpty()) {
            return new ArrayList<String>();
        }
        return this.getLatestArtifacts(searchResults);
    }

    public String getLatestClientArtifact(String artifactId) throws IOException {
        return this.getLatestArtifact(GROUP_ID_CLIENT, artifactId);
    }

    public String getLatestArtifact(String groupId, String artifactId) throws IOException {
        try {
            return StreamUtil.toString(this.client.getLatestArtifact(groupId, artifactId));
        }
        catch (ArtifactNotFoundException e) {
            return null;
        }
    }

    public List<SearchedArtifact> searchArtifacts(String groupId, String name, String description) {
        List labels = null;
        List properties = null;
        SortBy orderBy = SortBy.name;
        SortOrder order = SortOrder.asc;
        int offset = 0;
        ArrayList<SearchedArtifact> artifacts = new ArrayList<SearchedArtifact>();
        boolean moreLeft = true;
        while (moreLeft) {
            ArtifactSearchResults artifactSearchResults = this.client.searchArtifacts(groupId, name, description, labels, properties, orderBy, order, Integer.valueOf(offset), Integer.valueOf(20));
            artifacts.addAll(artifactSearchResults.getArtifacts());
            moreLeft = artifactSearchResults.getArtifacts().size() >= 20;
            offset += 20;
        }
        return artifacts;
    }

    public List<SearchedVersion> listArtifactVersions(String groupId, String artifactId) {
        int offset = 0;
        boolean moreLeft = true;
        ArrayList<SearchedVersion> versionList = new ArrayList<SearchedVersion>();
        while (moreLeft) {
            VersionSearchResults versionSearchResults = this.client.listArtifactVersions(groupId, artifactId, Integer.valueOf(offset), Integer.valueOf(20));
            List versions = versionSearchResults.getVersions();
            versionList.addAll(versions);
            moreLeft = versions.size() >= 20;
            offset += 20;
        }
        return versionList;
    }

    private void upload(String artifactId, String groupId, String version, String schema) {
        ByteArrayInputStream dataStream = new ByteArrayInputStream(schema.getBytes(StandardCharsets.UTF_8));
        this.client.createArtifact(groupId, artifactId, version, "ASYNCAPI", IfExists.UPDATE, Boolean.valueOf(true), (InputStream)dataStream);
    }

    private boolean isSnapshotVersion(String version) {
        return version != null && version.toUpperCase().endsWith(SNAPSHOT);
    }

    private boolean isAlphaVersion(String version) {
        return version != null && version.contains(ALPHA);
    }

    private List<String> getLatestArtifacts(List<SearchedArtifact> searchResults) {
        return searchResults.stream().map(artifact -> this.client.getLatestArtifact(artifact.getGroupId(), artifact.getId())).map(StreamUtil::toString).collect(Collectors.toList());
    }
}

