/*
 * Decompiled with CFR 0.152.
 */
package org.iris_events.asyncapi.parsers;

import java.lang.reflect.Method;
import java.util.Objects;
import org.iris_events.annotations.ExchangeType;
import org.iris_events.annotations.Message;
import org.iris_events.asyncapi.IrisAnnotationRuntimeException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.IndexView;

public class ExchangeTypeParser {
    private static final String MESSAGE_EXCHANGE_TYPE_PARAM = "exchangeType";

    public static ExchangeType getFromAnnotationClass(Message messageAnnotation) {
        ExchangeType exchangeType = messageAnnotation.exchangeType();
        if (Objects.nonNull(exchangeType)) {
            return exchangeType;
        }
        try {
            Method exchangeTypeMethod = messageAnnotation.annotationType().getMethod(MESSAGE_EXCHANGE_TYPE_PARAM, new Class[0]);
            return (ExchangeType)exchangeTypeMethod.getDefaultValue();
        }
        catch (NoSuchMethodException e) {
            throw new IrisAnnotationRuntimeException(String.format("Malformed %s annotation. Does not contain %s parameter default", Message.class.getName(), MESSAGE_EXCHANGE_TYPE_PARAM));
        }
    }

    public static ExchangeType getFromAnnotationInstance(AnnotationInstance messageAnnotation, IndexView index) {
        return ExchangeType.fromType((String)messageAnnotation.valueWithDefault(index, MESSAGE_EXCHANGE_TYPE_PARAM).asString());
    }
}

