/*
 * Decompiled with CFR 0.152.
 */
package org.iota.types.secret;

import com.google.gson.JsonObject;
import org.iota.types.JsonUtils;
import org.iota.types.Output;
import org.iota.types.UtxoInput;
import org.iota.types.ids.BlockId;
import org.iota.types.secret.Range;

public class BuildBlockOptions {
    private Integer coinType;
    private Integer accountIndex;
    private Integer initialAddressIndex;
    private UtxoInput[] inputs;
    private Range inputRange;
    private ClientBlockBuilderOutputAddress output;
    private ClientBlockBuilderOutputAddress outputHex;
    private Output[] outputs;
    private String customRemainderAddress;
    private String tag;
    private String data;
    private BlockId[] parents;
    private Boolean allowBurning;

    public BuildBlockOptions withCoinType(Integer coinType) {
        this.coinType = coinType;
        return this;
    }

    public BuildBlockOptions withAccountIndex(Integer accountIndex) {
        this.accountIndex = accountIndex;
        return this;
    }

    public BuildBlockOptions withInitialAddressIndex(Integer initialAddressIndex) {
        this.initialAddressIndex = initialAddressIndex;
        return this;
    }

    public BuildBlockOptions withInputs(UtxoInput[] inputs) {
        this.inputs = inputs;
        return this;
    }

    public BuildBlockOptions withInputRange(Range inputRange) {
        this.inputRange = inputRange;
        return this;
    }

    public BuildBlockOptions withOutput(ClientBlockBuilderOutputAddress output) {
        this.output = output;
        return this;
    }

    public BuildBlockOptions withOutputHex(ClientBlockBuilderOutputAddress outputHex) {
        this.outputHex = outputHex;
        return this;
    }

    public BuildBlockOptions withOutputs(Output[] outputs) {
        this.outputs = outputs;
        return this;
    }

    public BuildBlockOptions withCustomRemainderAddress(String customRemainderAddress) {
        this.customRemainderAddress = customRemainderAddress;
        return this;
    }

    public BuildBlockOptions withTag(String tag) {
        this.tag = tag;
        return this;
    }

    public BuildBlockOptions withData(String data) {
        this.data = data;
        return this;
    }

    public BuildBlockOptions withParents(BlockId[] parents) {
        this.parents = parents;
        return this;
    }

    public BuildBlockOptions withAllowBurning(Boolean allowBurning) {
        this.allowBurning = allowBurning;
        return this;
    }

    public JsonObject getJson() {
        JsonObject o = new JsonObject();
        o.addProperty("coinType", this.coinType);
        o.addProperty("accountIndex", this.accountIndex);
        o.addProperty("initialAddressIndex", this.initialAddressIndex);
        o.add("inputs", JsonUtils.toJson(this.inputs));
        o.add("inputRange", this.inputRange != null ? this.inputRange.getAsJson() : null);
        o.add("output", this.output != null ? this.output.getAsJson() : null);
        o.add("outputHex", this.outputHex != null ? this.outputHex.getAsJson() : null);
        o.add("outputs", JsonUtils.toJson(this.outputs));
        o.addProperty("customRemainderAddress", this.customRemainderAddress);
        o.addProperty("tag", this.tag);
        o.addProperty("data", this.data);
        o.add("parents", JsonUtils.toJson(this.parents));
        o.addProperty("allowBurning", this.allowBurning);
        return o;
    }

    public static class ClientBlockBuilderOutputAddress {
        private String address;
        private String amount;

        public ClientBlockBuilderOutputAddress(String address, String amount) {
            this.address = address;
            this.amount = amount;
        }

        public JsonObject getAsJson() {
            JsonObject o = new JsonObject();
            o.addProperty("address", this.address);
            o.addProperty("amount", this.amount);
            return o;
        }
    }
}

