/*
 * Decompiled with CFR 0.152.
 */
package org.iota.types.output_builder;

import com.google.gson.JsonObject;
import org.iota.types.Feature;
import org.iota.types.JsonUtils;
import org.iota.types.NativeToken;
import org.iota.types.UnlockCondition;
import org.iota.types.ids.NftId;

public class NftOutputBuilderParams {
    private String amount;
    private NativeToken[] nativeTokens;
    private NftId nftId;
    private UnlockCondition[] unlockConditions;
    private Feature[] features;
    private Feature[] immutableFeatures;

    public NftOutputBuilderParams withAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public NftOutputBuilderParams withNativeTokens(NativeToken[] nativeTokens) {
        this.nativeTokens = nativeTokens;
        return this;
    }

    public NftOutputBuilderParams withNftId(NftId nftId) {
        this.nftId = nftId;
        return this;
    }

    public NftOutputBuilderParams withUnlockConditions(UnlockCondition[] unlockConditions) {
        this.unlockConditions = unlockConditions;
        return this;
    }

    public NftOutputBuilderParams withFeatures(Feature[] features) {
        this.features = features;
        return this;
    }

    public NftOutputBuilderParams withImmutableFeatures(Feature[] immutableFeatures) {
        this.immutableFeatures = immutableFeatures;
        return this;
    }

    public JsonObject getJson() {
        JsonObject o = new JsonObject();
        o.addProperty("amount", this.amount);
        o.add("nativeTokens", JsonUtils.toJson(this.nativeTokens));
        o.addProperty("nftId", this.nftId != null ? this.nftId.toString() : null);
        o.add("unlockConditions", JsonUtils.toJson(this.unlockConditions));
        o.add("features", JsonUtils.toJson(this.features));
        o.add("immutableFeatures", JsonUtils.toJson(this.immutableFeatures));
        return o;
    }
}

