/*
 * Decompiled with CFR 0.152.
 */
package org.iota.types.output_builder;

import com.google.gson.JsonObject;
import org.iota.types.Feature;
import org.iota.types.JsonUtils;
import org.iota.types.NativeToken;
import org.iota.types.TokenScheme;
import org.iota.types.UnlockCondition;

public class FoundryOutputBuilderParams {
    private String amount;
    private NativeToken[] nativeTokens;
    private int serialNumber;
    private TokenScheme tokenScheme;
    private UnlockCondition[] unlockConditions;
    private Feature[] features;
    private Feature[] immutableFeatures;

    public FoundryOutputBuilderParams withAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public FoundryOutputBuilderParams withNativeTokens(NativeToken[] nativeTokens) {
        this.nativeTokens = nativeTokens;
        return this;
    }

    public FoundryOutputBuilderParams withSerialNumber(int serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public FoundryOutputBuilderParams withTokenScheme(TokenScheme tokenScheme) {
        this.tokenScheme = tokenScheme;
        return this;
    }

    public FoundryOutputBuilderParams withUnlockConditions(UnlockCondition[] unlockConditions) {
        this.unlockConditions = unlockConditions;
        return this;
    }

    public FoundryOutputBuilderParams withFeatures(Feature[] features) {
        this.features = features;
        return this;
    }

    public FoundryOutputBuilderParams withImmutableFeatures(Feature[] immutableFeatures) {
        this.immutableFeatures = immutableFeatures;
        return this;
    }

    public JsonObject getJson() {
        JsonObject o = new JsonObject();
        o.addProperty("amount", this.amount);
        o.add("nativeTokens", JsonUtils.toJson(this.nativeTokens));
        o.addProperty("serialNumber", this.serialNumber);
        o.add("tokenScheme", this.tokenScheme != null ? this.tokenScheme.toJson() : null);
        o.add("unlockConditions", JsonUtils.toJson(this.unlockConditions));
        o.add("features", JsonUtils.toJson(this.features));
        o.add("immutableFeatures", JsonUtils.toJson(this.immutableFeatures));
        return o;
    }
}

