/*
 * Decompiled with CFR 0.152.
 */
package org.iota;

import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.iota.apis.HighLevelApi;
import org.iota.apis.MiscellaneousApi;
import org.iota.apis.NativeApi;
import org.iota.apis.NodeCoreApi;
import org.iota.apis.NodeIndexerApi;
import org.iota.apis.UtilsApi;
import org.iota.types.Block;
import org.iota.types.BlockMetadata;
import org.iota.types.BlockPayload;
import org.iota.types.ClientConfig;
import org.iota.types.LedgerNanoStatus;
import org.iota.types.MilestonePayload;
import org.iota.types.Node;
import org.iota.types.Output;
import org.iota.types.OutputMetadata;
import org.iota.types.Peer;
import org.iota.types.PreparedTransactionData;
import org.iota.types.Receipt;
import org.iota.types.TransactionPayload;
import org.iota.types.UtxoInput;
import org.iota.types.expections.ClientException;
import org.iota.types.expections.InitializeClientException;
import org.iota.types.expections.NoFundsReceivedFromFaucetException;
import org.iota.types.ids.AliasId;
import org.iota.types.ids.BlockId;
import org.iota.types.ids.FoundryId;
import org.iota.types.ids.MilestoneId;
import org.iota.types.ids.NftId;
import org.iota.types.ids.OutputId;
import org.iota.types.ids.TransactionId;
import org.iota.types.output_builder.AliasOutputBuilderParams;
import org.iota.types.output_builder.BasicOutputBuilderParams;
import org.iota.types.output_builder.FoundryOutputBuilderParams;
import org.iota.types.output_builder.NftOutputBuilderParams;
import org.iota.types.responses.NodeInfoResponse;
import org.iota.types.responses.ProtocolParametersResponse;
import org.iota.types.responses.TreasuryResponse;
import org.iota.types.responses.UtxoChangesResponse;
import org.iota.types.secret.BuildBlockOptions;
import org.iota.types.secret.GenerateAddressesOptions;
import org.iota.types.secret.SecretManager;

public class Client
extends NativeApi {
    private static final String TESTNET_FAUCET_URL = "https://faucet.testnet.shimmer.network/api/enqueue";
    private NodeCoreApi nodeCoreApi = new NodeCoreApi(this);
    private NodeIndexerApi nodeIndexerApi = new NodeIndexerApi(this);
    private HighLevelApi highLevelApi = new HighLevelApi(this);
    private UtilsApi utilsApi = new UtilsApi(this);
    private MiscellaneousApi miscellaneousApi = new MiscellaneousApi(this);

    public Client(ClientConfig config) throws InitializeClientException {
        super(config);
    }

    @Override
    public void destroyHandle() {
        super.destroyHandle();
    }

    public boolean getHealth(String nodeUrl) throws ClientException {
        return this.nodeCoreApi.getHealth(nodeUrl);
    }

    public NodeInfoResponse getNodeInfo() throws ClientException {
        return this.nodeCoreApi.getNodeInfo();
    }

    public BlockId[] getTips() throws ClientException {
        return this.nodeCoreApi.getTips();
    }

    public BlockId postBlock(Block block) throws ClientException {
        return this.nodeCoreApi.postBlock(block);
    }

    public BlockId postBlockRaw(byte[] blockBytes) throws ClientException {
        return this.nodeCoreApi.postBlockRaw(blockBytes);
    }

    public Block getBlock(BlockId blockId) throws ClientException {
        return this.nodeCoreApi.getBlock(blockId);
    }

    public byte[] getBlockRaw(BlockId blockId) throws ClientException {
        return this.nodeCoreApi.getBlockRaw(blockId);
    }

    public BlockMetadata getBlockMetadata(BlockId blockId) throws ClientException {
        return this.nodeCoreApi.getBlockMetadata(blockId);
    }

    public Map.Entry<Output, OutputMetadata> getOutput(OutputId outputId) throws ClientException {
        return this.nodeCoreApi.getOutput(outputId);
    }

    public OutputMetadata getOutputMetadata(OutputId outputId) throws ClientException {
        return this.nodeCoreApi.getOutputMetadata(outputId);
    }

    public Receipt[] getReceiptsMigratedAt(int milestoneIndex) throws ClientException {
        return this.nodeCoreApi.getReceiptsMigratedAt(milestoneIndex);
    }

    public Receipt[] getReceipts() throws ClientException {
        return this.nodeCoreApi.getReceipts();
    }

    public TreasuryResponse getTreasury() throws ClientException {
        return this.nodeCoreApi.getTreasury();
    }

    public Block getIncludedBlock(TransactionId transactionId) throws ClientException {
        return this.nodeCoreApi.getIncludedBlock(transactionId);
    }

    public MilestonePayload getMilestoneById(MilestoneId milestoneId) throws ClientException {
        return this.nodeCoreApi.getMilestoneById(milestoneId);
    }

    public MilestonePayload getMilestoneByIndex(int milestoneIndex) throws ClientException {
        return this.nodeCoreApi.getMilestoneByIndex(milestoneIndex);
    }

    public byte[] getMilestoneByIdRaw(MilestoneId milestoneId) throws ClientException {
        return this.nodeCoreApi.getMilestoneByIdRaw(milestoneId);
    }

    public byte[] getMilestoneByIndexRaw(int milestoneIndex) throws ClientException {
        return this.nodeCoreApi.getMilestoneByIndexRaw(milestoneIndex);
    }

    public UtxoChangesResponse getUtxoChangesById(MilestoneId milestoneId) throws ClientException {
        return this.nodeCoreApi.getUtxoChangesById(milestoneId);
    }

    public UtxoChangesResponse getUtxoChangesByIndex(int milestoneIndex) throws ClientException {
        return this.nodeCoreApi.getUtxoChangesByIndex(milestoneIndex);
    }

    public Peer[] getPeers() throws ClientException {
        return this.nodeCoreApi.getPeers();
    }

    public OutputId[] getBasicOutputIds(NodeIndexerApi.QueryParams params) throws ClientException {
        return this.nodeIndexerApi.getBasicOutputIds(params);
    }

    public OutputId[] getAliasOutputIds(NodeIndexerApi.QueryParams params) throws ClientException {
        return this.nodeIndexerApi.getAliasOutputIds(params);
    }

    public OutputId[] getNftOutputIds(NodeIndexerApi.QueryParams params) throws ClientException {
        return this.nodeIndexerApi.getNftOutputIds(params);
    }

    public OutputId[] getFoundryOutputIds(NodeIndexerApi.QueryParams params) throws ClientException {
        return this.nodeIndexerApi.getFoundryOutputIds(params);
    }

    public OutputId getAliasOutputIdByAliasId(AliasId aliasId) throws ClientException {
        return this.nodeIndexerApi.getAliasOutputIdByAliasId(aliasId);
    }

    public OutputId getNftOutputIdByNftId(NftId nftId) throws ClientException {
        return this.nodeIndexerApi.getNftOutputIdByNftId(nftId);
    }

    public OutputId getFoundryOutputIdByFoundryId(FoundryId foundryId) throws ClientException {
        return this.nodeIndexerApi.getFoundryOutputIdByFoundryId(foundryId);
    }

    public List<Map.Entry<Output, OutputMetadata>> getOutputs(OutputId[] outputIds) throws ClientException {
        return this.highLevelApi.getOutputs(outputIds);
    }

    public List<Map.Entry<Output, OutputMetadata>> tryGetOutputs(OutputId[] outputIds) throws ClientException {
        return this.highLevelApi.tryGetOutputs(outputIds);
    }

    public Block[] findBlocks(BlockId[] blockIds) throws ClientException {
        return this.highLevelApi.findBlocks(blockIds);
    }

    public Map.Entry<BlockId, Block> retry(BlockId blockId) throws ClientException {
        return this.highLevelApi.retry(blockId);
    }

    public LinkedHashMap<BlockId, Block> retryUntilIncluded(BlockId blockId, int interval, int maxAttempts) throws ClientException {
        return this.highLevelApi.retryUntilIncluded(blockId, interval, maxAttempts);
    }

    public String consolidateFunds(SecretManager secretManager, GenerateAddressesOptions generateAddressesOptions) throws ClientException {
        return this.highLevelApi.consolidateFunds(secretManager, generateAddressesOptions);
    }

    public UtxoInput[] findInputs(String[] addresses, int amount) throws ClientException {
        return this.highLevelApi.findInputs(addresses, amount);
    }

    public List<Map.Entry<Output, OutputMetadata>> findOutputs(OutputId[] outputIds, String[] addresses) throws ClientException {
        return this.highLevelApi.findOutputs(outputIds, addresses);
    }

    public Map.Entry<BlockId, Block> reattach(BlockId blockId) throws ClientException {
        return this.highLevelApi.reattach(blockId);
    }

    public Map.Entry<BlockId, Block> reattachUnchecked(BlockId blockId) throws ClientException {
        return this.highLevelApi.reattachUnchecked(blockId);
    }

    public Map.Entry<BlockId, Block> promote(BlockId blockId) throws ClientException {
        return this.highLevelApi.promote(blockId);
    }

    public Map.Entry<BlockId, Block> promoteUnchecked(BlockId blockId) throws ClientException {
        return this.highLevelApi.promoteUnchecked(blockId);
    }

    public String bech32ToHex(String bech32) throws ClientException {
        return this.utilsApi.bech32ToHex(bech32);
    }

    public String hexToBech32(String hex, String bech32) throws ClientException {
        return this.utilsApi.hexToBech32(hex, bech32);
    }

    public String aliasIdToBech32(AliasId aliasId, String bech32Hrp) throws ClientException {
        return this.utilsApi.aliasIdToBech32(aliasId, bech32Hrp);
    }

    public String hexPublicKeyToBech32Address(String hex, String bech32) throws ClientException {
        return this.utilsApi.hexPublicKeyToBech32Address(hex, bech32);
    }

    public String parseBech32Address(String address) throws ClientException {
        return this.utilsApi.parseBech32Address(address);
    }

    public boolean isAddressValid(String address) throws ClientException {
        return this.utilsApi.isAddressValid(address);
    }

    public String generateMnemonic() throws ClientException {
        return this.utilsApi.generateMnemonic();
    }

    public String mnemonicToHexSeed(String mnemonic) throws ClientException {
        return this.utilsApi.mnemonicToHexSeed(mnemonic);
    }

    public BlockId getBlockId(Block block) throws ClientException {
        return this.utilsApi.computeBlockId(block);
    }

    public TransactionId getTransactionId(TransactionPayload payload) throws ClientException {
        return this.utilsApi.getTransactionId(payload);
    }

    public AliasId computeAliasId(OutputId aliasOutputId) throws ClientException {
        return this.utilsApi.computeAliasId(aliasOutputId);
    }

    public NftId computeNftId(OutputId nftOutputId) throws ClientException {
        return this.utilsApi.computeNftId(nftOutputId);
    }

    public FoundryId computeFoundryId(String aliasAddress, int serialNumber, int tokenScheme) throws ClientException {
        return this.utilsApi.computeFoundryId(aliasAddress, serialNumber, tokenScheme);
    }

    public Output buildAliasOutput(AliasOutputBuilderParams params) throws ClientException {
        return this.miscellaneousApi.buildAliasOutput(params);
    }

    public Output buildBasicOutput(BasicOutputBuilderParams params) throws ClientException {
        return this.miscellaneousApi.buildBasicOutput(params);
    }

    public Output buildFoundryOutput(FoundryOutputBuilderParams params) throws ClientException {
        return this.miscellaneousApi.buildFoundryOutput(params);
    }

    public Output buildNftOutput(NftOutputBuilderParams params) throws ClientException {
        return this.miscellaneousApi.buildNftOutput(params);
    }

    public String[] generateAddresses(SecretManager secretManager, GenerateAddressesOptions generateAddressesOptions) throws ClientException {
        return this.miscellaneousApi.generateAddresses(secretManager, generateAddressesOptions);
    }

    public Map.Entry<BlockId, Block> buildAndPostBlock(SecretManager secretManager, BuildBlockOptions options) throws ClientException {
        return this.miscellaneousApi.buildAndPostBlock(secretManager, options);
    }

    public Node getNode() throws ClientException {
        return this.miscellaneousApi.getNode();
    }

    public JsonObject getNetworkInfo() throws ClientException {
        return this.miscellaneousApi.getNetworkInfo();
    }

    public int getNetworkId() throws ClientException {
        return this.miscellaneousApi.getNetworkId();
    }

    public String getBech32Hrp() throws ClientException {
        return this.miscellaneousApi.getBech32Hrp();
    }

    public float getMinPowScore() throws ClientException {
        return this.miscellaneousApi.getMinPowScore();
    }

    public int getTipsInterval() throws ClientException {
        return this.miscellaneousApi.getTipsInterval();
    }

    public boolean getLocalPow() throws ClientException {
        return this.miscellaneousApi.getLocalPow();
    }

    public boolean getFallbackToLocalPow() throws ClientException {
        return this.miscellaneousApi.isFallbackToLocalPow();
    }

    public Node[] getUnhealthyNodes() throws ClientException {
        return this.miscellaneousApi.getUnhealthyNodes();
    }

    public LedgerNanoStatus getLedgerNanoStatus(boolean isSimulator) throws ClientException {
        return this.miscellaneousApi.getLedgerNanoStatus(isSimulator);
    }

    public PreparedTransactionData prepareTransaction(SecretManager secretManager, BuildBlockOptions buildBlockOptions) throws ClientException {
        return this.miscellaneousApi.prepareTransaction(secretManager, buildBlockOptions);
    }

    public TransactionPayload signTransaction(SecretManager secretManager, PreparedTransactionData preparedTransactionData) throws ClientException {
        return this.miscellaneousApi.signTransaction(secretManager, preparedTransactionData);
    }

    public void storeMnemonic(SecretManager secretManager, String mnemonic) throws ClientException {
        this.miscellaneousApi.storeMnemonic(secretManager, mnemonic);
    }

    public Map.Entry<BlockId, Block> postBlockPayload(BlockPayload payload) throws ClientException {
        return this.miscellaneousApi.postBlockPayload(payload);
    }

    public String getTokenSupply() throws ClientException {
        return this.getProtocolParameters().getTokenSupply();
    }

    public ProtocolParametersResponse getProtocolParameters() throws ClientException {
        return this.miscellaneousApi.getProtocolParameters();
    }

    public void requestTestFundsFromFaucet(String address) throws ClientException, NoFundsReceivedFromFaucetException {
        int maxAttempts = 5;
        for (int i = 0; i < maxAttempts; ++i) {
            if (this.getBasicOutputIds(new NodeIndexerApi.QueryParams().withParam("address", address)).length == 0) {
                this.utilsApi.requestFundsFromFaucet(TESTNET_FAUCET_URL, address);
                try {
                    Thread.sleep(25000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            return;
        }
        if (this.getBasicOutputIds(new NodeIndexerApi.QueryParams().withParam("address", address)).length == 0) {
            throw new NoFundsReceivedFromFaucetException();
        }
    }
}

