/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.dataconversion;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.bio.dataconversion.BioFileConverter;
import org.intermine.dataconversion.ItemWriter;
import org.intermine.metadata.Model;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.xml.full.Item;
import psidev.psi.mi.jami.commons.MIDataSourceOptionFactory;
import psidev.psi.mi.jami.commons.MIFileType;
import psidev.psi.mi.jami.commons.MIWriterOptionFactory;
import psidev.psi.mi.jami.commons.PsiJami;
import psidev.psi.mi.jami.datasource.InteractionStream;
import psidev.psi.mi.jami.factory.MIDataSourceFactory;
import psidev.psi.mi.jami.model.Alias;
import psidev.psi.mi.jami.model.Annotation;
import psidev.psi.mi.jami.model.Complex;
import psidev.psi.mi.jami.model.CvTerm;
import psidev.psi.mi.jami.model.Feature;
import psidev.psi.mi.jami.model.Interaction;
import psidev.psi.mi.jami.model.InteractionCategory;
import psidev.psi.mi.jami.model.Interactor;
import psidev.psi.mi.jami.model.ModelledParticipant;
import psidev.psi.mi.jami.model.Organism;
import psidev.psi.mi.jami.model.Position;
import psidev.psi.mi.jami.model.Range;
import psidev.psi.mi.jami.model.Stoichiometry;
import psidev.psi.mi.jami.model.Xref;
import uk.ac.ebi.chebi.webapps.chebiWS.client.ChebiWebServiceClient;
import uk.ac.ebi.chebi.webapps.chebiWS.model.Entity;

public class PsiComplexesConverter
extends BioFileConverter {
    private static final Logger LOG = Logger.getLogger(PsiComplexesConverter.class);
    private static final String DATASET_TITLE = "IntAct Complexes";
    private static final String DATA_SOURCE_NAME = "EBI IntAct";
    private static final String COMPLEX_PROPERTIES = "complex-properties";
    private static final String INTERACTION_TYPE = "physical";
    private static final String DEFAULT_INTERACTOR_TYPE = "BioEntity";
    private static final String PROTEIN = "MI:0326";
    private static final String SMALL_MOLECULE = "MI:0328";
    private static final String BINDING_SITE = "binding region";
    private static final String DIRECT_BINDING = "direct binding";
    private static final String GENE_ONTOLOGY = "go";
    private static final String PUBMED = "pubmed";
    private static final String EBI = "intact";
    private String xrefDatabase;
    private static final String COMPLEX_NAME = "complex recommended name";
    private static final Map<String, String> INTERACTOR_TYPES = new HashMap<String, String>();
    private Map<String, String> terms = new HashMap<String, String>();
    private Map<String, String> interactors = new HashMap<String, String>();
    private Map<String, String> publications = new HashMap<String, String>();

    public PsiComplexesConverter(ItemWriter writer, Model model) {
        super(writer, model, DATA_SOURCE_NAME, DATASET_TITLE);
    }

    public void setComplexesSource(String identifierSource) {
        this.xrefDatabase = identifierSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Reader reader) throws Exception {
        PsiJami.initialiseAllFactories();
        MIDataSourceOptionFactory optionfactory = MIDataSourceOptionFactory.getInstance();
        MIDataSourceFactory dataSourceFactory = MIDataSourceFactory.getInstance();
        Map parsingOptions = MIDataSourceOptionFactory.getInstance().getOptions(MIFileType.psimi_xml, InteractionCategory.complex, null, true, null, (Object)reader);
        try (InteractionStream interactionSource = null;){
            interactionSource = dataSourceFactory.getInteractionSourceWith(parsingOptions);
            MIWriterOptionFactory optionwriterFactory = MIWriterOptionFactory.getInstance();
            if (interactionSource != null) {
                Iterator interactionIterator = interactionSource.getInteractionsIterator();
                while (interactionIterator.hasNext()) {
                    Interaction entry = (Interaction)interactionIterator.next();
                    if (!(entry instanceof Complex)) continue;
                    Complex interactionEvidence = (Complex)entry;
                    Item complex = this.createItem("Complex");
                    this.processIdentifiers(interactionEvidence, complex);
                    this.processAnnotations(interactionEvidence, complex);
                    DetailHolder detail = new DetailHolder();
                    this.processType(interactionEvidence, detail);
                    this.processInteractions(interactionEvidence, detail, complex);
                    this.processXrefs(interactionEvidence, complex);
                    this.store(complex);
                }
            }
        }
    }

    private void processIdentifiers(Complex interactionEvidence, Item complex) {
        String systematicName;
        String identifier = this.getComplexIdentifier(interactionEvidence);
        if (StringUtils.isNotEmpty((String)identifier)) {
            complex.setAttribute("identifier", identifier);
        }
        if (StringUtils.isNotEmpty((String)(systematicName = interactionEvidence.getSystematicName()))) {
            complex.setAttribute("systematicName", systematicName);
        }
        Collection aliases = interactionEvidence.getAliases();
        for (Alias alias : aliases) {
            CvTerm type = alias.getType();
            if (!COMPLEX_NAME.equals(type.getShortName())) continue;
            complex.setAttribute("name", alias.getName());
        }
    }

    private void processInteractions(Complex interactionEvidence, DetailHolder detail, Item complex) throws ObjectStoreException {
        for (ModelledParticipant modelledParticipant : interactionEvidence.getParticipants()) {
            Item interactor = this.createItem("Interactor");
            this.processAnnotations(modelledParticipant, interactor);
            this.setBiologicalRole(modelledParticipant, interactor);
            String refId = this.processProtein(modelledParticipant.getInteractor());
            if (refId == null) {
                return;
            }
            interactor.setReference("participant", refId);
            for (Feature feature : modelledParticipant.getFeatures()) {
                Collection linkedFeatures = feature.getLinkedFeatures();
                for (Feature linkedFeature : linkedFeatures) {
                    CvTerm term = linkedFeature.getType();
                    String type = term.getShortName();
                    if (!BINDING_SITE.equals(type) && !DIRECT_BINDING.equals(type)) continue;
                    String binderRefId = this.processProtein(linkedFeature.getParticipant().getInteractor());
                    Item interaction = this.createItem("Interaction");
                    interaction.setReference("participant1", refId);
                    interaction.setReference("participant2", binderRefId);
                    interaction.setReference("complex", complex);
                    this.store(interaction);
                    interactor.addToCollection("interactions", interaction);
                    Item detailItem = this.createItem("InteractionDetail");
                    detailItem.setAttribute("type", INTERACTION_TYPE);
                    detailItem.setAttribute("relationshipType", detail.getRelationshipType());
                    detailItem.setReference("interaction", interaction);
                    detailItem.setCollection("allInteractors", detail.getAllInteractors());
                    this.processRegions(linkedFeature.getRanges(), detailItem, refId, binderRefId);
                    this.store(detailItem);
                }
            }
            this.processStoichiometry(modelledParticipant, interactor);
            this.setInteractorType(modelledParticipant, interactor);
            this.store(interactor);
            detail.addInteractor(interactor.getIdentifier());
            complex.addToCollection("allInteractors", interactor);
        }
    }

    private void processRegions(Collection<Range> ranges, Item detail, String feature, String locatedOn) throws ObjectStoreException {
        for (Range range : ranges) {
            Item location = this.createItem("Location");
            Position startPosition = range.getStart();
            Position endPosition = range.getEnd();
            Long start = startPosition.getStart();
            Long end = endPosition.getStart();
            location.setAttribute("start", String.valueOf(start));
            location.setAttribute("end", String.valueOf(end));
            location.setReference("locatedOn", locatedOn);
            location.setReference("feature", feature);
            this.store(location);
            Item region = this.createItem("InteractionRegion");
            region.addToCollection("locations", location);
            region.setReference("interaction", detail);
            this.store(region);
        }
    }

    private void setBiologicalRole(ModelledParticipant modelledParticipant, Item interactor) throws ObjectStoreException {
        CvTerm biologicalRole = modelledParticipant.getBiologicalRole();
        String termName = biologicalRole.getFullName();
        interactor.setAttribute("biologicalRole", termName);
    }

    private void setInteractorType(ModelledParticipant modelledParticipant, Item interactor) throws ObjectStoreException {
        CvTerm interactorType = modelledParticipant.getInteractor().getInteractorType();
        String termName = interactorType.getFullName();
        interactor.setAttribute("type", termName);
    }

    private String getComplexIdentifier(Complex complex) {
        Collection xrefs = complex.getIdentifiers();
        for (Xref xref : xrefs) {
            CvTerm cvTerm = xref.getDatabase();
            if (!EBI.equalsIgnoreCase(cvTerm.getShortName())) continue;
            return xref.getId();
        }
        return null;
    }

    private String processProtein(Interactor participant) throws ObjectStoreException {
        String refId;
        String accession;
        String primaryIdentifier = null;
        for (Xref xref : participant.getXrefs()) {
            if (!this.xrefDatabase.equalsIgnoreCase(xref.getDatabase().getShortName())) continue;
            primaryIdentifier = xref.getId();
        }
        Xref xref = participant.getPreferredIdentifier();
        String originalAccession = xref.getId();
        boolean createSynonym = false;
        if (originalAccession.contains("-PRO")) {
            accession = originalAccession.substring(0, originalAccession.indexOf("-PRO"));
            createSynonym = true;
        } else {
            accession = originalAccession;
        }
        if (StringUtils.isEmpty((String)primaryIdentifier)) {
            primaryIdentifier = accession;
        }
        if ((refId = this.interactors.get(primaryIdentifier)) == null) {
            int taxonId;
            String smallMolecule;
            String typeTermIdentifier = participant.getInteractorType().getMIIdentifier();
            String interactorType = INTERACTOR_TYPES.get(typeTermIdentifier);
            if (interactorType == null) {
                LOG.error((Object)("Unknown interactor type: " + typeTermIdentifier));
                interactorType = DEFAULT_INTERACTOR_TYPE;
            }
            Item protein = this.createItem(interactorType);
            protein.setAttribute("primaryIdentifier", primaryIdentifier);
            if (PROTEIN.equals(typeTermIdentifier)) {
                protein.setAttribute("primaryAccession", accession);
            } else if (SMALL_MOLECULE.equals(typeTermIdentifier) && StringUtils.isNotEmpty((String)(smallMolecule = this.getChebiName(primaryIdentifier)))) {
                protein.setAttribute("name", smallMolecule);
            }
            Organism organism = participant.getOrganism();
            if (organism != null && (taxonId = organism.getTaxId()) >= 1) {
                String organismRefId = this.getOrganism(String.valueOf(taxonId));
                protein.setReference("organism", organismRefId);
            }
            this.store(protein);
            refId = protein.getIdentifier();
            this.interactors.put(primaryIdentifier, refId);
        }
        if (createSynonym) {
            this.createSynonym(refId, originalAccession, true);
            String proIdentifier = originalAccession.substring(originalAccession.indexOf("-") + 1);
            this.createSynonym(refId, proIdentifier, true);
        }
        return refId;
    }

    private String getChebiName(String identifier) {
        try {
            ChebiWebServiceClient client = new ChebiWebServiceClient();
            Entity entity = client.getCompleteEntity(identifier);
            return entity.getChebiAsciiName();
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage());
            return null;
        }
    }

    private void processStoichiometry(ModelledParticipant modelledParticipant, Item interactor) throws ObjectStoreException {
        Stoichiometry stoichiometry = modelledParticipant.getStoichiometry();
        if (stoichiometry == null) {
            return;
        }
        interactor.setAttribute("stoichiometry", String.valueOf(stoichiometry.getMaxValue()));
    }

    private void processXrefs(Complex interactionEvidence, Item complex) throws ObjectStoreException {
        for (Xref xref : interactionEvidence.getXrefs()) {
            CvTerm dbTerm = xref.getDatabase();
            String xrefId = xref.getId();
            CvTerm qualifierTerm = xref.getQualifier();
            if (GENE_ONTOLOGY.equalsIgnoreCase(dbTerm.getShortName())) {
                String goterm = this.getTerm("GOTerm", xrefId);
                Item goAnnotation = this.createItem("GOAnnotation");
                if (qualifierTerm != null) {
                    goAnnotation.setAttribute("qualifier", qualifierTerm.getShortName());
                }
                goAnnotation.setReference("ontologyTerm", goterm);
                this.store(goAnnotation);
                complex.addToCollection("goAnnotation", goAnnotation);
                continue;
            }
            if (!PUBMED.equalsIgnoreCase(dbTerm.getShortName())) continue;
            complex.addToCollection("publications", this.getPublication(xrefId));
        }
    }

    private void processType(Complex interactionEvidence, DetailHolder detail) throws ObjectStoreException {
        CvTerm cvterm = interactionEvidence.getInteractionType();
        if (cvterm != null) {
            String termName = cvterm.getFullName();
            detail.setRelationshipType(termName);
        }
    }

    private void processAnnotations(ModelledParticipant modelledParticipant, Item interactor) {
        StringBuilder annotations = new StringBuilder();
        for (Annotation annotation : modelledParticipant.getAnnotations()) {
            annotations.append(annotation.getValue() + " ");
        }
        if (StringUtils.isNotEmpty((String)annotations.toString())) {
            interactor.setAttribute("annotations", annotations.toString());
        }
    }

    private void processAnnotations(Complex interactionEvidence, Item item) {
        StringBuffer complexProperties = new StringBuffer();
        StringBuffer complexFunction = new StringBuffer();
        Collection annotations = interactionEvidence.getAnnotations();
        for (Annotation annotation : annotations) {
            String value = annotation.getValue();
            CvTerm term = annotation.getTopic();
            String termName = term.getShortName();
            if (COMPLEX_PROPERTIES.equals(termName)) {
                complexProperties.append(value + " ");
                continue;
            }
            complexFunction.append(value + " ");
        }
        if (StringUtils.isNotEmpty((String)complexProperties.toString())) {
            item.setAttribute("properties", complexProperties.toString());
        }
        if (StringUtils.isNotEmpty((String)complexFunction.toString())) {
            item.setAttribute("function", complexFunction.toString());
        }
    }

    private String getTerm(String termType, String identifier) throws ObjectStoreException {
        String refId = this.terms.get(identifier);
        if (refId == null) {
            Item ontologyTerm = this.createItem(termType);
            ontologyTerm.setAttribute("identifier", identifier);
            this.store(ontologyTerm);
            refId = ontologyTerm.getIdentifier();
            this.terms.put(identifier, refId);
        }
        return refId;
    }

    private String getPublication(String pubMedId) throws ObjectStoreException {
        String refId = this.publications.get(pubMedId);
        if (refId == null) {
            Item item = this.createItem("Publication");
            item.setAttribute("pubMedId", pubMedId);
            this.store(item);
            refId = item.getIdentifier();
            this.publications.put(pubMedId, refId);
        }
        return refId;
    }

    static {
        INTERACTOR_TYPES.put(PROTEIN, "Protein");
        INTERACTOR_TYPES.put(SMALL_MOLECULE, "SmallMolecule");
        INTERACTOR_TYPES.put("MI:0320", "RNA");
        INTERACTOR_TYPES.put("MI:0609", "SnoRNA");
    }

    private class DetailHolder {
        protected String relationshipType;
        protected List<String> allInteractors = new ArrayList<String>();

        protected DetailHolder() {
        }

        protected String getRelationshipType() {
            return this.relationshipType;
        }

        protected void setRelationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
        }

        protected List<String> getAllInteractors() {
            return this.allInteractors;
        }

        protected void addInteractor(String interactor) {
            this.allInteractors.add(interactor);
        }
    }
}

