/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.model.bio;

import java.util.HashSet;
import java.util.Set;
import org.intermine.metadata.TypeUtil;
import org.intermine.model.InterMineObject;
import org.intermine.model.ShadowClass;
import org.intermine.model.StringConstructor;
import org.intermine.model.bio.CDS;
import org.intermine.model.bio.CrossReference;
import org.intermine.model.bio.DataSet;
import org.intermine.model.bio.Gene;
import org.intermine.model.bio.Location;
import org.intermine.model.bio.OntologyAnnotation;
import org.intermine.model.bio.Organism;
import org.intermine.model.bio.Protein;
import org.intermine.model.bio.Publication;
import org.intermine.model.bio.Sequence;
import org.intermine.model.bio.Synonym;
import org.intermine.model.bio.Transcript;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.intermine.NotXmlParser;
import org.intermine.objectstore.intermine.NotXmlRenderer;
import org.intermine.objectstore.proxy.ProxyCollection;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.util.DynamicUtil;

public class ProteinShadow
implements Protein,
ShadowClass {
    public static final Class<Protein> shadowOf = Protein.class;
    protected String md5checksum;
    protected String primaryAccession;
    protected Double molecularWeight;
    protected Integer length;
    protected InterMineObject sequence;
    protected Set<CDS> CDSs = new HashSet<CDS>();
    protected Set<Gene> genes = new HashSet<Gene>();
    protected Set<Transcript> transcripts = new HashSet<Transcript>();
    protected String symbol;
    protected String name;
    protected String secondaryIdentifier;
    protected InterMineObject organism;
    protected Set<Location> locatedFeatures = new HashSet<Location>();
    protected Set<Location> locations = new HashSet<Location>();
    protected Set<Synonym> synonyms = new HashSet<Synonym>();
    protected Set<DataSet> dataSets = new HashSet<DataSet>();
    protected Set<CrossReference> crossReferences = new HashSet<CrossReference>();
    protected String primaryIdentifier;
    protected Set<OntologyAnnotation> ontologyAnnotations = new HashSet<OntologyAnnotation>();
    protected Set<Publication> publications = new HashSet<Publication>();
    protected Integer id;

    @Override
    public String getMd5checksum() {
        return this.md5checksum;
    }

    @Override
    public void setMd5checksum(String md5checksum) {
        this.md5checksum = md5checksum;
    }

    @Override
    public String getPrimaryAccession() {
        return this.primaryAccession;
    }

    @Override
    public void setPrimaryAccession(String primaryAccession) {
        this.primaryAccession = primaryAccession;
    }

    @Override
    public Double getMolecularWeight() {
        return this.molecularWeight;
    }

    @Override
    public void setMolecularWeight(Double molecularWeight) {
        this.molecularWeight = molecularWeight;
    }

    @Override
    public Integer getLength() {
        return this.length;
    }

    @Override
    public void setLength(Integer length) {
        this.length = length;
    }

    @Override
    public Sequence getSequence() {
        if (this.sequence instanceof ProxyReference) {
            return (Sequence)((ProxyReference)this.sequence).getObject();
        }
        return (Sequence)this.sequence;
    }

    @Override
    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    @Override
    public void proxySequence(ProxyReference sequence) {
        this.sequence = sequence;
    }

    @Override
    public InterMineObject proxGetSequence() {
        return this.sequence;
    }

    @Override
    public Set<CDS> getcDSs() {
        return this.CDSs;
    }

    @Override
    public void setcDSs(Set<CDS> CDSs) {
        this.CDSs = CDSs;
    }

    @Override
    public void addcDSs(CDS arg) {
        this.CDSs.add(arg);
    }

    @Override
    public Set<Gene> getGenes() {
        return this.genes;
    }

    @Override
    public void setGenes(Set<Gene> genes) {
        this.genes = genes;
    }

    @Override
    public void addGenes(Gene arg) {
        this.genes.add(arg);
    }

    @Override
    public Set<Transcript> getTranscripts() {
        return this.transcripts;
    }

    @Override
    public void setTranscripts(Set<Transcript> transcripts) {
        this.transcripts = transcripts;
    }

    @Override
    public void addTranscripts(Transcript arg) {
        this.transcripts.add(arg);
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSecondaryIdentifier() {
        return this.secondaryIdentifier;
    }

    @Override
    public void setSecondaryIdentifier(String secondaryIdentifier) {
        this.secondaryIdentifier = secondaryIdentifier;
    }

    @Override
    public Organism getOrganism() {
        if (this.organism instanceof ProxyReference) {
            return (Organism)((ProxyReference)this.organism).getObject();
        }
        return (Organism)this.organism;
    }

    @Override
    public void setOrganism(Organism organism) {
        this.organism = organism;
    }

    @Override
    public void proxyOrganism(ProxyReference organism) {
        this.organism = organism;
    }

    @Override
    public InterMineObject proxGetOrganism() {
        return this.organism;
    }

    @Override
    public Set<Location> getLocatedFeatures() {
        return this.locatedFeatures;
    }

    @Override
    public void setLocatedFeatures(Set<Location> locatedFeatures) {
        this.locatedFeatures = locatedFeatures;
    }

    @Override
    public void addLocatedFeatures(Location arg) {
        this.locatedFeatures.add(arg);
    }

    @Override
    public Set<Location> getLocations() {
        return this.locations;
    }

    @Override
    public void setLocations(Set<Location> locations) {
        this.locations = locations;
    }

    @Override
    public void addLocations(Location arg) {
        this.locations.add(arg);
    }

    @Override
    public Set<Synonym> getSynonyms() {
        return this.synonyms;
    }

    @Override
    public void setSynonyms(Set<Synonym> synonyms) {
        this.synonyms = synonyms;
    }

    @Override
    public void addSynonyms(Synonym arg) {
        this.synonyms.add(arg);
    }

    @Override
    public Set<DataSet> getDataSets() {
        return this.dataSets;
    }

    @Override
    public void setDataSets(Set<DataSet> dataSets) {
        this.dataSets = dataSets;
    }

    @Override
    public void addDataSets(DataSet arg) {
        this.dataSets.add(arg);
    }

    @Override
    public Set<CrossReference> getCrossReferences() {
        return this.crossReferences;
    }

    @Override
    public void setCrossReferences(Set<CrossReference> crossReferences) {
        this.crossReferences = crossReferences;
    }

    @Override
    public void addCrossReferences(CrossReference arg) {
        this.crossReferences.add(arg);
    }

    @Override
    public String getPrimaryIdentifier() {
        return this.primaryIdentifier;
    }

    @Override
    public void setPrimaryIdentifier(String primaryIdentifier) {
        this.primaryIdentifier = primaryIdentifier;
    }

    @Override
    public Set<OntologyAnnotation> getOntologyAnnotations() {
        return this.ontologyAnnotations;
    }

    @Override
    public void setOntologyAnnotations(Set<OntologyAnnotation> ontologyAnnotations) {
        this.ontologyAnnotations = ontologyAnnotations;
    }

    @Override
    public void addOntologyAnnotations(OntologyAnnotation arg) {
        this.ontologyAnnotations.add(arg);
    }

    @Override
    public Set<Publication> getPublications() {
        return this.publications;
    }

    @Override
    public void setPublications(Set<Publication> publications) {
        this.publications = publications;
    }

    @Override
    public void addPublications(Publication arg) {
        this.publications.add(arg);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        return o instanceof Protein && this.id != null ? this.id.equals(((Protein)o).getId()) : this == o;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }

    public String toString() {
        return "Protein [id=" + this.id + ", length=" + this.length + ", md5checksum=" + (this.md5checksum == null ? "null" : "\"" + this.md5checksum + "\"") + ", molecularWeight=" + this.molecularWeight + ", name=" + (this.name == null ? "null" : "\"" + this.name + "\"") + ", organism=" + (this.organism == null ? "null" : (this.organism.getId() == null ? "no id" : this.organism.getId().toString())) + ", primaryAccession=" + (this.primaryAccession == null ? "null" : "\"" + this.primaryAccession + "\"") + ", primaryIdentifier=" + (this.primaryIdentifier == null ? "null" : "\"" + this.primaryIdentifier + "\"") + ", secondaryIdentifier=" + (this.secondaryIdentifier == null ? "null" : "\"" + this.secondaryIdentifier + "\"") + ", sequence=" + (this.sequence == null ? "null" : (this.sequence.getId() == null ? "no id" : this.sequence.getId().toString())) + ", symbol=" + (this.symbol == null ? "null" : "\"" + this.symbol + "\"") + "]";
    }

    public Object getFieldValue(String fieldName) throws IllegalAccessException {
        if ("md5checksum".equals(fieldName)) {
            return this.md5checksum;
        }
        if ("primaryAccession".equals(fieldName)) {
            return this.primaryAccession;
        }
        if ("molecularWeight".equals(fieldName)) {
            return this.molecularWeight;
        }
        if ("length".equals(fieldName)) {
            return this.length;
        }
        if ("sequence".equals(fieldName)) {
            if (this.sequence instanceof ProxyReference) {
                return ((ProxyReference)this.sequence).getObject();
            }
            return this.sequence;
        }
        if ("CDSs".equals(fieldName)) {
            return this.CDSs;
        }
        if ("genes".equals(fieldName)) {
            return this.genes;
        }
        if ("transcripts".equals(fieldName)) {
            return this.transcripts;
        }
        if ("symbol".equals(fieldName)) {
            return this.symbol;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("secondaryIdentifier".equals(fieldName)) {
            return this.secondaryIdentifier;
        }
        if ("organism".equals(fieldName)) {
            if (this.organism instanceof ProxyReference) {
                return ((ProxyReference)this.organism).getObject();
            }
            return this.organism;
        }
        if ("locatedFeatures".equals(fieldName)) {
            return this.locatedFeatures;
        }
        if ("locations".equals(fieldName)) {
            return this.locations;
        }
        if ("synonyms".equals(fieldName)) {
            return this.synonyms;
        }
        if ("dataSets".equals(fieldName)) {
            return this.dataSets;
        }
        if ("crossReferences".equals(fieldName)) {
            return this.crossReferences;
        }
        if ("primaryIdentifier".equals(fieldName)) {
            return this.primaryIdentifier;
        }
        if ("ontologyAnnotations".equals(fieldName)) {
            return this.ontologyAnnotations;
        }
        if ("publications".equals(fieldName)) {
            return this.publications;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if (!Protein.class.equals(this.getClass())) {
            return TypeUtil.getFieldValue((Object)this, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }

    public Object getFieldProxy(String fieldName) throws IllegalAccessException {
        if ("md5checksum".equals(fieldName)) {
            return this.md5checksum;
        }
        if ("primaryAccession".equals(fieldName)) {
            return this.primaryAccession;
        }
        if ("molecularWeight".equals(fieldName)) {
            return this.molecularWeight;
        }
        if ("length".equals(fieldName)) {
            return this.length;
        }
        if ("sequence".equals(fieldName)) {
            return this.sequence;
        }
        if ("CDSs".equals(fieldName)) {
            return this.CDSs;
        }
        if ("genes".equals(fieldName)) {
            return this.genes;
        }
        if ("transcripts".equals(fieldName)) {
            return this.transcripts;
        }
        if ("symbol".equals(fieldName)) {
            return this.symbol;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("secondaryIdentifier".equals(fieldName)) {
            return this.secondaryIdentifier;
        }
        if ("organism".equals(fieldName)) {
            return this.organism;
        }
        if ("locatedFeatures".equals(fieldName)) {
            return this.locatedFeatures;
        }
        if ("locations".equals(fieldName)) {
            return this.locations;
        }
        if ("synonyms".equals(fieldName)) {
            return this.synonyms;
        }
        if ("dataSets".equals(fieldName)) {
            return this.dataSets;
        }
        if ("crossReferences".equals(fieldName)) {
            return this.crossReferences;
        }
        if ("primaryIdentifier".equals(fieldName)) {
            return this.primaryIdentifier;
        }
        if ("ontologyAnnotations".equals(fieldName)) {
            return this.ontologyAnnotations;
        }
        if ("publications".equals(fieldName)) {
            return this.publications;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if (!Protein.class.equals(this.getClass())) {
            return TypeUtil.getFieldProxy((Object)this, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }

    public void setFieldValue(String fieldName, Object value) {
        if ("md5checksum".equals(fieldName)) {
            this.md5checksum = (String)value;
        } else if ("primaryAccession".equals(fieldName)) {
            this.primaryAccession = (String)value;
        } else if ("molecularWeight".equals(fieldName)) {
            this.molecularWeight = (Double)value;
        } else if ("length".equals(fieldName)) {
            this.length = (Integer)value;
        } else if ("sequence".equals(fieldName)) {
            this.sequence = (InterMineObject)value;
        } else if ("CDSs".equals(fieldName)) {
            this.CDSs = (Set)value;
        } else if ("genes".equals(fieldName)) {
            this.genes = (Set)value;
        } else if ("transcripts".equals(fieldName)) {
            this.transcripts = (Set)value;
        } else if ("symbol".equals(fieldName)) {
            this.symbol = (String)value;
        } else if ("name".equals(fieldName)) {
            this.name = (String)value;
        } else if ("secondaryIdentifier".equals(fieldName)) {
            this.secondaryIdentifier = (String)value;
        } else if ("organism".equals(fieldName)) {
            this.organism = (InterMineObject)value;
        } else if ("locatedFeatures".equals(fieldName)) {
            this.locatedFeatures = (Set)value;
        } else if ("locations".equals(fieldName)) {
            this.locations = (Set)value;
        } else if ("synonyms".equals(fieldName)) {
            this.synonyms = (Set)value;
        } else if ("dataSets".equals(fieldName)) {
            this.dataSets = (Set)value;
        } else if ("crossReferences".equals(fieldName)) {
            this.crossReferences = (Set)value;
        } else if ("primaryIdentifier".equals(fieldName)) {
            this.primaryIdentifier = (String)value;
        } else if ("ontologyAnnotations".equals(fieldName)) {
            this.ontologyAnnotations = (Set)value;
        } else if ("publications".equals(fieldName)) {
            this.publications = (Set)value;
        } else if ("id".equals(fieldName)) {
            this.id = (Integer)value;
        } else {
            if (!Protein.class.equals(this.getClass())) {
                DynamicUtil.setFieldValue((Object)this, (String)fieldName, (Object)value);
                return;
            }
            throw new IllegalArgumentException("Unknown field " + fieldName);
        }
    }

    public Class<?> getFieldType(String fieldName) {
        if ("md5checksum".equals(fieldName)) {
            return String.class;
        }
        if ("primaryAccession".equals(fieldName)) {
            return String.class;
        }
        if ("molecularWeight".equals(fieldName)) {
            return Double.class;
        }
        if ("length".equals(fieldName)) {
            return Integer.class;
        }
        if ("sequence".equals(fieldName)) {
            return Sequence.class;
        }
        if ("CDSs".equals(fieldName)) {
            return Set.class;
        }
        if ("genes".equals(fieldName)) {
            return Set.class;
        }
        if ("transcripts".equals(fieldName)) {
            return Set.class;
        }
        if ("symbol".equals(fieldName)) {
            return String.class;
        }
        if ("name".equals(fieldName)) {
            return String.class;
        }
        if ("secondaryIdentifier".equals(fieldName)) {
            return String.class;
        }
        if ("organism".equals(fieldName)) {
            return Organism.class;
        }
        if ("locatedFeatures".equals(fieldName)) {
            return Set.class;
        }
        if ("locations".equals(fieldName)) {
            return Set.class;
        }
        if ("synonyms".equals(fieldName)) {
            return Set.class;
        }
        if ("dataSets".equals(fieldName)) {
            return Set.class;
        }
        if ("crossReferences".equals(fieldName)) {
            return Set.class;
        }
        if ("primaryIdentifier".equals(fieldName)) {
            return String.class;
        }
        if ("ontologyAnnotations".equals(fieldName)) {
            return Set.class;
        }
        if ("publications".equals(fieldName)) {
            return Set.class;
        }
        if ("id".equals(fieldName)) {
            return Integer.class;
        }
        if (!Protein.class.equals(this.getClass())) {
            return TypeUtil.getFieldType(Protein.class, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }

    public StringConstructor getoBJECT() {
        int delimPosition;
        String string;
        if (!ProteinShadow.class.equals(this.getClass())) {
            return NotXmlRenderer.render((Object)this);
        }
        StringConstructor sb = new StringConstructor();
        sb.append("$_^org.intermine.model.bio.Protein");
        if (this.md5checksum != null) {
            sb.append("$_^amd5checksum$_^");
            string = this.md5checksum;
            while (string != null) {
                delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.primaryAccession != null) {
            sb.append("$_^aprimaryAccession$_^");
            string = this.primaryAccession;
            while (string != null) {
                delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.molecularWeight != null) {
            sb.append("$_^amolecularWeight$_^").append((Object)this.molecularWeight);
        }
        if (this.length != null) {
            sb.append("$_^alength$_^").append((Object)this.length);
        }
        if (this.sequence != null) {
            sb.append("$_^rsequence$_^").append((Object)this.sequence.getId());
        }
        if (this.symbol != null) {
            sb.append("$_^asymbol$_^");
            string = this.symbol;
            while (string != null) {
                delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.name != null) {
            sb.append("$_^aname$_^");
            string = this.name;
            while (string != null) {
                delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.secondaryIdentifier != null) {
            sb.append("$_^asecondaryIdentifier$_^");
            string = this.secondaryIdentifier;
            while (string != null) {
                delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.organism != null) {
            sb.append("$_^rorganism$_^").append((Object)this.organism.getId());
        }
        if (this.primaryIdentifier != null) {
            sb.append("$_^aprimaryIdentifier$_^");
            string = this.primaryIdentifier;
            while (string != null) {
                delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.id != null) {
            sb.append("$_^aid$_^").append((Object)this.id);
        }
        return sb;
    }

    public void setoBJECT(String notXml, ObjectStore os) {
        this.setoBJECT(NotXmlParser.SPLITTER.split(notXml), os);
    }

    public void setoBJECT(String[] notXml, ObjectStore os) {
        if (!ProteinShadow.class.equals(this.getClass())) {
            throw new IllegalStateException("Class " + this.getClass().getName() + " does not match code (org.intermine.model.bio.Protein)");
        }
        int i = 2;
        while (i < notXml.length) {
            StringBuilder string;
            int startI = i;
            if (i < notXml.length && "amd5checksum".equals(notXml[i])) {
                ++i;
                string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.md5checksum = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "aprimaryAccession".equals(notXml[i])) {
                ++i;
                string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.primaryAccession = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "amolecularWeight".equals(notXml[i])) {
                this.molecularWeight = Double.valueOf(notXml[++i]);
                ++i;
            }
            if (i < notXml.length && "alength".equals(notXml[i])) {
                this.length = Integer.valueOf(notXml[++i]);
                ++i;
            }
            if (i < notXml.length && "rsequence".equals(notXml[i])) {
                this.sequence = new ProxyReference(os, Integer.valueOf(notXml[++i]), Sequence.class);
                ++i;
            }
            if (i < notXml.length && "asymbol".equals(notXml[i])) {
                ++i;
                string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.symbol = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "aname".equals(notXml[i])) {
                ++i;
                string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.name = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "asecondaryIdentifier".equals(notXml[i])) {
                ++i;
                string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.secondaryIdentifier = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "rorganism".equals(notXml[i])) {
                this.organism = new ProxyReference(os, Integer.valueOf(notXml[++i]), Organism.class);
                ++i;
            }
            if (i < notXml.length && "aprimaryIdentifier".equals(notXml[i])) {
                ++i;
                string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.primaryIdentifier = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "aid".equals(notXml[i])) {
                this.id = Integer.valueOf(notXml[++i]);
                ++i;
            }
            if (startI != i) continue;
            throw new IllegalArgumentException("Unknown field " + notXml[i]);
        }
        this.CDSs = new ProxyCollection(os, (InterMineObject)this, "CDSs", CDS.class);
        this.genes = new ProxyCollection(os, (InterMineObject)this, "genes", Gene.class);
        this.transcripts = new ProxyCollection(os, (InterMineObject)this, "transcripts", Transcript.class);
        this.locatedFeatures = new ProxyCollection(os, (InterMineObject)this, "locatedFeatures", Location.class);
        this.locations = new ProxyCollection(os, (InterMineObject)this, "locations", Location.class);
        this.synonyms = new ProxyCollection(os, (InterMineObject)this, "synonyms", Synonym.class);
        this.dataSets = new ProxyCollection(os, (InterMineObject)this, "dataSets", DataSet.class);
        this.crossReferences = new ProxyCollection(os, (InterMineObject)this, "crossReferences", CrossReference.class);
        this.ontologyAnnotations = new ProxyCollection(os, (InterMineObject)this, "ontologyAnnotations", OntologyAnnotation.class);
        this.publications = new ProxyCollection(os, (InterMineObject)this, "publications", Publication.class);
    }

    public void addCollectionElement(String fieldName, InterMineObject element) {
        if ("CDSs".equals(fieldName)) {
            this.CDSs.add((CDS)element);
        } else if ("genes".equals(fieldName)) {
            this.genes.add((Gene)element);
        } else if ("transcripts".equals(fieldName)) {
            this.transcripts.add((Transcript)element);
        } else if ("locatedFeatures".equals(fieldName)) {
            this.locatedFeatures.add((Location)element);
        } else if ("locations".equals(fieldName)) {
            this.locations.add((Location)element);
        } else if ("synonyms".equals(fieldName)) {
            this.synonyms.add((Synonym)element);
        } else if ("dataSets".equals(fieldName)) {
            this.dataSets.add((DataSet)element);
        } else if ("crossReferences".equals(fieldName)) {
            this.crossReferences.add((CrossReference)element);
        } else if ("ontologyAnnotations".equals(fieldName)) {
            this.ontologyAnnotations.add((OntologyAnnotation)element);
        } else if ("publications".equals(fieldName)) {
            this.publications.add((Publication)element);
        } else {
            if (!Protein.class.equals(this.getClass())) {
                TypeUtil.addCollectionElement((Object)this, (String)fieldName, (Object)element);
                return;
            }
            throw new IllegalArgumentException("Unknown collection " + fieldName);
        }
    }

    public Class<?> getElementType(String fieldName) {
        if ("CDSs".equals(fieldName)) {
            return CDS.class;
        }
        if ("genes".equals(fieldName)) {
            return Gene.class;
        }
        if ("transcripts".equals(fieldName)) {
            return Transcript.class;
        }
        if ("locatedFeatures".equals(fieldName)) {
            return Location.class;
        }
        if ("locations".equals(fieldName)) {
            return Location.class;
        }
        if ("synonyms".equals(fieldName)) {
            return Synonym.class;
        }
        if ("dataSets".equals(fieldName)) {
            return DataSet.class;
        }
        if ("crossReferences".equals(fieldName)) {
            return CrossReference.class;
        }
        if ("ontologyAnnotations".equals(fieldName)) {
            return OntologyAnnotation.class;
        }
        if ("publications".equals(fieldName)) {
            return Publication.class;
        }
        if (!Protein.class.equals(this.getClass())) {
            return TypeUtil.getElementType(Protein.class, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
}

