/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.dataconversion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.intermine.bio.dataconversion.BioFileConverter;
import org.intermine.bio.util.OrganismRepository;
import org.intermine.dataconversion.ItemWriter;
import org.intermine.metadata.Model;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.xml.full.Item;
import org.intermine.xml.full.Reference;
import org.intermine.xml.full.ReferenceList;

public class IsaConverter
extends BioFileConverter {
    private static final Logger LOG = Logger.getLogger(IsaConverter.class);
    private static final OrganismRepository OR = OrganismRepository.getOrganismRepository();
    private static final String SOURCE = "source";
    private static final List<String> MATERIALS = Collections.unmodifiableList(Arrays.asList("sources", "samples"));
    private Map<String, Map> people;
    private Map<String, Map> publications;
    private Map<String, Map> comments;
    private Map<String, Item> protocols = new HashMap<String, Item>();
    private Map<String, Item> protocolParameters = new HashMap<String, Item>();
    private Map<String, List<String>> protocolParameterList = new HashMap<String, List<String>>();
    private Map<String, List<String>> protocolIn = new HashMap<String, List<String>>();
    private Map<String, List<String>> protocolOut = new HashMap<String, List<String>>();
    private Map<String, String> sdItemId = new HashMap<String, String>();
    private Set<String> taxonIds;
    private Map<String, Item> proteins = new HashMap<String, Item>();
    private Map<String, Item> factors = new HashMap<String, Item>();
    private Reference investigationReference;
    private Reference studyReference;
    private String currentFile;

    public IsaConverter(ItemWriter writer, Model model) {
        super(writer, model, "ISA", "ISA data");
    }

    public void process(Reader reader) throws Exception {
        File f = this.getCurrentFile();
        if (f != null) {
            this.currentFile = f.getName();
            LOG.info((Object)"======================================");
            LOG.info((Object)("READING " + this.currentFile));
            LOG.info((Object)"======================================");
        }
        JsonNode root = new ObjectMapper().readTree(reader);
        this.processInvestigation(root);
        JsonNode ontologyNode = root.path("ontologySourceReferences");
        this.getOntologies(ontologyNode);
        JsonNode studyNode = root.path("studies");
        for (JsonNode study : studyNode) {
            this.clearMaps();
            String identifier = study.path("identifier").asText();
            String title = study.path("title").asText();
            String description = study.path("description").asText();
            String filename = study.path("filename").asText();
            String subDate = study.path("submissionDate").asText();
            String pubDate = study.path("publicReleaseDate").asText();
            LOG.info((Object)("STUDY " + identifier));
            LOG.info((Object)(title + " -- " + filename + " | " + subDate));
            Item studyItem = this.createStudy("Study", identifier, title, description, pubDate, subDate);
            int sid = this.store(studyItem);
            if (this.investigationReference != null) {
                this.store(this.investigationReference, sid);
            }
            this.studyReference = this.getReference("study", studyItem);
            this.getDesignDescriptors(study);
            this.getProcess(study);
            this.getFactors(study, "factors");
            this.getFactors(study, "characteristicCategories");
            this.getProtocols(study);
            this.getMaterials(study);
            this.getAssays(study);
            this.storeProtocols();
        }
    }

    private void clearMaps() {
        this.protocols.clear();
        this.protocolParameters.clear();
        this.protocolParameterList.clear();
        this.protocolIn.clear();
        this.protocolOut.clear();
        this.sdItemId.clear();
        this.factors.clear();
    }

    private void processInvestigation(JsonNode investigation) throws ObjectStoreException {
        String identifier = investigation.path("identifier").asText();
        String title = investigation.path("title").asText();
        String description = investigation.path("description").asText();
        String pubDate = investigation.path("publicReleaseDate").asText();
        String subDate = investigation.path("submissionDate").asText();
        if (identifier == null || "".equals(identifier)) {
            identifier = FilenameUtils.removeExtension((String)this.currentFile);
            LOG.warn((Object)("No investigation for " + this.currentFile));
        }
        Item investigationItem = this.createStudy("Investigation", identifier, title, description, pubDate, subDate);
        this.investigationReference = this.getReference("investigation", investigationItem);
        Integer investigationOID = this.store(investigationItem);
    }

    private void getProtocols(JsonNode study) throws ObjectStoreException {
        JsonNode protocolNode = study.path("protocols");
        for (JsonNode protocol : protocolNode) {
            String id = this.blunt(protocol.path("@id").asText());
            String name = protocol.path("name").asText();
            String description = protocol.path("description").asText();
            String uri = protocol.path("uri").asText();
            String version = protocol.path("version").asText();
            this.createProtocol(id, name, description, uri, version);
            LOG.info((Object)("PROT " + name + " #pars: " + protocol.path("parameters").size()));
            JsonNode parameterNode = protocol.path("parameters");
            for (JsonNode parameter : parameterNode) {
                String pid = this.blunt(parameter.path("@id").asText());
                Term term = new Term(parameter.path("parameterName")).invoke();
                String pnid = term.getId();
                String annotationValue = term.getAnnotationValue();
                String termAccession = term.getTermAccession();
                String termSource = term.getTermSource();
                LOG.info((Object)("PPAR " + pnid + ": " + annotationValue + "|" + termAccession + "|" + termSource));
                this.createProtocolParameter(pid, annotationValue);
                IsaConverter.addToMap(this.protocolParameterList, id, pid);
            }
        }
    }

    private void getProcess(JsonNode study) throws ObjectStoreException {
        JsonNode processNode = study.path("processSequence");
        for (JsonNode process : processNode) {
            String id = this.blunt(process.path("@id").asText());
            String name = process.path("name").asText();
            String performer = process.path("performer").asText();
            String date = process.path("date").asText();
            String pid = this.blunt(process.path("executesProtocol").get("@id").textValue());
            JsonNode inputNode = process.path("inputs");
            for (JsonNode in : inputNode) {
                String inpid = this.blunt(in.path("@id").asText());
                IsaConverter.addToMap(this.protocolIn, pid, inpid);
            }
            JsonNode outputNode = process.path("outputs");
            for (JsonNode out : outputNode) {
                String outpid = this.blunt(out.path("@id").asText());
                IsaConverter.addToMap(this.protocolOut, pid, outpid);
            }
        }
        LOG.debug((Object)("SP: " + this.protocolIn.toString() + "->" + this.protocolOut.toString()));
    }

    private void getFactors(JsonNode study, String path) throws ObjectStoreException {
        JsonNode factorNode = study.path(path);
        for (JsonNode factor : factorNode) {
            String nodeType = "factors".equalsIgnoreCase(path) ? "factor" : "characteristic";
            String id = this.blunt(factor.path("@id").asText());
            Term term = new Term(factor.path(nodeType.concat("Type"))).invoke();
            String termId = term.getId();
            String annotationValue = term.getAnnotationValue();
            String termAccession = term.getTermAccession();
            String termSource = term.getTermSource();
            String name = "factor".equalsIgnoreCase(nodeType) ? factor.path("factorName").asText() : annotationValue;
            LOG.info((Object)("FACTOR " + nodeType + ": " + name + "|" + annotationValue));
            Item factorItem = this.createFactor(id, "", name, nodeType, annotationValue, "", termAccession);
            Integer oid = this.store(factorItem);
            this.store(this.studyReference, oid);
        }
    }

    private Reference getReference(String name, Item item) {
        Reference reference = new Reference();
        reference.setName(name);
        reference.setRefId(item.getIdentifier());
        return reference;
    }

    private void getDesignDescriptors(JsonNode study) throws ObjectStoreException {
        JsonNode sddNode = study.path("studyDesignDescriptors");
        for (JsonNode sdd : sddNode) {
            Term term = new Term(sdd).invoke();
            String termId = term.getId();
            String annotationValue = term.getAnnotationValue();
            String termAccession = term.getTermAccession();
            String termSource = term.getTermSource();
            LOG.info((Object)("SDD: " + annotationValue));
            Item sddItem = this.createStudyData("study", "descriptor", annotationValue, "");
            Integer sddoid = this.store(sddItem);
            this.store(this.studyReference, sddoid);
        }
    }

    private void getMaterials(JsonNode study) throws ObjectStoreException {
        for (String mat : MATERIALS) {
            JsonNode sourceNode = study.path("materials").get(mat);
            for (JsonNode source : sourceNode) {
                this.getMaterials(source, mat);
            }
        }
    }

    private void getAssays(JsonNode study) throws ObjectStoreException {
        JsonNode assayNode = study.path("assays");
        for (JsonNode assay : assayNode) {
            String fileName = assay.path("filename").asText();
            String technologyPlatform = assay.path("technologyPlatform").asText();
            LOG.info((Object)("ASSAY " + fileName + " on: " + technologyPlatform));
            String mtValue = null;
            JsonNode characteristicCategoriesNode = assay.get("characteristicCategories");
            for (JsonNode inode : characteristicCategoriesNode) {
                String characteristicCategoryId = inode.path("@id").asText();
                Term term = new Term(inode.path("characteristicType")).invoke();
                String id = term.getId();
                mtValue = term.getAnnotationValue();
                String termAccession = term.getTermAccession();
                String termSource = term.getTermSource();
                LOG.info((Object)("CHAR " + id + ": " + mtValue + "|" + termAccession + "|" + termSource));
            }
            JsonNode measurementTypeNode = assay.get("measurementType");
            Term term = new Term(measurementTypeNode).invoke();
            String id = term.getId();
            String annotationValue = term.getAnnotationValue();
            String termAccession = term.getTermAccession();
            String termSource = term.getTermSource();
            LOG.info((Object)("MT " + id + ": " + annotationValue + "|" + termAccession + "|" + termSource));
            Item sdItem = this.createStudyData("file", fileName, mtValue, annotationValue, technologyPlatform);
            Reference sdRef = this.getReference("studyData", sdItem);
            this.store(this.studyReference, this.store(sdItem));
            JsonNode dataFilesNode = assay.get("dataFiles");
            for (JsonNode inode : dataFilesNode) {
                DataFile file = new DataFile(inode).invoke();
                String fileId = file.getId();
                String name = file.getName();
                String type = file.getType();
                LOG.info((Object)("FILE " + fileId));
                Item item = this.createDataFile(type, name);
                item.addReference(sdRef);
                this.store(this.studyReference, this.store(item));
            }
        }
    }

    private void getMaterials(JsonNode source, String types) throws ObjectStoreException {
        String name = source.path("name").asText();
        String id = this.blunt(source.path("@id").asText());
        String type = types.substring(0, types.length() - 1);
        String innerLevel = type.equalsIgnoreCase(SOURCE) ? "characteristics" : "factorValues";
        this.getSampleFactors(source.path(innerLevel), name, id, type);
        Integer cSize = source.path(innerLevel).size();
        LOG.info((Object)(type.toUpperCase() + " " + id + ": " + name + " with " + cSize + " " + innerLevel));
        JsonNode characteristicNode = source.path("characteristics");
        for (JsonNode characteristic : characteristicNode) {
            String categoryId = characteristic.path("category").get("@id").asText();
            JsonNode value = characteristic.path("value");
            Term term = new Term(value).invoke();
            String charId = term.getId();
            String annotationValue = term.getAnnotationValue();
            String termAccession = term.getTermAccession();
            String termSource = term.getTermSource();
            LOG.info((Object)("CHAR " + categoryId + ": " + charId + "|" + annotationValue + "|" + termAccession + "|" + termSource));
        }
    }

    private void storeSource(String sourceName) throws ObjectStoreException {
        Item sdItem = this.createStudyData(sourceName);
        LOG.info((Object)("STORING SOURCE " + sourceName));
        Integer sdoid = this.store(sdItem);
        this.store(this.studyReference, sdoid);
    }

    private void storeSample(String sourceName) throws ObjectStoreException {
        Item sdItem = this.createStudyData(sourceName);
        Integer sdoid = this.store(sdItem);
        this.store(this.studyReference, sdoid);
    }

    private void getSampleFactors(JsonNode source, String sampleName, String id, String type) throws ObjectStoreException {
        boolean found = false;
        for (JsonNode characteristic : source) {
            String categoryId = this.blunt(characteristic.path("category").get("@id").asText());
            JsonNode value = characteristic.path("value");
            Term term = new Term(value).invoke();
            String charId = term.getId();
            String annotationValue = term.getAnnotationValue();
            String termAccession = term.getTermAccession();
            String termSource = term.getTermSource();
            Item item = this.createStudyData(type, sampleName, annotationValue, "");
            if (this.factors.get(categoryId) != null) {
                Reference factorRef = this.getReference("factor", this.factors.get(categoryId));
                item.addReference(factorRef);
            }
            this.sdItemId.put(id, item.getIdentifier());
            this.store(this.studyReference, this.store(item));
            found = true;
        }
        if (!found) {
            this.store(this.studyReference, this.store(this.createStudyData(type, sampleName, "", "")));
        }
    }

    private void getOntologies(JsonNode osr) throws ObjectStoreException {
        for (JsonNode node : osr) {
            String name = node.path("name").asText();
            String description = node.path("description").asText();
            String filename = node.path("file").asText();
            String version = node.path("version").asText();
            this.store(this.createOntology(description, filename, name, version));
            LOG.info((Object)("OSR " + name));
        }
    }

    private File getFiles() throws FileNotFoundException {
        File file = this.getCurrentFile();
        if (file == null) {
            throw new FileNotFoundException("No valid data files found.");
        }
        LOG.info((Object)"====================================================================");
        LOG.info((Object)("        ISA: Reading " + file.getName()));
        LOG.info((Object)"====================================================================");
        return file;
    }

    public void storeProtocols() throws ObjectStoreException {
        for (Map.Entry<String, Item> entry : this.protocols.entrySet()) {
            Integer protocoloid = this.store(entry.getValue());
            this.store(this.studyReference, protocoloid);
            String pid = entry.getKey();
            LOG.info((Object)("STORING " + pid + " (" + protocoloid + ")"));
            List<String> pparid = this.protocolParameterList.get(pid);
            if (pparid != null) {
                for (String ppid : pparid) {
                    LOG.info((Object)("STORE par " + ppid));
                    Reference reference = new Reference();
                    reference.setName("protocol");
                    reference.setRefId(entry.getValue().getIdentifier());
                    Integer ppoid = this.store(this.protocolParameters.get(ppid));
                    this.store(reference, ppoid);
                }
            }
            for (String thisProtId : this.protocolIn.keySet()) {
                List<String> ins = this.protocolIn.get(thisProtId);
                ReferenceList inputCollection = new ReferenceList();
                inputCollection.setName("inputs");
                for (String in : ins) {
                    inputCollection.addRefId(this.sdItemId.get(in));
                }
                this.store(inputCollection, protocoloid);
            }
            for (String thisProtId : this.protocolOut.keySet()) {
                List<String> outs = this.protocolOut.get(thisProtId);
                ReferenceList outputCollection = new ReferenceList();
                outputCollection.setName("outputs");
                for (String out : outs) {
                    if (this.sdItemId.get(out) == null) continue;
                    outputCollection.addRefId(this.sdItemId.get(out));
                }
                this.store(outputCollection, protocoloid);
            }
        }
    }

    private Item createStudy(String type, String id, String title, String description, String subDate, String pubDate) throws ObjectStoreException {
        Item item = this.createItem(type);
        if (id == null || "".equals(id)) {
            id = "untitled";
        }
        item.setAttribute("identifier", id);
        if (!title.isEmpty()) {
            item.setAttribute("title", title);
        }
        if (!description.isEmpty()) {
            item.setAttribute("description", description);
        }
        if (!subDate.isEmpty()) {
            this.setDate(subDate, item);
        }
        if (!pubDate.isEmpty()) {
            this.setDate(pubDate, item);
        }
        return item;
    }

    private void setDate(String date, Item item) {
        if (date.contains("/")) {
            item.setAttribute("submissionDate", this.reformDate(date));
        } else {
            item.setAttribute("submissionDate", date);
        }
    }

    private String reformDate(String subDate) {
        SimpleDateFormat readFormat = new SimpleDateFormat("dd/mm/yyyy");
        SimpleDateFormat writeFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = readFormat.parse(subDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String formattedDate = "";
        if (date != null) {
            formattedDate = writeFormat.format(date);
        }
        return formattedDate;
    }

    private Item createFactor(String fid, String cid, String name, String type, String value, String unit, String accession) throws ObjectStoreException {
        Item item = this.factors.get(fid);
        if (item == null) {
            item = this.createItem("Factor");
            item.setAttribute("name", name);
            if (!type.isEmpty()) {
                item.setAttribute("type", type);
            }
            if (!value.isEmpty()) {
                item.setAttribute("value", value);
            }
            if (!unit.isEmpty()) {
                item.setAttribute("unit", unit);
            }
            if (!accession.isEmpty()) {
                item.setAttribute("accession", accession);
            }
            this.factors.put(fid, item);
        }
        return item;
    }

    private Item createDataFile(String type, String name) throws ObjectStoreException {
        Item item = this.createItem("DataFile");
        item.setAttribute("type", type);
        if (!name.isEmpty()) {
            item.setAttribute("name", name);
        }
        return item;
    }

    private Item createStudyData(String type, String name, String value, String unit) throws ObjectStoreException {
        Item item = this.createItem("StudyData");
        item.setAttribute("name", name);
        if (!value.isEmpty()) {
            item.setAttribute("value", value);
        }
        if (!unit.isEmpty()) {
            item.setAttribute("unit", unit);
        }
        if (!type.isEmpty()) {
            item.setAttribute("type", type);
        }
        return item;
    }

    private Item createStudyData(String type, String name, String value, String measurement, String technology) throws ObjectStoreException {
        Item item = this.createItem("StudyData");
        item.setAttribute("name", name);
        item.setAttributeIfNotNull("type", type);
        item.setAttributeIfNotNull("value", value);
        item.setAttributeIfNotNull("measurement", measurement);
        item.setAttributeIfNotNull("technology", technology);
        return item;
    }

    private Item createStudyData(String source) throws ObjectStoreException {
        Item item = this.createItem("StudyData");
        item.setAttribute(SOURCE, source);
        return item;
    }

    private Item createOntology(String name, String url, String shortName, String version) throws ObjectStoreException {
        Item item = this.createItem("Ontology");
        item.setAttribute("name", name);
        if (!url.isEmpty()) {
            item.setAttribute("url", url);
        }
        item.setAttribute("shortName", shortName);
        item.setAttribute("version", version);
        return item;
    }

    private Item createProtocol(String id, String name, String description, String uri, String version) throws ObjectStoreException {
        Item item = this.protocols.get(id);
        if (item == null) {
            item = this.createItem("Protocol");
            item.setAttribute("name", name);
            if (!description.isEmpty()) {
                item.setAttribute("description", description);
            }
            if (!uri.isEmpty()) {
                item.setAttribute("URI", uri);
            }
            if (!version.isEmpty()) {
                item.setAttribute("version", version);
            }
            this.protocols.put(id, item);
        }
        return item;
    }

    private Item createProtocolParameter(String id, String name) throws ObjectStoreException {
        Item item = this.protocolParameters.get(id);
        if (item == null) {
            item = this.createItem("ProtocolParameter");
            if (!name.isEmpty()) {
                item.setAttribute("name", name);
            }
            this.protocolParameters.put(id, item);
        }
        return item;
    }

    private void getTerm(JsonNode source) {
        Term term = new Term(source).invoke();
        String annotationValue = term.getAnnotationValue();
        String termAccession = term.getTermAccession();
        String termSource = term.getTermSource();
        LOG.info((Object)("CHAR: " + annotationValue + "|" + termAccession + "|" + termSource));
    }

    private static void addToMap(Map<String, List<String>> m, String key, String value) {
        List<Object> ids = new ArrayList();
        if (m.containsKey(key)) {
            ids = m.get(key);
        }
        if (!ids.contains(value)) {
            ids.add(value);
            m.put(key, ids);
        }
    }

    private String blunt(String in) {
        return in.replaceAll("#", "");
    }

    private class DataFile {
        private JsonNode node;
        private String id;
        private String name;
        private String type;

        public DataFile(JsonNode node) {
            this.node = node;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public DataFile invoke() {
            this.id = this.node.path("@id").asText();
            this.name = this.node.path("name").asText();
            this.type = this.node.path("type").asText();
            return this;
        }
    }

    private class Term {
        private JsonNode node;
        private String id;
        private String annotationValue;
        private String termAccession;
        private String termSource;

        public Term(JsonNode node) {
            this.node = node;
        }

        public String getId() {
            return this.id;
        }

        public String getAnnotationValue() {
            return this.annotationValue;
        }

        public String getTermAccession() {
            return this.termAccession;
        }

        public String getTermSource() {
            return this.termSource;
        }

        public Term invoke() {
            this.id = this.node.path("@id").asText();
            this.annotationValue = this.node.path("annotationValue").asText();
            this.termAccession = this.node.path("termAccession").asText();
            this.termSource = this.node.path("termSource").asText();
            return this;
        }
    }
}

