package org.intermine.model.bio;

import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.intermine.NotXmlParser;
import org.intermine.objectstore.intermine.NotXmlRenderer;
import org.intermine.objectstore.proxy.ProxyCollection;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.model.StringConstructor;
import org.intermine.metadata.TypeUtil;
import org.intermine.util.DynamicUtil;
import org.intermine.model.ShadowClass;

public class StudyShadow implements Study, ShadowClass
{
    public static final Class<Study> shadowOf = Study.class;
    // Attr: org.intermine.model.bio.Study.identifier
    protected java.lang.String identifier;
    public java.lang.String getIdentifier() { return identifier; }
    public void setIdentifier(final java.lang.String identifier) { this.identifier = identifier; }

    // Attr: org.intermine.model.bio.Study.description
    protected java.lang.String description;
    public java.lang.String getDescription() { return description; }
    public void setDescription(final java.lang.String description) { this.description = description; }

    // Attr: org.intermine.model.bio.Study.title
    protected java.lang.String title;
    public java.lang.String getTitle() { return title; }
    public void setTitle(final java.lang.String title) { this.title = title; }

    // Attr: org.intermine.model.bio.Study.publicReleaseDate
    protected java.util.Date publicReleaseDate;
    public java.util.Date getPublicReleaseDate() { return publicReleaseDate; }
    public void setPublicReleaseDate(final java.util.Date publicReleaseDate) { this.publicReleaseDate = publicReleaseDate; }

    // Attr: org.intermine.model.bio.Study.submissionDate
    protected java.util.Date submissionDate;
    public java.util.Date getSubmissionDate() { return submissionDate; }
    public void setSubmissionDate(final java.util.Date submissionDate) { this.submissionDate = submissionDate; }

    // Attr: org.intermine.model.bio.Study.design
    protected java.lang.String design;
    public java.lang.String getDesign() { return design; }
    public void setDesign(final java.lang.String design) { this.design = design; }

    // Ref: org.intermine.model.bio.Study.publication
    protected org.intermine.model.InterMineObject publication;
    public org.intermine.model.bio.Publication getPublication() { if (publication instanceof org.intermine.objectstore.proxy.ProxyReference) { return ((org.intermine.model.bio.Publication) ((org.intermine.objectstore.proxy.ProxyReference) publication).getObject()); }; return (org.intermine.model.bio.Publication) publication; }
    public void setPublication(final org.intermine.model.bio.Publication publication) { this.publication = publication; }
    public void proxyPublication(final org.intermine.objectstore.proxy.ProxyReference publication) { this.publication = publication; }
    public org.intermine.model.InterMineObject proxGetPublication() { return publication; }

    // Ref: org.intermine.model.bio.Study.investigation
    protected org.intermine.model.InterMineObject investigation;
    public org.intermine.model.bio.Investigation getInvestigation() { if (investigation instanceof org.intermine.objectstore.proxy.ProxyReference) { return ((org.intermine.model.bio.Investigation) ((org.intermine.objectstore.proxy.ProxyReference) investigation).getObject()); }; return (org.intermine.model.bio.Investigation) investigation; }
    public void setInvestigation(final org.intermine.model.bio.Investigation investigation) { this.investigation = investigation; }
    public void proxyInvestigation(final org.intermine.objectstore.proxy.ProxyReference investigation) { this.investigation = investigation; }
    public org.intermine.model.InterMineObject proxGetInvestigation() { return investigation; }

    // Ref: org.intermine.model.bio.Study.organism
    protected org.intermine.model.InterMineObject organism;
    public org.intermine.model.bio.Organism getOrganism() { if (organism instanceof org.intermine.objectstore.proxy.ProxyReference) { return ((org.intermine.model.bio.Organism) ((org.intermine.objectstore.proxy.ProxyReference) organism).getObject()); }; return (org.intermine.model.bio.Organism) organism; }
    public void setOrganism(final org.intermine.model.bio.Organism organism) { this.organism = organism; }
    public void proxyOrganism(final org.intermine.objectstore.proxy.ProxyReference organism) { this.organism = organism; }
    public org.intermine.model.InterMineObject proxGetOrganism() { return organism; }

    // Col: org.intermine.model.bio.Study.contacts
    protected java.util.Set<org.intermine.model.bio.Author> contacts = new java.util.HashSet<org.intermine.model.bio.Author>();
    public java.util.Set<org.intermine.model.bio.Author> getContacts() { return contacts; }
    public void setContacts(final java.util.Set<org.intermine.model.bio.Author> contacts) { this.contacts = contacts; }
    public void addContacts(final org.intermine.model.bio.Author arg) { contacts.add(arg); }

    // Col: org.intermine.model.bio.Study.factors
    protected java.util.Set<org.intermine.model.bio.Factor> factors = new java.util.HashSet<org.intermine.model.bio.Factor>();
    public java.util.Set<org.intermine.model.bio.Factor> getFactors() { return factors; }
    public void setFactors(final java.util.Set<org.intermine.model.bio.Factor> factors) { this.factors = factors; }
    public void addFactors(final org.intermine.model.bio.Factor arg) { factors.add(arg); }

    // Col: org.intermine.model.bio.Study.protocols
    protected java.util.Set<org.intermine.model.bio.Protocol> protocols = new java.util.HashSet<org.intermine.model.bio.Protocol>();
    public java.util.Set<org.intermine.model.bio.Protocol> getProtocols() { return protocols; }
    public void setProtocols(final java.util.Set<org.intermine.model.bio.Protocol> protocols) { this.protocols = protocols; }
    public void addProtocols(final org.intermine.model.bio.Protocol arg) { protocols.add(arg); }

    // Col: org.intermine.model.bio.Study.studyData
    protected java.util.Set<org.intermine.model.bio.StudyData> studyData = new java.util.HashSet<org.intermine.model.bio.StudyData>();
    public java.util.Set<org.intermine.model.bio.StudyData> getStudyData() { return studyData; }
    public void setStudyData(final java.util.Set<org.intermine.model.bio.StudyData> studyData) { this.studyData = studyData; }
    public void addStudyData(final org.intermine.model.bio.StudyData arg) { studyData.add(arg); }

    // Attr: org.intermine.model.InterMineObject.id
    protected java.lang.Integer id;
    public java.lang.Integer getId() { return id; }
    public void setId(final java.lang.Integer id) { this.id = id; }

    @Override public boolean equals(Object o) { return (o instanceof Study && id != null) ? id.equals(((Study)o).getId()) : this == o; }
    @Override public int hashCode() { return (id != null) ? id.hashCode() : super.hashCode(); }
    @Override public String toString() { return "Study [description=" + (description == null ? "null" : "\"" + description + "\"") + ", design=" + (design == null ? "null" : "\"" + design + "\"") + ", id=" + id + ", identifier=" + (identifier == null ? "null" : "\"" + identifier + "\"") + ", investigation=" + (investigation == null ? "null" : (investigation.getId() == null ? "no id" : investigation.getId().toString())) + ", organism=" + (organism == null ? "null" : (organism.getId() == null ? "no id" : organism.getId().toString())) + ", publicReleaseDate=" + (publicReleaseDate == null ? "null" : "\"" + publicReleaseDate + "\"") + ", publication=" + (publication == null ? "null" : (publication.getId() == null ? "no id" : publication.getId().toString())) + ", submissionDate=" + (submissionDate == null ? "null" : "\"" + submissionDate + "\"") + ", title=" + (title == null ? "null" : "\"" + title + "\"") + "]"; }
    public Object getFieldValue(final String fieldName) throws IllegalAccessException {
        if ("identifier".equals(fieldName)) {
            return identifier;
        }
        if ("description".equals(fieldName)) {
            return description;
        }
        if ("title".equals(fieldName)) {
            return title;
        }
        if ("publicReleaseDate".equals(fieldName)) {
            return publicReleaseDate;
        }
        if ("submissionDate".equals(fieldName)) {
            return submissionDate;
        }
        if ("design".equals(fieldName)) {
            return design;
        }
        if ("publication".equals(fieldName)) {
            if (publication instanceof ProxyReference) {
                return ((ProxyReference) publication).getObject();
            } else {
                return publication;
            }
        }
        if ("investigation".equals(fieldName)) {
            if (investigation instanceof ProxyReference) {
                return ((ProxyReference) investigation).getObject();
            } else {
                return investigation;
            }
        }
        if ("organism".equals(fieldName)) {
            if (organism instanceof ProxyReference) {
                return ((ProxyReference) organism).getObject();
            } else {
                return organism;
            }
        }
        if ("contacts".equals(fieldName)) {
            return contacts;
        }
        if ("factors".equals(fieldName)) {
            return factors;
        }
        if ("protocols".equals(fieldName)) {
            return protocols;
        }
        if ("studyData".equals(fieldName)) {
            return studyData;
        }
        if ("id".equals(fieldName)) {
            return id;
        }
        if (!org.intermine.model.bio.Study.class.equals(getClass())) {
            return TypeUtil.getFieldValue(this, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
    public Object getFieldProxy(final String fieldName) throws IllegalAccessException {
        if ("identifier".equals(fieldName)) {
            return identifier;
        }
        if ("description".equals(fieldName)) {
            return description;
        }
        if ("title".equals(fieldName)) {
            return title;
        }
        if ("publicReleaseDate".equals(fieldName)) {
            return publicReleaseDate;
        }
        if ("submissionDate".equals(fieldName)) {
            return submissionDate;
        }
        if ("design".equals(fieldName)) {
            return design;
        }
        if ("publication".equals(fieldName)) {
            return publication;
        }
        if ("investigation".equals(fieldName)) {
            return investigation;
        }
        if ("organism".equals(fieldName)) {
            return organism;
        }
        if ("contacts".equals(fieldName)) {
            return contacts;
        }
        if ("factors".equals(fieldName)) {
            return factors;
        }
        if ("protocols".equals(fieldName)) {
            return protocols;
        }
        if ("studyData".equals(fieldName)) {
            return studyData;
        }
        if ("id".equals(fieldName)) {
            return id;
        }
        if (!org.intermine.model.bio.Study.class.equals(getClass())) {
            return TypeUtil.getFieldProxy(this, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
    public void setFieldValue(final String fieldName, final Object value) {
        if ("identifier".equals(fieldName)) {
            identifier = (java.lang.String) value;
        } else if ("description".equals(fieldName)) {
            description = (java.lang.String) value;
        } else if ("title".equals(fieldName)) {
            title = (java.lang.String) value;
        } else if ("publicReleaseDate".equals(fieldName)) {
            publicReleaseDate = (java.util.Date) value;
        } else if ("submissionDate".equals(fieldName)) {
            submissionDate = (java.util.Date) value;
        } else if ("design".equals(fieldName)) {
            design = (java.lang.String) value;
        } else if ("publication".equals(fieldName)) {
            publication = (org.intermine.model.InterMineObject) value;
        } else if ("investigation".equals(fieldName)) {
            investigation = (org.intermine.model.InterMineObject) value;
        } else if ("organism".equals(fieldName)) {
            organism = (org.intermine.model.InterMineObject) value;
        } else if ("contacts".equals(fieldName)) {
            contacts = (java.util.Set) value;
        } else if ("factors".equals(fieldName)) {
            factors = (java.util.Set) value;
        } else if ("protocols".equals(fieldName)) {
            protocols = (java.util.Set) value;
        } else if ("studyData".equals(fieldName)) {
            studyData = (java.util.Set) value;
        } else if ("id".equals(fieldName)) {
            id = (java.lang.Integer) value;
        } else {
            if (!org.intermine.model.bio.Study.class.equals(getClass())) {
                DynamicUtil.setFieldValue(this, fieldName, value);
                return;
            }
            throw new IllegalArgumentException("Unknown field " + fieldName);
        }
    }
    public Class<?> getFieldType(final String fieldName) {
        if ("identifier".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("description".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("title".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("publicReleaseDate".equals(fieldName)) {
            return java.util.Date.class;
        }
        if ("submissionDate".equals(fieldName)) {
            return java.util.Date.class;
        }
        if ("design".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("publication".equals(fieldName)) {
            return org.intermine.model.bio.Publication.class;
        }
        if ("investigation".equals(fieldName)) {
            return org.intermine.model.bio.Investigation.class;
        }
        if ("organism".equals(fieldName)) {
            return org.intermine.model.bio.Organism.class;
        }
        if ("contacts".equals(fieldName)) {
            return java.util.Set.class;
        }
        if ("factors".equals(fieldName)) {
            return java.util.Set.class;
        }
        if ("protocols".equals(fieldName)) {
            return java.util.Set.class;
        }
        if ("studyData".equals(fieldName)) {
            return java.util.Set.class;
        }
        if ("id".equals(fieldName)) {
            return java.lang.Integer.class;
        }
        if (!org.intermine.model.bio.Study.class.equals(getClass())) {
            return TypeUtil.getFieldType(org.intermine.model.bio.Study.class, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
    public StringConstructor getoBJECT() {
        if (!org.intermine.model.bio.StudyShadow.class.equals(getClass())) {
            return NotXmlRenderer.render(this);
        }
        StringConstructor sb = new StringConstructor();
        sb.append("$_^org.intermine.model.bio.Study");
        if (identifier != null) {
            sb.append("$_^aidentifier$_^");
            String string = identifier;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (description != null) {
            sb.append("$_^adescription$_^");
            String string = description;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (title != null) {
            sb.append("$_^atitle$_^");
            String string = title;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (publicReleaseDate != null) {
            sb.append("$_^apublicReleaseDate$_^").append(publicReleaseDate.getTime());
        }
        if (submissionDate != null) {
            sb.append("$_^asubmissionDate$_^").append(submissionDate.getTime());
        }
        if (design != null) {
            sb.append("$_^adesign$_^");
            String string = design;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (publication != null) {
            sb.append("$_^rpublication$_^").append(publication.getId());
        }
        if (investigation != null) {
            sb.append("$_^rinvestigation$_^").append(investigation.getId());
        }
        if (organism != null) {
            sb.append("$_^rorganism$_^").append(organism.getId());
        }
        if (id != null) {
            sb.append("$_^aid$_^").append(id);
        }
        return sb;
    }
    public void setoBJECT(String notXml, ObjectStore os) {
        setoBJECT(NotXmlParser.SPLITTER.split(notXml), os);
    }
    public void setoBJECT(final String[] notXml, final ObjectStore os) {
        if (!org.intermine.model.bio.StudyShadow.class.equals(getClass())) {
            throw new IllegalStateException("Class " + getClass().getName() + " does not match code (org.intermine.model.bio.Study)");
        }
        for (int i = 2; i < notXml.length;) {
            int startI = i;
            if ((i < notXml.length) && "aidentifier".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                identifier = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "adescription".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                description = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "atitle".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                title = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "apublicReleaseDate".equals(notXml[i])) {
                i++;
                publicReleaseDate = new java.util.Date(Long.parseLong(notXml[i]));
                i++;
            }
            if ((i < notXml.length) && "asubmissionDate".equals(notXml[i])) {
                i++;
                submissionDate = new java.util.Date(Long.parseLong(notXml[i]));
                i++;
            }
            if ((i < notXml.length) && "adesign".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                design = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) &&"rpublication".equals(notXml[i])) {
                i++;
                publication = new ProxyReference(os, Integer.valueOf(notXml[i]), org.intermine.model.bio.Publication.class);
                i++;
            };
            if ((i < notXml.length) &&"rinvestigation".equals(notXml[i])) {
                i++;
                investigation = new ProxyReference(os, Integer.valueOf(notXml[i]), org.intermine.model.bio.Investigation.class);
                i++;
            };
            if ((i < notXml.length) &&"rorganism".equals(notXml[i])) {
                i++;
                organism = new ProxyReference(os, Integer.valueOf(notXml[i]), org.intermine.model.bio.Organism.class);
                i++;
            };
            if ((i < notXml.length) && "aid".equals(notXml[i])) {
                i++;
                id = Integer.valueOf(notXml[i]);
                i++;
            }
            if (startI == i) {
                throw new IllegalArgumentException("Unknown field " + notXml[i]);
            }
        }
        contacts = new ProxyCollection<org.intermine.model.bio.Author>(os, this, "contacts", org.intermine.model.bio.Author.class);
        factors = new ProxyCollection<org.intermine.model.bio.Factor>(os, this, "factors", org.intermine.model.bio.Factor.class);
        protocols = new ProxyCollection<org.intermine.model.bio.Protocol>(os, this, "protocols", org.intermine.model.bio.Protocol.class);
        studyData = new ProxyCollection<org.intermine.model.bio.StudyData>(os, this, "studyData", org.intermine.model.bio.StudyData.class);
    }
    public void addCollectionElement(final String fieldName, final org.intermine.model.InterMineObject element) {
        if ("contacts".equals(fieldName)) {
            contacts.add((org.intermine.model.bio.Author) element);
        } else if ("factors".equals(fieldName)) {
            factors.add((org.intermine.model.bio.Factor) element);
        } else if ("protocols".equals(fieldName)) {
            protocols.add((org.intermine.model.bio.Protocol) element);
        } else if ("studyData".equals(fieldName)) {
            studyData.add((org.intermine.model.bio.StudyData) element);
        } else {
            if (!org.intermine.model.bio.Study.class.equals(getClass())) {
                TypeUtil.addCollectionElement(this, fieldName, element);
                return;
            }
            throw new IllegalArgumentException("Unknown collection " + fieldName);
        }
    }
    public Class<?> getElementType(final String fieldName) {
        if ("contacts".equals(fieldName)) {
            return org.intermine.model.bio.Author.class;
        }
        if ("factors".equals(fieldName)) {
            return org.intermine.model.bio.Factor.class;
        }
        if ("protocols".equals(fieldName)) {
            return org.intermine.model.bio.Protocol.class;
        }
        if ("studyData".equals(fieldName)) {
            return org.intermine.model.bio.StudyData.class;
        }
        if (!org.intermine.model.bio.Study.class.equals(getClass())) {
            return TypeUtil.getElementType(org.intermine.model.bio.Study.class, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
}
