package org.intermine.model.bio;

import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.intermine.NotXmlParser;
import org.intermine.objectstore.intermine.NotXmlRenderer;
import org.intermine.objectstore.proxy.ProxyCollection;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.model.StringConstructor;
import org.intermine.metadata.TypeUtil;
import org.intermine.util.DynamicUtil;
import org.intermine.model.ShadowClass;

public class StudyDataShadow implements StudyData, ShadowClass
{
    public static final Class<StudyData> shadowOf = StudyData.class;
    // Attr: org.intermine.model.bio.StudyData.source
    protected java.lang.String source;
    public java.lang.String getSource() { return source; }
    public void setSource(final java.lang.String source) { this.source = source; }

    // Attr: org.intermine.model.bio.StudyData.type
    protected java.lang.String type;
    public java.lang.String getType() { return type; }
    public void setType(final java.lang.String type) { this.type = type; }

    // Attr: org.intermine.model.bio.StudyData.name
    protected java.lang.String name;
    public java.lang.String getName() { return name; }
    public void setName(final java.lang.String name) { this.name = name; }

    // Attr: org.intermine.model.bio.StudyData.measurement
    protected java.lang.String measurement;
    public java.lang.String getMeasurement() { return measurement; }
    public void setMeasurement(final java.lang.String measurement) { this.measurement = measurement; }

    // Attr: org.intermine.model.bio.StudyData.technology
    protected java.lang.String technology;
    public java.lang.String getTechnology() { return technology; }
    public void setTechnology(final java.lang.String technology) { this.technology = technology; }

    // Attr: org.intermine.model.bio.StudyData.value
    protected java.lang.String value;
    public java.lang.String getValue() { return value; }
    public void setValue(final java.lang.String value) { this.value = value; }

    // Ref: org.intermine.model.bio.StudyData.factor
    protected org.intermine.model.InterMineObject factor;
    public org.intermine.model.bio.Factor getFactor() { if (factor instanceof org.intermine.objectstore.proxy.ProxyReference) { return ((org.intermine.model.bio.Factor) ((org.intermine.objectstore.proxy.ProxyReference) factor).getObject()); }; return (org.intermine.model.bio.Factor) factor; }
    public void setFactor(final org.intermine.model.bio.Factor factor) { this.factor = factor; }
    public void proxyFactor(final org.intermine.objectstore.proxy.ProxyReference factor) { this.factor = factor; }
    public org.intermine.model.InterMineObject proxGetFactor() { return factor; }

    // Ref: org.intermine.model.bio.StudyData.study
    protected org.intermine.model.InterMineObject study;
    public org.intermine.model.bio.Study getStudy() { if (study instanceof org.intermine.objectstore.proxy.ProxyReference) { return ((org.intermine.model.bio.Study) ((org.intermine.objectstore.proxy.ProxyReference) study).getObject()); }; return (org.intermine.model.bio.Study) study; }
    public void setStudy(final org.intermine.model.bio.Study study) { this.study = study; }
    public void proxyStudy(final org.intermine.objectstore.proxy.ProxyReference study) { this.study = study; }
    public org.intermine.model.InterMineObject proxGetStudy() { return study; }

    // Col: org.intermine.model.bio.StudyData.protocols
    protected java.util.Set<org.intermine.model.bio.Protocol> protocols = new java.util.HashSet<org.intermine.model.bio.Protocol>();
    public java.util.Set<org.intermine.model.bio.Protocol> getProtocols() { return protocols; }
    public void setProtocols(final java.util.Set<org.intermine.model.bio.Protocol> protocols) { this.protocols = protocols; }
    public void addProtocols(final org.intermine.model.bio.Protocol arg) { protocols.add(arg); }

    // Col: org.intermine.model.bio.StudyData.attributes
    protected java.util.Set<org.intermine.model.bio.StudyDataAttribute> attributes = new java.util.HashSet<org.intermine.model.bio.StudyDataAttribute>();
    public java.util.Set<org.intermine.model.bio.StudyDataAttribute> getAttributes() { return attributes; }
    public void setAttributes(final java.util.Set<org.intermine.model.bio.StudyDataAttribute> attributes) { this.attributes = attributes; }
    public void addAttributes(final org.intermine.model.bio.StudyDataAttribute arg) { attributes.add(arg); }

    // Col: org.intermine.model.bio.StudyData.files
    protected java.util.Set<org.intermine.model.bio.DataFile> files = new java.util.HashSet<org.intermine.model.bio.DataFile>();
    public java.util.Set<org.intermine.model.bio.DataFile> getFiles() { return files; }
    public void setFiles(final java.util.Set<org.intermine.model.bio.DataFile> files) { this.files = files; }
    public void addFiles(final org.intermine.model.bio.DataFile arg) { files.add(arg); }

    // Attr: org.intermine.model.InterMineObject.id
    protected java.lang.Integer id;
    public java.lang.Integer getId() { return id; }
    public void setId(final java.lang.Integer id) { this.id = id; }

    @Override public boolean equals(Object o) { return (o instanceof StudyData && id != null) ? id.equals(((StudyData)o).getId()) : this == o; }
    @Override public int hashCode() { return (id != null) ? id.hashCode() : super.hashCode(); }
    @Override public String toString() { return "StudyData [factor=" + (factor == null ? "null" : (factor.getId() == null ? "no id" : factor.getId().toString())) + ", id=" + id + ", measurement=" + (measurement == null ? "null" : "\"" + measurement + "\"") + ", name=" + (name == null ? "null" : "\"" + name + "\"") + ", source=" + (source == null ? "null" : "\"" + source + "\"") + ", study=" + (study == null ? "null" : (study.getId() == null ? "no id" : study.getId().toString())) + ", technology=" + (technology == null ? "null" : "\"" + technology + "\"") + ", type=" + (type == null ? "null" : "\"" + type + "\"") + ", value=" + (value == null ? "null" : "\"" + value + "\"") + "]"; }
    public Object getFieldValue(final String fieldName) throws IllegalAccessException {
        if ("source".equals(fieldName)) {
            return source;
        }
        if ("type".equals(fieldName)) {
            return type;
        }
        if ("name".equals(fieldName)) {
            return name;
        }
        if ("measurement".equals(fieldName)) {
            return measurement;
        }
        if ("technology".equals(fieldName)) {
            return technology;
        }
        if ("value".equals(fieldName)) {
            return value;
        }
        if ("factor".equals(fieldName)) {
            if (factor instanceof ProxyReference) {
                return ((ProxyReference) factor).getObject();
            } else {
                return factor;
            }
        }
        if ("study".equals(fieldName)) {
            if (study instanceof ProxyReference) {
                return ((ProxyReference) study).getObject();
            } else {
                return study;
            }
        }
        if ("protocols".equals(fieldName)) {
            return protocols;
        }
        if ("attributes".equals(fieldName)) {
            return attributes;
        }
        if ("files".equals(fieldName)) {
            return files;
        }
        if ("id".equals(fieldName)) {
            return id;
        }
        if (!org.intermine.model.bio.StudyData.class.equals(getClass())) {
            return TypeUtil.getFieldValue(this, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
    public Object getFieldProxy(final String fieldName) throws IllegalAccessException {
        if ("source".equals(fieldName)) {
            return source;
        }
        if ("type".equals(fieldName)) {
            return type;
        }
        if ("name".equals(fieldName)) {
            return name;
        }
        if ("measurement".equals(fieldName)) {
            return measurement;
        }
        if ("technology".equals(fieldName)) {
            return technology;
        }
        if ("value".equals(fieldName)) {
            return value;
        }
        if ("factor".equals(fieldName)) {
            return factor;
        }
        if ("study".equals(fieldName)) {
            return study;
        }
        if ("protocols".equals(fieldName)) {
            return protocols;
        }
        if ("attributes".equals(fieldName)) {
            return attributes;
        }
        if ("files".equals(fieldName)) {
            return files;
        }
        if ("id".equals(fieldName)) {
            return id;
        }
        if (!org.intermine.model.bio.StudyData.class.equals(getClass())) {
            return TypeUtil.getFieldProxy(this, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
    public void setFieldValue(final String fieldName, final Object value) {
        if ("source".equals(fieldName)) {
            source = (java.lang.String) value;
        } else if ("type".equals(fieldName)) {
            type = (java.lang.String) value;
        } else if ("name".equals(fieldName)) {
            name = (java.lang.String) value;
        } else if ("measurement".equals(fieldName)) {
            measurement = (java.lang.String) value;
        } else if ("technology".equals(fieldName)) {
            technology = (java.lang.String) value;
        } else if ("value".equals(fieldName)) {
            this.value = (java.lang.String) value;
        } else if ("factor".equals(fieldName)) {
            factor = (org.intermine.model.InterMineObject) value;
        } else if ("study".equals(fieldName)) {
            study = (org.intermine.model.InterMineObject) value;
        } else if ("protocols".equals(fieldName)) {
            protocols = (java.util.Set) value;
        } else if ("attributes".equals(fieldName)) {
            attributes = (java.util.Set) value;
        } else if ("files".equals(fieldName)) {
            files = (java.util.Set) value;
        } else if ("id".equals(fieldName)) {
            id = (java.lang.Integer) value;
        } else {
            if (!org.intermine.model.bio.StudyData.class.equals(getClass())) {
                DynamicUtil.setFieldValue(this, fieldName, value);
                return;
            }
            throw new IllegalArgumentException("Unknown field " + fieldName);
        }
    }
    public Class<?> getFieldType(final String fieldName) {
        if ("source".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("type".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("name".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("measurement".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("technology".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("value".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("factor".equals(fieldName)) {
            return org.intermine.model.bio.Factor.class;
        }
        if ("study".equals(fieldName)) {
            return org.intermine.model.bio.Study.class;
        }
        if ("protocols".equals(fieldName)) {
            return java.util.Set.class;
        }
        if ("attributes".equals(fieldName)) {
            return java.util.Set.class;
        }
        if ("files".equals(fieldName)) {
            return java.util.Set.class;
        }
        if ("id".equals(fieldName)) {
            return java.lang.Integer.class;
        }
        if (!org.intermine.model.bio.StudyData.class.equals(getClass())) {
            return TypeUtil.getFieldType(org.intermine.model.bio.StudyData.class, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
    public StringConstructor getoBJECT() {
        if (!org.intermine.model.bio.StudyDataShadow.class.equals(getClass())) {
            return NotXmlRenderer.render(this);
        }
        StringConstructor sb = new StringConstructor();
        sb.append("$_^org.intermine.model.bio.StudyData");
        if (source != null) {
            sb.append("$_^asource$_^");
            String string = source;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (type != null) {
            sb.append("$_^atype$_^");
            String string = type;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (name != null) {
            sb.append("$_^aname$_^");
            String string = name;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (measurement != null) {
            sb.append("$_^ameasurement$_^");
            String string = measurement;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (technology != null) {
            sb.append("$_^atechnology$_^");
            String string = technology;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (value != null) {
            sb.append("$_^avalue$_^");
            String string = value;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (factor != null) {
            sb.append("$_^rfactor$_^").append(factor.getId());
        }
        if (study != null) {
            sb.append("$_^rstudy$_^").append(study.getId());
        }
        if (id != null) {
            sb.append("$_^aid$_^").append(id);
        }
        return sb;
    }
    public void setoBJECT(String notXml, ObjectStore os) {
        setoBJECT(NotXmlParser.SPLITTER.split(notXml), os);
    }
    public void setoBJECT(final String[] notXml, final ObjectStore os) {
        if (!org.intermine.model.bio.StudyDataShadow.class.equals(getClass())) {
            throw new IllegalStateException("Class " + getClass().getName() + " does not match code (org.intermine.model.bio.StudyData)");
        }
        for (int i = 2; i < notXml.length;) {
            int startI = i;
            if ((i < notXml.length) && "asource".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                source = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "atype".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                type = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "aname".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                name = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "ameasurement".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                measurement = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "atechnology".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                technology = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "avalue".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                value = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) &&"rfactor".equals(notXml[i])) {
                i++;
                factor = new ProxyReference(os, Integer.valueOf(notXml[i]), org.intermine.model.bio.Factor.class);
                i++;
            };
            if ((i < notXml.length) &&"rstudy".equals(notXml[i])) {
                i++;
                study = new ProxyReference(os, Integer.valueOf(notXml[i]), org.intermine.model.bio.Study.class);
                i++;
            };
            if ((i < notXml.length) && "aid".equals(notXml[i])) {
                i++;
                id = Integer.valueOf(notXml[i]);
                i++;
            }
            if (startI == i) {
                throw new IllegalArgumentException("Unknown field " + notXml[i]);
            }
        }
        protocols = new ProxyCollection<org.intermine.model.bio.Protocol>(os, this, "protocols", org.intermine.model.bio.Protocol.class);
        attributes = new ProxyCollection<org.intermine.model.bio.StudyDataAttribute>(os, this, "attributes", org.intermine.model.bio.StudyDataAttribute.class);
        files = new ProxyCollection<org.intermine.model.bio.DataFile>(os, this, "files", org.intermine.model.bio.DataFile.class);
    }
    public void addCollectionElement(final String fieldName, final org.intermine.model.InterMineObject element) {
        if ("protocols".equals(fieldName)) {
            protocols.add((org.intermine.model.bio.Protocol) element);
        } else if ("attributes".equals(fieldName)) {
            attributes.add((org.intermine.model.bio.StudyDataAttribute) element);
        } else if ("files".equals(fieldName)) {
            files.add((org.intermine.model.bio.DataFile) element);
        } else {
            if (!org.intermine.model.bio.StudyData.class.equals(getClass())) {
                TypeUtil.addCollectionElement(this, fieldName, element);
                return;
            }
            throw new IllegalArgumentException("Unknown collection " + fieldName);
        }
    }
    public Class<?> getElementType(final String fieldName) {
        if ("protocols".equals(fieldName)) {
            return org.intermine.model.bio.Protocol.class;
        }
        if ("attributes".equals(fieldName)) {
            return org.intermine.model.bio.StudyDataAttribute.class;
        }
        if ("files".equals(fieldName)) {
            return org.intermine.model.bio.DataFile.class;
        }
        if (!org.intermine.model.bio.StudyData.class.equals(getClass())) {
            return TypeUtil.getElementType(org.intermine.model.bio.StudyData.class, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
}
