package org.intermine.model.bio;

import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.intermine.NotXmlParser;
import org.intermine.objectstore.intermine.NotXmlRenderer;
import org.intermine.objectstore.proxy.ProxyCollection;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.model.StringConstructor;
import org.intermine.metadata.TypeUtil;
import org.intermine.util.DynamicUtil;
import org.intermine.model.ShadowClass;

public class ProtocolShadow implements Protocol, ShadowClass
{
    public static final Class<Protocol> shadowOf = Protocol.class;
    // Attr: org.intermine.model.bio.Protocol.URI
    protected java.lang.String URI;
    public java.lang.String getuRI() { return URI; }
    public void setuRI(final java.lang.String URI) { this.URI = URI; }

    // Attr: org.intermine.model.bio.Protocol.description
    protected java.lang.String description;
    public java.lang.String getDescription() { return description; }
    public void setDescription(final java.lang.String description) { this.description = description; }

    // Attr: org.intermine.model.bio.Protocol.type
    protected java.lang.String type;
    public java.lang.String getType() { return type; }
    public void setType(final java.lang.String type) { this.type = type; }

    // Attr: org.intermine.model.bio.Protocol.name
    protected java.lang.String name;
    public java.lang.String getName() { return name; }
    public void setName(final java.lang.String name) { this.name = name; }

    // Attr: org.intermine.model.bio.Protocol.version
    protected java.lang.String version;
    public java.lang.String getVersion() { return version; }
    public void setVersion(final java.lang.String version) { this.version = version; }

    // Attr: org.intermine.model.bio.Protocol.step
    protected java.lang.Integer step;
    public java.lang.Integer getStep() { return step; }
    public void setStep(final java.lang.Integer step) { this.step = step; }

    // Ref: org.intermine.model.bio.Protocol.ontology
    protected org.intermine.model.InterMineObject ontology;
    public org.intermine.model.bio.OntologyTerm getOntology() { if (ontology instanceof org.intermine.objectstore.proxy.ProxyReference) { return ((org.intermine.model.bio.OntologyTerm) ((org.intermine.objectstore.proxy.ProxyReference) ontology).getObject()); }; return (org.intermine.model.bio.OntologyTerm) ontology; }
    public void setOntology(final org.intermine.model.bio.OntologyTerm ontology) { this.ontology = ontology; }
    public void proxyOntology(final org.intermine.objectstore.proxy.ProxyReference ontology) { this.ontology = ontology; }
    public org.intermine.model.InterMineObject proxGetOntology() { return ontology; }

    // Ref: org.intermine.model.bio.Protocol.study
    protected org.intermine.model.InterMineObject study;
    public org.intermine.model.bio.Study getStudy() { if (study instanceof org.intermine.objectstore.proxy.ProxyReference) { return ((org.intermine.model.bio.Study) ((org.intermine.objectstore.proxy.ProxyReference) study).getObject()); }; return (org.intermine.model.bio.Study) study; }
    public void setStudy(final org.intermine.model.bio.Study study) { this.study = study; }
    public void proxyStudy(final org.intermine.objectstore.proxy.ProxyReference study) { this.study = study; }
    public org.intermine.model.InterMineObject proxGetStudy() { return study; }

    // Ref: org.intermine.model.bio.Protocol.studyData
    protected org.intermine.model.InterMineObject studyData;
    public org.intermine.model.bio.StudyData getStudyData() { if (studyData instanceof org.intermine.objectstore.proxy.ProxyReference) { return ((org.intermine.model.bio.StudyData) ((org.intermine.objectstore.proxy.ProxyReference) studyData).getObject()); }; return (org.intermine.model.bio.StudyData) studyData; }
    public void setStudyData(final org.intermine.model.bio.StudyData studyData) { this.studyData = studyData; }
    public void proxyStudyData(final org.intermine.objectstore.proxy.ProxyReference studyData) { this.studyData = studyData; }
    public org.intermine.model.InterMineObject proxGetStudyData() { return studyData; }

    // Ref: org.intermine.model.bio.Protocol.dataFile
    protected org.intermine.model.InterMineObject dataFile;
    public org.intermine.model.bio.DataFile getDataFile() { if (dataFile instanceof org.intermine.objectstore.proxy.ProxyReference) { return ((org.intermine.model.bio.DataFile) ((org.intermine.objectstore.proxy.ProxyReference) dataFile).getObject()); }; return (org.intermine.model.bio.DataFile) dataFile; }
    public void setDataFile(final org.intermine.model.bio.DataFile dataFile) { this.dataFile = dataFile; }
    public void proxyDataFile(final org.intermine.objectstore.proxy.ProxyReference dataFile) { this.dataFile = dataFile; }
    public org.intermine.model.InterMineObject proxGetDataFile() { return dataFile; }

    // Col: org.intermine.model.bio.Protocol.parameters
    protected java.util.Set<org.intermine.model.bio.ProtocolParameter> parameters = new java.util.HashSet<org.intermine.model.bio.ProtocolParameter>();
    public java.util.Set<org.intermine.model.bio.ProtocolParameter> getParameters() { return parameters; }
    public void setParameters(final java.util.Set<org.intermine.model.bio.ProtocolParameter> parameters) { this.parameters = parameters; }
    public void addParameters(final org.intermine.model.bio.ProtocolParameter arg) { parameters.add(arg); }

    // Col: org.intermine.model.bio.Protocol.inputs
    protected java.util.Set<org.intermine.model.bio.StudyData> inputs = new java.util.HashSet<org.intermine.model.bio.StudyData>();
    public java.util.Set<org.intermine.model.bio.StudyData> getInputs() { return inputs; }
    public void setInputs(final java.util.Set<org.intermine.model.bio.StudyData> inputs) { this.inputs = inputs; }
    public void addInputs(final org.intermine.model.bio.StudyData arg) { inputs.add(arg); }

    // Col: org.intermine.model.bio.Protocol.outputs
    protected java.util.Set<org.intermine.model.bio.StudyData> outputs = new java.util.HashSet<org.intermine.model.bio.StudyData>();
    public java.util.Set<org.intermine.model.bio.StudyData> getOutputs() { return outputs; }
    public void setOutputs(final java.util.Set<org.intermine.model.bio.StudyData> outputs) { this.outputs = outputs; }
    public void addOutputs(final org.intermine.model.bio.StudyData arg) { outputs.add(arg); }

    // Attr: org.intermine.model.InterMineObject.id
    protected java.lang.Integer id;
    public java.lang.Integer getId() { return id; }
    public void setId(final java.lang.Integer id) { this.id = id; }

    @Override public boolean equals(Object o) { return (o instanceof Protocol && id != null) ? id.equals(((Protocol)o).getId()) : this == o; }
    @Override public int hashCode() { return (id != null) ? id.hashCode() : super.hashCode(); }
    @Override public String toString() { return "Protocol [URI=" + (URI == null ? "null" : "\"" + URI + "\"") + ", dataFile=" + (dataFile == null ? "null" : (dataFile.getId() == null ? "no id" : dataFile.getId().toString())) + ", description=" + (description == null ? "null" : "\"" + description + "\"") + ", id=" + id + ", name=" + (name == null ? "null" : "\"" + name + "\"") + ", ontology=" + (ontology == null ? "null" : (ontology.getId() == null ? "no id" : ontology.getId().toString())) + ", step=" + step + ", study=" + (study == null ? "null" : (study.getId() == null ? "no id" : study.getId().toString())) + ", studyData=" + (studyData == null ? "null" : (studyData.getId() == null ? "no id" : studyData.getId().toString())) + ", type=" + (type == null ? "null" : "\"" + type + "\"") + ", version=" + (version == null ? "null" : "\"" + version + "\"") + "]"; }
    public Object getFieldValue(final String fieldName) throws IllegalAccessException {
        if ("URI".equals(fieldName)) {
            return URI;
        }
        if ("description".equals(fieldName)) {
            return description;
        }
        if ("type".equals(fieldName)) {
            return type;
        }
        if ("name".equals(fieldName)) {
            return name;
        }
        if ("version".equals(fieldName)) {
            return version;
        }
        if ("step".equals(fieldName)) {
            return step;
        }
        if ("ontology".equals(fieldName)) {
            if (ontology instanceof ProxyReference) {
                return ((ProxyReference) ontology).getObject();
            } else {
                return ontology;
            }
        }
        if ("study".equals(fieldName)) {
            if (study instanceof ProxyReference) {
                return ((ProxyReference) study).getObject();
            } else {
                return study;
            }
        }
        if ("studyData".equals(fieldName)) {
            if (studyData instanceof ProxyReference) {
                return ((ProxyReference) studyData).getObject();
            } else {
                return studyData;
            }
        }
        if ("dataFile".equals(fieldName)) {
            if (dataFile instanceof ProxyReference) {
                return ((ProxyReference) dataFile).getObject();
            } else {
                return dataFile;
            }
        }
        if ("parameters".equals(fieldName)) {
            return parameters;
        }
        if ("inputs".equals(fieldName)) {
            return inputs;
        }
        if ("outputs".equals(fieldName)) {
            return outputs;
        }
        if ("id".equals(fieldName)) {
            return id;
        }
        if (!org.intermine.model.bio.Protocol.class.equals(getClass())) {
            return TypeUtil.getFieldValue(this, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
    public Object getFieldProxy(final String fieldName) throws IllegalAccessException {
        if ("URI".equals(fieldName)) {
            return URI;
        }
        if ("description".equals(fieldName)) {
            return description;
        }
        if ("type".equals(fieldName)) {
            return type;
        }
        if ("name".equals(fieldName)) {
            return name;
        }
        if ("version".equals(fieldName)) {
            return version;
        }
        if ("step".equals(fieldName)) {
            return step;
        }
        if ("ontology".equals(fieldName)) {
            return ontology;
        }
        if ("study".equals(fieldName)) {
            return study;
        }
        if ("studyData".equals(fieldName)) {
            return studyData;
        }
        if ("dataFile".equals(fieldName)) {
            return dataFile;
        }
        if ("parameters".equals(fieldName)) {
            return parameters;
        }
        if ("inputs".equals(fieldName)) {
            return inputs;
        }
        if ("outputs".equals(fieldName)) {
            return outputs;
        }
        if ("id".equals(fieldName)) {
            return id;
        }
        if (!org.intermine.model.bio.Protocol.class.equals(getClass())) {
            return TypeUtil.getFieldProxy(this, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
    public void setFieldValue(final String fieldName, final Object value) {
        if ("URI".equals(fieldName)) {
            URI = (java.lang.String) value;
        } else if ("description".equals(fieldName)) {
            description = (java.lang.String) value;
        } else if ("type".equals(fieldName)) {
            type = (java.lang.String) value;
        } else if ("name".equals(fieldName)) {
            name = (java.lang.String) value;
        } else if ("version".equals(fieldName)) {
            version = (java.lang.String) value;
        } else if ("step".equals(fieldName)) {
            step = (java.lang.Integer) value;
        } else if ("ontology".equals(fieldName)) {
            ontology = (org.intermine.model.InterMineObject) value;
        } else if ("study".equals(fieldName)) {
            study = (org.intermine.model.InterMineObject) value;
        } else if ("studyData".equals(fieldName)) {
            studyData = (org.intermine.model.InterMineObject) value;
        } else if ("dataFile".equals(fieldName)) {
            dataFile = (org.intermine.model.InterMineObject) value;
        } else if ("parameters".equals(fieldName)) {
            parameters = (java.util.Set) value;
        } else if ("inputs".equals(fieldName)) {
            inputs = (java.util.Set) value;
        } else if ("outputs".equals(fieldName)) {
            outputs = (java.util.Set) value;
        } else if ("id".equals(fieldName)) {
            id = (java.lang.Integer) value;
        } else {
            if (!org.intermine.model.bio.Protocol.class.equals(getClass())) {
                DynamicUtil.setFieldValue(this, fieldName, value);
                return;
            }
            throw new IllegalArgumentException("Unknown field " + fieldName);
        }
    }
    public Class<?> getFieldType(final String fieldName) {
        if ("URI".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("description".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("type".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("name".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("version".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("step".equals(fieldName)) {
            return java.lang.Integer.class;
        }
        if ("ontology".equals(fieldName)) {
            return org.intermine.model.bio.OntologyTerm.class;
        }
        if ("study".equals(fieldName)) {
            return org.intermine.model.bio.Study.class;
        }
        if ("studyData".equals(fieldName)) {
            return org.intermine.model.bio.StudyData.class;
        }
        if ("dataFile".equals(fieldName)) {
            return org.intermine.model.bio.DataFile.class;
        }
        if ("parameters".equals(fieldName)) {
            return java.util.Set.class;
        }
        if ("inputs".equals(fieldName)) {
            return java.util.Set.class;
        }
        if ("outputs".equals(fieldName)) {
            return java.util.Set.class;
        }
        if ("id".equals(fieldName)) {
            return java.lang.Integer.class;
        }
        if (!org.intermine.model.bio.Protocol.class.equals(getClass())) {
            return TypeUtil.getFieldType(org.intermine.model.bio.Protocol.class, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
    public StringConstructor getoBJECT() {
        if (!org.intermine.model.bio.ProtocolShadow.class.equals(getClass())) {
            return NotXmlRenderer.render(this);
        }
        StringConstructor sb = new StringConstructor();
        sb.append("$_^org.intermine.model.bio.Protocol");
        if (URI != null) {
            sb.append("$_^aURI$_^");
            String string = URI;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (description != null) {
            sb.append("$_^adescription$_^");
            String string = description;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (type != null) {
            sb.append("$_^atype$_^");
            String string = type;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (name != null) {
            sb.append("$_^aname$_^");
            String string = name;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (version != null) {
            sb.append("$_^aversion$_^");
            String string = version;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (step != null) {
            sb.append("$_^astep$_^").append(step);
        }
        if (ontology != null) {
            sb.append("$_^rontology$_^").append(ontology.getId());
        }
        if (study != null) {
            sb.append("$_^rstudy$_^").append(study.getId());
        }
        if (studyData != null) {
            sb.append("$_^rstudyData$_^").append(studyData.getId());
        }
        if (dataFile != null) {
            sb.append("$_^rdataFile$_^").append(dataFile.getId());
        }
        if (id != null) {
            sb.append("$_^aid$_^").append(id);
        }
        return sb;
    }
    public void setoBJECT(String notXml, ObjectStore os) {
        setoBJECT(NotXmlParser.SPLITTER.split(notXml), os);
    }
    public void setoBJECT(final String[] notXml, final ObjectStore os) {
        if (!org.intermine.model.bio.ProtocolShadow.class.equals(getClass())) {
            throw new IllegalStateException("Class " + getClass().getName() + " does not match code (org.intermine.model.bio.Protocol)");
        }
        for (int i = 2; i < notXml.length;) {
            int startI = i;
            if ((i < notXml.length) && "aURI".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                URI = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "adescription".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                description = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "atype".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                type = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "aname".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                name = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "aversion".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                version = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "astep".equals(notXml[i])) {
                i++;
                step = Integer.valueOf(notXml[i]);
                i++;
            }
            if ((i < notXml.length) &&"rontology".equals(notXml[i])) {
                i++;
                ontology = new ProxyReference(os, Integer.valueOf(notXml[i]), org.intermine.model.bio.OntologyTerm.class);
                i++;
            };
            if ((i < notXml.length) &&"rstudy".equals(notXml[i])) {
                i++;
                study = new ProxyReference(os, Integer.valueOf(notXml[i]), org.intermine.model.bio.Study.class);
                i++;
            };
            if ((i < notXml.length) &&"rstudyData".equals(notXml[i])) {
                i++;
                studyData = new ProxyReference(os, Integer.valueOf(notXml[i]), org.intermine.model.bio.StudyData.class);
                i++;
            };
            if ((i < notXml.length) &&"rdataFile".equals(notXml[i])) {
                i++;
                dataFile = new ProxyReference(os, Integer.valueOf(notXml[i]), org.intermine.model.bio.DataFile.class);
                i++;
            };
            if ((i < notXml.length) && "aid".equals(notXml[i])) {
                i++;
                id = Integer.valueOf(notXml[i]);
                i++;
            }
            if (startI == i) {
                throw new IllegalArgumentException("Unknown field " + notXml[i]);
            }
        }
        parameters = new ProxyCollection<org.intermine.model.bio.ProtocolParameter>(os, this, "parameters", org.intermine.model.bio.ProtocolParameter.class);
        inputs = new ProxyCollection<org.intermine.model.bio.StudyData>(os, this, "inputs", org.intermine.model.bio.StudyData.class);
        outputs = new ProxyCollection<org.intermine.model.bio.StudyData>(os, this, "outputs", org.intermine.model.bio.StudyData.class);
    }
    public void addCollectionElement(final String fieldName, final org.intermine.model.InterMineObject element) {
        if ("parameters".equals(fieldName)) {
            parameters.add((org.intermine.model.bio.ProtocolParameter) element);
        } else if ("inputs".equals(fieldName)) {
            inputs.add((org.intermine.model.bio.StudyData) element);
        } else if ("outputs".equals(fieldName)) {
            outputs.add((org.intermine.model.bio.StudyData) element);
        } else {
            if (!org.intermine.model.bio.Protocol.class.equals(getClass())) {
                TypeUtil.addCollectionElement(this, fieldName, element);
                return;
            }
            throw new IllegalArgumentException("Unknown collection " + fieldName);
        }
    }
    public Class<?> getElementType(final String fieldName) {
        if ("parameters".equals(fieldName)) {
            return org.intermine.model.bio.ProtocolParameter.class;
        }
        if ("inputs".equals(fieldName)) {
            return org.intermine.model.bio.StudyData.class;
        }
        if ("outputs".equals(fieldName)) {
            return org.intermine.model.bio.StudyData.class;
        }
        if (!org.intermine.model.bio.Protocol.class.equals(getClass())) {
            return TypeUtil.getElementType(org.intermine.model.bio.Protocol.class, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
}
