package org.intermine.model.bio;

import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.intermine.NotXmlParser;
import org.intermine.objectstore.intermine.NotXmlRenderer;
import org.intermine.objectstore.proxy.ProxyCollection;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.model.StringConstructor;
import org.intermine.metadata.TypeUtil;
import org.intermine.util.DynamicUtil;
import org.intermine.model.ShadowClass;

public class FactorShadow implements Factor, ShadowClass
{
    public static final Class<Factor> shadowOf = Factor.class;
    // Attr: org.intermine.model.bio.Factor.type
    protected java.lang.String type;
    public java.lang.String getType() { return type; }
    public void setType(final java.lang.String type) { this.type = type; }

    // Attr: org.intermine.model.bio.Factor.unit
    protected java.lang.String unit;
    public java.lang.String getUnit() { return unit; }
    public void setUnit(final java.lang.String unit) { this.unit = unit; }

    // Attr: org.intermine.model.bio.Factor.name
    protected java.lang.String name;
    public java.lang.String getName() { return name; }
    public void setName(final java.lang.String name) { this.name = name; }

    // Attr: org.intermine.model.bio.Factor.accession
    protected java.lang.String accession;
    public java.lang.String getAccession() { return accession; }
    public void setAccession(final java.lang.String accession) { this.accession = accession; }

    // Attr: org.intermine.model.bio.Factor.value
    protected java.lang.String value;
    public java.lang.String getValue() { return value; }
    public void setValue(final java.lang.String value) { this.value = value; }

    // Ref: org.intermine.model.bio.Factor.ontology
    protected org.intermine.model.InterMineObject ontology;
    public org.intermine.model.bio.OntologyTerm getOntology() { if (ontology instanceof org.intermine.objectstore.proxy.ProxyReference) { return ((org.intermine.model.bio.OntologyTerm) ((org.intermine.objectstore.proxy.ProxyReference) ontology).getObject()); }; return (org.intermine.model.bio.OntologyTerm) ontology; }
    public void setOntology(final org.intermine.model.bio.OntologyTerm ontology) { this.ontology = ontology; }
    public void proxyOntology(final org.intermine.objectstore.proxy.ProxyReference ontology) { this.ontology = ontology; }
    public org.intermine.model.InterMineObject proxGetOntology() { return ontology; }

    // Ref: org.intermine.model.bio.Factor.study
    protected org.intermine.model.InterMineObject study;
    public org.intermine.model.bio.Study getStudy() { if (study instanceof org.intermine.objectstore.proxy.ProxyReference) { return ((org.intermine.model.bio.Study) ((org.intermine.objectstore.proxy.ProxyReference) study).getObject()); }; return (org.intermine.model.bio.Study) study; }
    public void setStudy(final org.intermine.model.bio.Study study) { this.study = study; }
    public void proxyStudy(final org.intermine.objectstore.proxy.ProxyReference study) { this.study = study; }
    public org.intermine.model.InterMineObject proxGetStudy() { return study; }

    // Col: org.intermine.model.bio.Factor.studyData
    protected java.util.Set<org.intermine.model.bio.StudyData> studyData = new java.util.HashSet<org.intermine.model.bio.StudyData>();
    public java.util.Set<org.intermine.model.bio.StudyData> getStudyData() { return studyData; }
    public void setStudyData(final java.util.Set<org.intermine.model.bio.StudyData> studyData) { this.studyData = studyData; }
    public void addStudyData(final org.intermine.model.bio.StudyData arg) { studyData.add(arg); }

    // Attr: org.intermine.model.InterMineObject.id
    protected java.lang.Integer id;
    public java.lang.Integer getId() { return id; }
    public void setId(final java.lang.Integer id) { this.id = id; }

    @Override public boolean equals(Object o) { return (o instanceof Factor && id != null) ? id.equals(((Factor)o).getId()) : this == o; }
    @Override public int hashCode() { return (id != null) ? id.hashCode() : super.hashCode(); }
    @Override public String toString() { return "Factor [accession=" + (accession == null ? "null" : "\"" + accession + "\"") + ", id=" + id + ", name=" + (name == null ? "null" : "\"" + name + "\"") + ", ontology=" + (ontology == null ? "null" : (ontology.getId() == null ? "no id" : ontology.getId().toString())) + ", study=" + (study == null ? "null" : (study.getId() == null ? "no id" : study.getId().toString())) + ", type=" + (type == null ? "null" : "\"" + type + "\"") + ", unit=" + (unit == null ? "null" : "\"" + unit + "\"") + ", value=" + (value == null ? "null" : "\"" + value + "\"") + "]"; }
    public Object getFieldValue(final String fieldName) throws IllegalAccessException {
        if ("type".equals(fieldName)) {
            return type;
        }
        if ("unit".equals(fieldName)) {
            return unit;
        }
        if ("name".equals(fieldName)) {
            return name;
        }
        if ("accession".equals(fieldName)) {
            return accession;
        }
        if ("value".equals(fieldName)) {
            return value;
        }
        if ("ontology".equals(fieldName)) {
            if (ontology instanceof ProxyReference) {
                return ((ProxyReference) ontology).getObject();
            } else {
                return ontology;
            }
        }
        if ("study".equals(fieldName)) {
            if (study instanceof ProxyReference) {
                return ((ProxyReference) study).getObject();
            } else {
                return study;
            }
        }
        if ("studyData".equals(fieldName)) {
            return studyData;
        }
        if ("id".equals(fieldName)) {
            return id;
        }
        if (!org.intermine.model.bio.Factor.class.equals(getClass())) {
            return TypeUtil.getFieldValue(this, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
    public Object getFieldProxy(final String fieldName) throws IllegalAccessException {
        if ("type".equals(fieldName)) {
            return type;
        }
        if ("unit".equals(fieldName)) {
            return unit;
        }
        if ("name".equals(fieldName)) {
            return name;
        }
        if ("accession".equals(fieldName)) {
            return accession;
        }
        if ("value".equals(fieldName)) {
            return value;
        }
        if ("ontology".equals(fieldName)) {
            return ontology;
        }
        if ("study".equals(fieldName)) {
            return study;
        }
        if ("studyData".equals(fieldName)) {
            return studyData;
        }
        if ("id".equals(fieldName)) {
            return id;
        }
        if (!org.intermine.model.bio.Factor.class.equals(getClass())) {
            return TypeUtil.getFieldProxy(this, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
    public void setFieldValue(final String fieldName, final Object value) {
        if ("type".equals(fieldName)) {
            type = (java.lang.String) value;
        } else if ("unit".equals(fieldName)) {
            unit = (java.lang.String) value;
        } else if ("name".equals(fieldName)) {
            name = (java.lang.String) value;
        } else if ("accession".equals(fieldName)) {
            accession = (java.lang.String) value;
        } else if ("value".equals(fieldName)) {
            this.value = (java.lang.String) value;
        } else if ("ontology".equals(fieldName)) {
            ontology = (org.intermine.model.InterMineObject) value;
        } else if ("study".equals(fieldName)) {
            study = (org.intermine.model.InterMineObject) value;
        } else if ("studyData".equals(fieldName)) {
            studyData = (java.util.Set) value;
        } else if ("id".equals(fieldName)) {
            id = (java.lang.Integer) value;
        } else {
            if (!org.intermine.model.bio.Factor.class.equals(getClass())) {
                DynamicUtil.setFieldValue(this, fieldName, value);
                return;
            }
            throw new IllegalArgumentException("Unknown field " + fieldName);
        }
    }
    public Class<?> getFieldType(final String fieldName) {
        if ("type".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("unit".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("name".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("accession".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("value".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("ontology".equals(fieldName)) {
            return org.intermine.model.bio.OntologyTerm.class;
        }
        if ("study".equals(fieldName)) {
            return org.intermine.model.bio.Study.class;
        }
        if ("studyData".equals(fieldName)) {
            return java.util.Set.class;
        }
        if ("id".equals(fieldName)) {
            return java.lang.Integer.class;
        }
        if (!org.intermine.model.bio.Factor.class.equals(getClass())) {
            return TypeUtil.getFieldType(org.intermine.model.bio.Factor.class, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
    public StringConstructor getoBJECT() {
        if (!org.intermine.model.bio.FactorShadow.class.equals(getClass())) {
            return NotXmlRenderer.render(this);
        }
        StringConstructor sb = new StringConstructor();
        sb.append("$_^org.intermine.model.bio.Factor");
        if (type != null) {
            sb.append("$_^atype$_^");
            String string = type;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (unit != null) {
            sb.append("$_^aunit$_^");
            String string = unit;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (name != null) {
            sb.append("$_^aname$_^");
            String string = name;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (accession != null) {
            sb.append("$_^aaccession$_^");
            String string = accession;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (value != null) {
            sb.append("$_^avalue$_^");
            String string = value;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (ontology != null) {
            sb.append("$_^rontology$_^").append(ontology.getId());
        }
        if (study != null) {
            sb.append("$_^rstudy$_^").append(study.getId());
        }
        if (id != null) {
            sb.append("$_^aid$_^").append(id);
        }
        return sb;
    }
    public void setoBJECT(String notXml, ObjectStore os) {
        setoBJECT(NotXmlParser.SPLITTER.split(notXml), os);
    }
    public void setoBJECT(final String[] notXml, final ObjectStore os) {
        if (!org.intermine.model.bio.FactorShadow.class.equals(getClass())) {
            throw new IllegalStateException("Class " + getClass().getName() + " does not match code (org.intermine.model.bio.Factor)");
        }
        for (int i = 2; i < notXml.length;) {
            int startI = i;
            if ((i < notXml.length) && "atype".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                type = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "aunit".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                unit = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "aname".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                name = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "aaccession".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                accession = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "avalue".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                value = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) &&"rontology".equals(notXml[i])) {
                i++;
                ontology = new ProxyReference(os, Integer.valueOf(notXml[i]), org.intermine.model.bio.OntologyTerm.class);
                i++;
            };
            if ((i < notXml.length) &&"rstudy".equals(notXml[i])) {
                i++;
                study = new ProxyReference(os, Integer.valueOf(notXml[i]), org.intermine.model.bio.Study.class);
                i++;
            };
            if ((i < notXml.length) && "aid".equals(notXml[i])) {
                i++;
                id = Integer.valueOf(notXml[i]);
                i++;
            }
            if (startI == i) {
                throw new IllegalArgumentException("Unknown field " + notXml[i]);
            }
        }
        studyData = new ProxyCollection<org.intermine.model.bio.StudyData>(os, this, "studyData", org.intermine.model.bio.StudyData.class);
    }
    public void addCollectionElement(final String fieldName, final org.intermine.model.InterMineObject element) {
        if ("studyData".equals(fieldName)) {
            studyData.add((org.intermine.model.bio.StudyData) element);
        } else {
            if (!org.intermine.model.bio.Factor.class.equals(getClass())) {
                TypeUtil.addCollectionElement(this, fieldName, element);
                return;
            }
            throw new IllegalArgumentException("Unknown collection " + fieldName);
        }
    }
    public Class<?> getElementType(final String fieldName) {
        if ("studyData".equals(fieldName)) {
            return org.intermine.model.bio.StudyData.class;
        }
        if (!org.intermine.model.bio.Factor.class.equals(getClass())) {
            return TypeUtil.getElementType(org.intermine.model.bio.Factor.class, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
}
