package org.intermine.model.bio;

import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.intermine.NotXmlParser;
import org.intermine.objectstore.intermine.NotXmlRenderer;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.model.StringConstructor;
import org.intermine.metadata.TypeUtil;
import org.intermine.util.DynamicUtil;
import org.intermine.model.ShadowClass;

public class DataFileShadow implements DataFile, ShadowClass
{
    public static final Class<DataFile> shadowOf = DataFile.class;
    // Attr: org.intermine.model.bio.DataFile.type
    protected java.lang.String type;
    public java.lang.String getType() { return type; }
    public void setType(final java.lang.String type) { this.type = type; }

    // Attr: org.intermine.model.bio.DataFile.name
    protected java.lang.String name;
    public java.lang.String getName() { return name; }
    public void setName(final java.lang.String name) { this.name = name; }

    // Attr: org.intermine.model.bio.DataFile.value
    protected java.lang.String value;
    public java.lang.String getValue() { return value; }
    public void setValue(final java.lang.String value) { this.value = value; }

    // Ref: org.intermine.model.bio.DataFile.dataAttribute
    protected org.intermine.model.InterMineObject dataAttribute;
    public org.intermine.model.bio.StudyDataAttribute getDataAttribute() { if (dataAttribute instanceof org.intermine.objectstore.proxy.ProxyReference) { return ((org.intermine.model.bio.StudyDataAttribute) ((org.intermine.objectstore.proxy.ProxyReference) dataAttribute).getObject()); }; return (org.intermine.model.bio.StudyDataAttribute) dataAttribute; }
    public void setDataAttribute(final org.intermine.model.bio.StudyDataAttribute dataAttribute) { this.dataAttribute = dataAttribute; }
    public void proxyDataAttribute(final org.intermine.objectstore.proxy.ProxyReference dataAttribute) { this.dataAttribute = dataAttribute; }
    public org.intermine.model.InterMineObject proxGetDataAttribute() { return dataAttribute; }

    // Ref: org.intermine.model.bio.DataFile.study
    protected org.intermine.model.InterMineObject study;
    public org.intermine.model.bio.Study getStudy() { if (study instanceof org.intermine.objectstore.proxy.ProxyReference) { return ((org.intermine.model.bio.Study) ((org.intermine.objectstore.proxy.ProxyReference) study).getObject()); }; return (org.intermine.model.bio.Study) study; }
    public void setStudy(final org.intermine.model.bio.Study study) { this.study = study; }
    public void proxyStudy(final org.intermine.objectstore.proxy.ProxyReference study) { this.study = study; }
    public org.intermine.model.InterMineObject proxGetStudy() { return study; }

    // Ref: org.intermine.model.bio.DataFile.studyData
    protected org.intermine.model.InterMineObject studyData;
    public org.intermine.model.bio.StudyData getStudyData() { if (studyData instanceof org.intermine.objectstore.proxy.ProxyReference) { return ((org.intermine.model.bio.StudyData) ((org.intermine.objectstore.proxy.ProxyReference) studyData).getObject()); }; return (org.intermine.model.bio.StudyData) studyData; }
    public void setStudyData(final org.intermine.model.bio.StudyData studyData) { this.studyData = studyData; }
    public void proxyStudyData(final org.intermine.objectstore.proxy.ProxyReference studyData) { this.studyData = studyData; }
    public org.intermine.model.InterMineObject proxGetStudyData() { return studyData; }

    // Ref: org.intermine.model.bio.DataFile.protocol
    protected org.intermine.model.InterMineObject protocol;
    public org.intermine.model.bio.Protocol getProtocol() { if (protocol instanceof org.intermine.objectstore.proxy.ProxyReference) { return ((org.intermine.model.bio.Protocol) ((org.intermine.objectstore.proxy.ProxyReference) protocol).getObject()); }; return (org.intermine.model.bio.Protocol) protocol; }
    public void setProtocol(final org.intermine.model.bio.Protocol protocol) { this.protocol = protocol; }
    public void proxyProtocol(final org.intermine.objectstore.proxy.ProxyReference protocol) { this.protocol = protocol; }
    public org.intermine.model.InterMineObject proxGetProtocol() { return protocol; }

    // Attr: org.intermine.model.InterMineObject.id
    protected java.lang.Integer id;
    public java.lang.Integer getId() { return id; }
    public void setId(final java.lang.Integer id) { this.id = id; }

    @Override public boolean equals(Object o) { return (o instanceof DataFile && id != null) ? id.equals(((DataFile)o).getId()) : this == o; }
    @Override public int hashCode() { return (id != null) ? id.hashCode() : super.hashCode(); }
    @Override public String toString() { return "DataFile [dataAttribute=" + (dataAttribute == null ? "null" : (dataAttribute.getId() == null ? "no id" : dataAttribute.getId().toString())) + ", id=" + id + ", name=" + (name == null ? "null" : "\"" + name + "\"") + ", protocol=" + (protocol == null ? "null" : (protocol.getId() == null ? "no id" : protocol.getId().toString())) + ", study=" + (study == null ? "null" : (study.getId() == null ? "no id" : study.getId().toString())) + ", studyData=" + (studyData == null ? "null" : (studyData.getId() == null ? "no id" : studyData.getId().toString())) + ", type=" + (type == null ? "null" : "\"" + type + "\"") + ", value=" + (value == null ? "null" : "\"" + value + "\"") + "]"; }
    public Object getFieldValue(final String fieldName) throws IllegalAccessException {
        if ("type".equals(fieldName)) {
            return type;
        }
        if ("name".equals(fieldName)) {
            return name;
        }
        if ("value".equals(fieldName)) {
            return value;
        }
        if ("dataAttribute".equals(fieldName)) {
            if (dataAttribute instanceof ProxyReference) {
                return ((ProxyReference) dataAttribute).getObject();
            } else {
                return dataAttribute;
            }
        }
        if ("study".equals(fieldName)) {
            if (study instanceof ProxyReference) {
                return ((ProxyReference) study).getObject();
            } else {
                return study;
            }
        }
        if ("studyData".equals(fieldName)) {
            if (studyData instanceof ProxyReference) {
                return ((ProxyReference) studyData).getObject();
            } else {
                return studyData;
            }
        }
        if ("protocol".equals(fieldName)) {
            if (protocol instanceof ProxyReference) {
                return ((ProxyReference) protocol).getObject();
            } else {
                return protocol;
            }
        }
        if ("id".equals(fieldName)) {
            return id;
        }
        if (!org.intermine.model.bio.DataFile.class.equals(getClass())) {
            return TypeUtil.getFieldValue(this, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
    public Object getFieldProxy(final String fieldName) throws IllegalAccessException {
        if ("type".equals(fieldName)) {
            return type;
        }
        if ("name".equals(fieldName)) {
            return name;
        }
        if ("value".equals(fieldName)) {
            return value;
        }
        if ("dataAttribute".equals(fieldName)) {
            return dataAttribute;
        }
        if ("study".equals(fieldName)) {
            return study;
        }
        if ("studyData".equals(fieldName)) {
            return studyData;
        }
        if ("protocol".equals(fieldName)) {
            return protocol;
        }
        if ("id".equals(fieldName)) {
            return id;
        }
        if (!org.intermine.model.bio.DataFile.class.equals(getClass())) {
            return TypeUtil.getFieldProxy(this, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
    public void setFieldValue(final String fieldName, final Object value) {
        if ("type".equals(fieldName)) {
            type = (java.lang.String) value;
        } else if ("name".equals(fieldName)) {
            name = (java.lang.String) value;
        } else if ("value".equals(fieldName)) {
            this.value = (java.lang.String) value;
        } else if ("dataAttribute".equals(fieldName)) {
            dataAttribute = (org.intermine.model.InterMineObject) value;
        } else if ("study".equals(fieldName)) {
            study = (org.intermine.model.InterMineObject) value;
        } else if ("studyData".equals(fieldName)) {
            studyData = (org.intermine.model.InterMineObject) value;
        } else if ("protocol".equals(fieldName)) {
            protocol = (org.intermine.model.InterMineObject) value;
        } else if ("id".equals(fieldName)) {
            id = (java.lang.Integer) value;
        } else {
            if (!org.intermine.model.bio.DataFile.class.equals(getClass())) {
                DynamicUtil.setFieldValue(this, fieldName, value);
                return;
            }
            throw new IllegalArgumentException("Unknown field " + fieldName);
        }
    }
    public Class<?> getFieldType(final String fieldName) {
        if ("type".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("name".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("value".equals(fieldName)) {
            return java.lang.String.class;
        }
        if ("dataAttribute".equals(fieldName)) {
            return org.intermine.model.bio.StudyDataAttribute.class;
        }
        if ("study".equals(fieldName)) {
            return org.intermine.model.bio.Study.class;
        }
        if ("studyData".equals(fieldName)) {
            return org.intermine.model.bio.StudyData.class;
        }
        if ("protocol".equals(fieldName)) {
            return org.intermine.model.bio.Protocol.class;
        }
        if ("id".equals(fieldName)) {
            return java.lang.Integer.class;
        }
        if (!org.intermine.model.bio.DataFile.class.equals(getClass())) {
            return TypeUtil.getFieldType(org.intermine.model.bio.DataFile.class, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
    public StringConstructor getoBJECT() {
        if (!org.intermine.model.bio.DataFileShadow.class.equals(getClass())) {
            return NotXmlRenderer.render(this);
        }
        StringConstructor sb = new StringConstructor();
        sb.append("$_^org.intermine.model.bio.DataFile");
        if (type != null) {
            sb.append("$_^atype$_^");
            String string = type;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (name != null) {
            sb.append("$_^aname$_^");
            String string = name;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (value != null) {
            sb.append("$_^avalue$_^");
            String string = value;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                } else {
                    sb.append(string.substring(0, delimPosition + 3));
                    sb.append("d");
                    string = string.substring(delimPosition + 3);
                }
            }
        }
        if (dataAttribute != null) {
            sb.append("$_^rdataAttribute$_^").append(dataAttribute.getId());
        }
        if (study != null) {
            sb.append("$_^rstudy$_^").append(study.getId());
        }
        if (studyData != null) {
            sb.append("$_^rstudyData$_^").append(studyData.getId());
        }
        if (protocol != null) {
            sb.append("$_^rprotocol$_^").append(protocol.getId());
        }
        if (id != null) {
            sb.append("$_^aid$_^").append(id);
        }
        return sb;
    }
    public void setoBJECT(String notXml, ObjectStore os) {
        setoBJECT(NotXmlParser.SPLITTER.split(notXml), os);
    }
    public void setoBJECT(final String[] notXml, final ObjectStore os) {
        if (!org.intermine.model.bio.DataFileShadow.class.equals(getClass())) {
            throw new IllegalStateException("Class " + getClass().getName() + " does not match code (org.intermine.model.bio.DataFile)");
        }
        for (int i = 2; i < notXml.length;) {
            int startI = i;
            if ((i < notXml.length) && "atype".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                type = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "aname".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                name = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) && "avalue".equals(notXml[i])) {
                i++;
                StringBuilder string = null;
                while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {
                    if (string == null) string = new StringBuilder(notXml[i]);
                    i++;
                    string.append("$_^").append(notXml[i].substring(1));
                }
                value = string == null ? notXml[i] : string.toString();
                i++;
            }
            if ((i < notXml.length) &&"rdataAttribute".equals(notXml[i])) {
                i++;
                dataAttribute = new ProxyReference(os, Integer.valueOf(notXml[i]), org.intermine.model.bio.StudyDataAttribute.class);
                i++;
            };
            if ((i < notXml.length) &&"rstudy".equals(notXml[i])) {
                i++;
                study = new ProxyReference(os, Integer.valueOf(notXml[i]), org.intermine.model.bio.Study.class);
                i++;
            };
            if ((i < notXml.length) &&"rstudyData".equals(notXml[i])) {
                i++;
                studyData = new ProxyReference(os, Integer.valueOf(notXml[i]), org.intermine.model.bio.StudyData.class);
                i++;
            };
            if ((i < notXml.length) &&"rprotocol".equals(notXml[i])) {
                i++;
                protocol = new ProxyReference(os, Integer.valueOf(notXml[i]), org.intermine.model.bio.Protocol.class);
                i++;
            };
            if ((i < notXml.length) && "aid".equals(notXml[i])) {
                i++;
                id = Integer.valueOf(notXml[i]);
                i++;
            }
            if (startI == i) {
                throw new IllegalArgumentException("Unknown field " + notXml[i]);
            }
        }
    }
    public void addCollectionElement(final String fieldName, final org.intermine.model.InterMineObject element) {
        {
            if (!org.intermine.model.bio.DataFile.class.equals(getClass())) {
                TypeUtil.addCollectionElement(this, fieldName, element);
                return;
            }
            throw new IllegalArgumentException("Unknown collection " + fieldName);
        }
    }
    public Class<?> getElementType(final String fieldName) {
        if (!org.intermine.model.bio.DataFile.class.equals(getClass())) {
            return TypeUtil.getElementType(org.intermine.model.bio.DataFile.class, fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
}
