/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.postprocess;

import java.sql.SQLException;
import org.intermine.bio.util.PostProcessUtil;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStoreWriter;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.objectstore.intermine.ObjectStoreWriterInterMineImpl;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.postprocess.PostProcessor;
import org.intermine.sql.Database;
import org.intermine.sql.DatabaseUtil;
import org.intermine.util.DynamicUtil;

public class CreateUTRReferencesProcess
extends PostProcessor {
    public CreateUTRReferencesProcess(ObjectStoreWriter osw) {
        super(osw);
    }

    public void postProcess() throws ObjectStoreException {
        Model model = Model.getInstanceByName((String)"genomic");
        Query q = new Query();
        q.setDistinct(false);
        QueryClass qcMRNA = new QueryClass(model.getClassDescriptorByName("MRNA").getType());
        q.addFrom((FromElement)qcMRNA);
        q.addToSelect((QuerySelectable)qcMRNA);
        q.addToOrderBy((QueryOrderable)qcMRNA);
        QueryClass qcUTR = new QueryClass(model.getClassDescriptorByName("UTR").getType());
        q.addFrom((FromElement)qcUTR);
        q.addToSelect((QuerySelectable)qcUTR);
        q.addToOrderBy((QueryOrderable)qcUTR);
        QueryCollectionReference mrnaUtrsRef = new QueryCollectionReference(qcMRNA, "UTRs");
        ContainsConstraint mrnaUtrsConstraint = new ContainsConstraint((QueryReference)mrnaUtrsRef, ConstraintOp.CONTAINS, qcUTR);
        QueryObjectReference fivePrimeRef = new QueryObjectReference(qcMRNA, "fivePrimeUTR");
        ContainsConstraint fivePrimeNullConstraint = new ContainsConstraint((QueryReference)fivePrimeRef, ConstraintOp.IS_NULL);
        QueryObjectReference threePrimeRef = new QueryObjectReference(qcMRNA, "threePrimeUTR");
        ContainsConstraint threePrimeNullConstraint = new ContainsConstraint((QueryReference)threePrimeRef, ConstraintOp.IS_NULL);
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        cs.addConstraint((Constraint)mrnaUtrsConstraint);
        cs.addConstraint((Constraint)fivePrimeNullConstraint);
        cs.addConstraint((Constraint)threePrimeNullConstraint);
        q.setConstraint((Constraint)cs);
        ObjectStore os = this.osw.getObjectStore();
        ((ObjectStoreInterMineImpl)os).precompute(q, "precompute");
        Results res = os.execute(q, 500, true, true, true);
        InterMineObject lastMRNA = null;
        InterMineObject fivePrimeUTR = null;
        InterMineObject threePrimeUTR = null;
        this.osw.beginTransaction();
        Class fivePrimeUTRCls = model.getClassDescriptorByName("FivePrimeUTR").getType();
        for (ResultsRow rr : res) {
            InterMineObject mrna = (InterMineObject)rr.get(0);
            InterMineObject utr = (InterMineObject)rr.get(1);
            if (lastMRNA != null && !mrna.getId().equals(lastMRNA.getId())) {
                try {
                    InterMineObject tempMRNA = PostProcessUtil.cloneInterMineObject((InterMineObject)lastMRNA);
                    if (fivePrimeUTR != null) {
                        tempMRNA.setFieldValue("fivePrimeUTR", (Object)fivePrimeUTR);
                        fivePrimeUTR = null;
                    }
                    if (threePrimeUTR != null) {
                        tempMRNA.setFieldValue("threePrimeUTR", (Object)threePrimeUTR);
                        threePrimeUTR = null;
                    }
                    this.osw.store((Object)tempMRNA);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to clone mRNA object:" + e);
                }
            }
            if (DynamicUtil.isInstance((Object)utr, (Class)fivePrimeUTRCls)) {
                fivePrimeUTR = utr;
            } else {
                threePrimeUTR = utr;
            }
            lastMRNA = mrna;
        }
        if (lastMRNA != null) {
            try {
                InterMineObject tempMRNA = PostProcessUtil.cloneInterMineObject(lastMRNA);
                tempMRNA.setFieldValue("fivePrimeUTR", fivePrimeUTR);
                tempMRNA.setFieldValue("threePrimeUTR", threePrimeUTR);
                this.osw.store((Object)tempMRNA);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to clone mRNA object: " + e);
            }
        }
        this.osw.commitTransaction();
        if (this.osw instanceof ObjectStoreWriterInterMineImpl) {
            ClassDescriptor cld = model.getClassDescriptorByName("MRNA");
            try {
                DatabaseUtil.analyse((Database)((ObjectStoreWriterInterMineImpl)this.osw).getDatabase(), (ClassDescriptor)cld, (boolean)false);
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to analyse database: " + e);
            }
        }
    }
}

