/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.jsr330;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.inject.Singleton;
import org.int4.dirk.annotations.Opt;
import org.int4.dirk.annotations.Produces;
import org.int4.dirk.api.Injector;
import org.int4.dirk.core.StandardInjector;
import org.int4.dirk.jsr330.AssistedTypeRegistrationExtensionSupport;
import org.int4.dirk.jsr330.ByteBuddyProxyStrategySupport;
import org.int4.dirk.jsr330.Dependent;
import org.int4.dirk.library.AnnotationBasedLifeCycleCallbacksFactory;
import org.int4.dirk.library.ConfigurableAnnotationStrategy;
import org.int4.dirk.library.DefaultInjectorStrategy;
import org.int4.dirk.library.ListInjectionTargetExtension;
import org.int4.dirk.library.NoProxyStrategy;
import org.int4.dirk.library.ProducesTypeRegistrationExtension;
import org.int4.dirk.library.ProviderInjectionTargetExtension;
import org.int4.dirk.library.ProviderTypeRegistrationExtension;
import org.int4.dirk.library.SetInjectionTargetExtension;
import org.int4.dirk.library.SimpleScopeStrategy;
import org.int4.dirk.library.SingletonScopeResolver;
import org.int4.dirk.spi.config.AnnotationStrategy;
import org.int4.dirk.spi.config.InjectorStrategy;
import org.int4.dirk.spi.config.LifeCycleCallbacksFactory;
import org.int4.dirk.spi.config.ProxyStrategy;
import org.int4.dirk.spi.config.ScopeStrategy;
import org.int4.dirk.spi.definition.TypeRegistrationExtension;
import org.int4.dirk.spi.instantiation.InjectionTargetExtension;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.int4.dirk.util.Annotations;
import org.int4.dirk.util.Classes;

public class Injectors {
    private static final Logger LOGGER = Logger.getLogger(Injectors.class.getName());
    private static final Singleton SINGLETON = (Singleton)Annotations.of(Singleton.class);
    private static final Dependent DEPENDENT = (Dependent)Annotations.of(Dependent.class);
    private static final AnnotationStrategy ANNOTATION_STRATEGY = new ConfigurableAnnotationStrategy(Inject.class, Qualifier.class, Opt.class);
    private static final Method PROVIDER_METHOD;

    public static Injector autoDiscovering(ScopeResolver ... scopeResolvers) {
        return Injectors.createInjector(true, scopeResolvers);
    }

    public static Injector manual(ScopeResolver ... scopeResolvers) {
        return Injectors.createInjector(false, scopeResolvers);
    }

    private static Injector createInjector(boolean autoDiscovering, ScopeResolver ... scopeResolvers) {
        AnnotationBasedLifeCycleCallbacksFactory lifeCycleCallbacksFactory = new AnnotationBasedLifeCycleCallbacksFactory(PostConstruct.class, PreDestroy.class);
        List<ScopeResolver> finalScopeResolvers = Arrays.stream(scopeResolvers).anyMatch(sr -> sr.getAnnotation().equals(SINGLETON)) ? Arrays.asList(scopeResolvers) : Stream.concat(Arrays.stream(scopeResolvers), Stream.of(new SingletonScopeResolver((Annotation)SINGLETON))).collect(Collectors.toList());
        NoProxyStrategy proxyStrategy = new NoProxyStrategy();
        if (Classes.isAvailable((String)"org.int4.dirk.extensions.proxy.ByteBuddyProxyStrategy")) {
            LOGGER.info("Using ByteBuddyProxyStrategy found on classpath");
            proxyStrategy = ByteBuddyProxyStrategySupport.create();
        }
        return new StandardInjector(Injectors.createInjectionTargetExtensions(), Injectors.createDiscoveryExtensions((LifeCycleCallbacksFactory)lifeCycleCallbacksFactory), finalScopeResolvers, (InjectorStrategy)new DefaultInjectorStrategy(ANNOTATION_STRATEGY, (ScopeStrategy)new SimpleScopeStrategy(Scope.class, (Annotation)DEPENDENT, (Annotation)SINGLETON, (Annotation)DEPENDENT), (ProxyStrategy)proxyStrategy, (LifeCycleCallbacksFactory)lifeCycleCallbacksFactory), autoDiscovering);
    }

    private static List<InjectionTargetExtension<?, ?>> createInjectionTargetExtensions() {
        return List.of(new ListInjectionTargetExtension(), new SetInjectionTargetExtension(), new ProviderInjectionTargetExtension(Provider.class, s -> ((Supplier)s)::get));
    }

    private static List<TypeRegistrationExtension> createDiscoveryExtensions(LifeCycleCallbacksFactory lifeCycleCallbacksFactory) {
        ArrayList<TypeRegistrationExtension> extensions = new ArrayList<TypeRegistrationExtension>();
        extensions.add((TypeRegistrationExtension)new ProviderTypeRegistrationExtension(PROVIDER_METHOD));
        extensions.add((TypeRegistrationExtension)new ProducesTypeRegistrationExtension(Produces.class));
        if (Classes.isAvailable((String)"org.int4.dirk.extensions.assisted.AssistedTypeRegistrationExtension")) {
            LOGGER.info("Using AssistedTypeRegistrationExtension found on classpath");
            extensions.add(AssistedTypeRegistrationExtensionSupport.create(ANNOTATION_STRATEGY, lifeCycleCallbacksFactory));
        }
        return extensions;
    }

    static {
        try {
            PROVIDER_METHOD = Provider.class.getDeclaredMethod("get", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }
}

