/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb;

import okhttp3.OkHttpClient;
import org.influxdb.InfluxDB;
import org.influxdb.com.google.guava.base.Preconditions;
import org.influxdb.com.google.guava.base.Strings;
import org.influxdb.impl.InfluxDBImpl;

public enum InfluxDBFactory {
    INSTANCE;


    public static InfluxDB connect(String url) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(url), "The URL may not be null or empty.");
        return new InfluxDBImpl(url, null, null, new OkHttpClient.Builder());
    }

    public static InfluxDB connect(String url, String username, String password) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(url), "The URL may not be null or empty.");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(username), "The username may not be null or empty.");
        return new InfluxDBImpl(url, username, password, new OkHttpClient.Builder());
    }

    public static InfluxDB connect(String url, OkHttpClient.Builder client) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(url), "The URL may not be null or empty.");
        Preconditions.checkNotNull(client, "The client may not be null.");
        return new InfluxDBImpl(url, null, null, client);
    }

    public static InfluxDB connect(String url, String username, String password, OkHttpClient.Builder client) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(url), "The URL may not be null or empty.");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(username), "The username may not be null or empty.");
        Preconditions.checkNotNull(client, "The client may not be null.");
        return new InfluxDBImpl(url, username, password, client);
    }
}

