/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb;

import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.influxdb.BatchOptions;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;

public interface InfluxDB {
    public static final String LOG_LEVEL_PROPERTY = "org.influxdb.InfluxDB.logLevel";

    public InfluxDB setLogLevel(LogLevel var1);

    public InfluxDB enableGzip();

    public InfluxDB disableGzip();

    public boolean isGzipEnabled();

    public InfluxDB enableBatch();

    public InfluxDB enableBatch(BatchOptions var1);

    public InfluxDB enableBatch(int var1, int var2, TimeUnit var3);

    public InfluxDB enableBatch(int var1, int var2, TimeUnit var3, ThreadFactory var4);

    public InfluxDB enableBatch(int var1, int var2, TimeUnit var3, ThreadFactory var4, BiConsumer<Iterable<Point>, Throwable> var5, ConsistencyLevel var6);

    public InfluxDB enableBatch(int var1, int var2, TimeUnit var3, ThreadFactory var4, BiConsumer<Iterable<Point>, Throwable> var5);

    public void disableBatch();

    public boolean isBatchEnabled();

    public Pong ping();

    public String version();

    public void write(Point var1);

    public void write(String var1);

    public void write(List<String> var1);

    public void write(String var1, String var2, Point var3);

    public void write(int var1, Point var2);

    public void write(BatchPoints var1);

    public void write(String var1, String var2, ConsistencyLevel var3, String var4);

    public void write(String var1, String var2, ConsistencyLevel var3, TimeUnit var4, String var5);

    public void write(String var1, String var2, ConsistencyLevel var3, List<String> var4);

    public void write(String var1, String var2, ConsistencyLevel var3, TimeUnit var4, List<String> var5);

    public void write(int var1, String var2);

    public void write(int var1, List<String> var2);

    public QueryResult query(Query var1);

    public void query(Query var1, Consumer<QueryResult> var2, Consumer<Throwable> var3);

    public void query(Query var1, int var2, Consumer<QueryResult> var3);

    public QueryResult query(Query var1, TimeUnit var2);

    @Deprecated
    public void createDatabase(String var1);

    @Deprecated
    public void deleteDatabase(String var1);

    @Deprecated
    public List<String> describeDatabases();

    @Deprecated
    public boolean databaseExists(String var1);

    public void flush();

    public void close();

    public InfluxDB setConsistency(ConsistencyLevel var1);

    public InfluxDB setDatabase(String var1);

    public InfluxDB setRetentionPolicy(String var1);

    @Deprecated
    public void createRetentionPolicy(String var1, String var2, String var3, String var4, int var5, boolean var6);

    @Deprecated
    public void createRetentionPolicy(String var1, String var2, String var3, int var4, boolean var5);

    @Deprecated
    public void createRetentionPolicy(String var1, String var2, String var3, String var4, int var5);

    @Deprecated
    public void dropRetentionPolicy(String var1, String var2);

    public static enum ConsistencyLevel {
        ALL("all"),
        ANY("any"),
        ONE("one"),
        QUORUM("quorum");

        private final String value;

        private ConsistencyLevel(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum LogLevel {
        NONE,
        BASIC,
        HEADERS,
        FULL;


        public static LogLevel parseLogLevel(String value) {
            LogLevel logLevel = NONE;
            if (value != null) {
                try {
                    logLevel = LogLevel.valueOf(value.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return logLevel;
        }
    }
}

