/*
 * Decompiled with CFR 0.152.
 */
package org.infinitenature.herbariorum.helper;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.infinitenature.herbariorum.helper.Country;
import org.infinitenature.herbariorum.helper.UTF8Control;

public class Translator {
    private static final String BUNDLE_NAME = "translator_resources";
    private Map<String, String> englishToGerman;
    private Map<String, String> germanToEnglish;
    private Map<Country, String> enumToGerman;
    private Map<Country, String> enumToEnglish;

    public Translator() {
        ResourceBundle germanBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.GERMANY, new UTF8Control());
        ResourceBundle englishBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.UK, new UTF8Control());
        this.englishToGerman = new HashMap<String, String>();
        this.germanToEnglish = new HashMap<String, String>();
        this.enumToGerman = new EnumMap<Country, String>(Country.class);
        this.enumToEnglish = new EnumMap<Country, String>(Country.class);
        for (Country country : Country.values()) {
            String english = this.getString(country.name(), englishBundle);
            String german = this.getString(country.name(), germanBundle);
            this.englishToGerman.put(english, german);
            this.germanToEnglish.put(german, english);
            this.enumToGerman.put(country, german);
            this.enumToEnglish.put(country, english);
        }
    }

    public String translateEnglishToGerman(String english) {
        if (this.englishToGerman.containsKey(english)) {
            return this.englishToGerman.get(english);
        }
        return english;
    }

    public String translateGermanToEnglish(String german) {
        if (this.germanToEnglish.containsKey(german)) {
            return this.germanToEnglish.get(german);
        }
        return german;
    }

    private String getString(String key, ResourceBundle bundle) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public Collection<String> getAllCountriesInGerman() {
        return this.englishToGerman.values();
    }

    public Collection<String> getAllCountriesInEnglish() {
        return this.germanToEnglish.values();
    }

    public String getCountryInGerman(Country country) {
        return this.enumToGerman.get((Object)country);
    }

    public String getCountryInEnglish(Country country) {
        return this.enumToEnglish.get((Object)country);
    }
}

