/*
 * Decompiled with CFR 0.152.
 */
package org.infinitenature.herbariorum.entities;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.ws.rs.BeanParam;
import javax.ws.rs.QueryParam;
import org.infinitenature.herbariorum.entities.Address;
import org.infinitenature.herbariorum.entities.Contact;
import org.infinitenature.herbariorum.entities.Location;

public class Institution {
    @QueryParam(value="irn")
    private int irn;
    @QueryParam(value="organization")
    private String organization;
    @QueryParam(value="code")
    private String code;
    @QueryParam(value="division")
    private String division;
    @QueryParam(value="department")
    private String department;
    @QueryParam(value="specimenTotal")
    private int specimenTotal;
    @BeanParam
    private Address address;
    @BeanParam
    private Contact contact;
    @BeanParam
    private Location location;
    @QueryParam(value="dateModified")
    private LocalDate dateModified;

    public int getIrn() {
        return this.irn;
    }

    public void setIrn(int irn) {
        this.irn = irn;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization != null ? organization.trim() : organization;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDivision() {
        return this.division;
    }

    public void setDivision(String division) {
        this.division = division;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public int getSpecimenTotal() {
        return this.specimenTotal;
    }

    public void setSpecimenTotal(int specimenTotal) {
        this.specimenTotal = specimenTotal;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public LocalDate getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(String dateModified) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        this.dateModified = LocalDate.parse(dateModified, dateTimeFormatter);
    }

    public String toString() {
        if (this.getOrganization() == null) {
            return "";
        }
        if (this.getAddress() == null) {
            return this.getOrganization();
        }
        return this.getOrganization() + ", " + this.getAddress().getPostalCity();
    }
}

